/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.exception.task.TaskNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskService;
import org.thingsboard.trendz.service.task.job.FilterRequestJob;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskReferencedEntityType;

@Controller
@RequestMapping(value={"/apiTrendz/filter"})
public class FilterController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FilterController.class);
    private final TaskService taskService;

    @Autowired
    public FilterController(TaskService taskService) {
        this.taskService = taskService;
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/processOptions"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> processOptions(@RequestBody ViewConfig viewConfig) {
        JwtSecurityUser user = this.getSecurityUser();
        String referenceKey = viewConfig.getId() == null ? user.getTenantCustomerKey() : viewConfig.getId().toString();
        TaskReference reference = new TaskReference(TaskReferencedEntityType.VIEW_CONFIG_FILTER_REQUEST, referenceKey);
        Task task = (Task)this.taskService.findTaskByReferencedEntity(user, reference, true).orElseThrow(() -> new TaskNotFoundException(reference));
        FilterRequestJob job = FilterRequestJob.builder().viewConfig(viewConfig).build();
        UUID executionId = this.taskService.runExecution(user, task.getId(), (TaskJob)job, false, true);
        return ResponseEntity.ok((Object)executionId);
    }
}

