/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.anomaly.AnomalyModel;
import org.thingsboard.trendz.domain.anomaly.AnomalyReprocessRequest;
import org.thingsboard.trendz.domain.anomaly.DatasetConfig;
import org.thingsboard.trendz.domain.anomaly.ItemDataFilter;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.exception.task.TaskNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.model.anomaly.AnomalyModelService;
import org.thingsboard.trendz.service.model.anomaly.AnomalyService;
import org.thingsboard.trendz.service.model.anomaly.components.AnomalyFilter;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskService;
import org.thingsboard.trendz.service.task.job.AnomalyModelReprocessJob;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskReferencedEntityType;
import org.thingsboard.trendz.tools.UUIDUtils;

@RestController
@RequestMapping(value={"/apiTrendz/anomaly"})
public class AnomalyController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnomalyController.class);
    private final AnomalyService anomalyService;
    private final AnomalyModelService anomalyModelService;
    private final TaskService taskService;

    @Autowired
    public AnomalyController(AnomalyService anomalyService, AnomalyModelService anomalyModelService, TaskService taskService) {
        this.anomalyService = anomalyService;
        this.anomalyModelService = anomalyModelService;
        this.taskService = taskService;
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/reprocess/{modelId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> discoverAnomalies(@PathVariable(value="modelId") String modelIdStr, @RequestBody AnomalyReprocessRequest anomalyReprocessRequest) {
        JwtSecurityUser user = this.getSecurityUser();
        UUID modelId = UUIDUtils.parse((String)modelIdStr);
        TaskReference reference = new TaskReference(TaskReferencedEntityType.ANOMALY_MODEL_REPROCESS, modelId.toString());
        AnomalyModelReprocessJob job = AnomalyModelReprocessJob.builder().modelId(modelId).anomalyReprocessRequest(anomalyReprocessRequest).build();
        Task task = (Task)this.taskService.findTaskByReferencedEntity(user, reference).orElseThrow(() -> new TaskNotFoundException(reference));
        UUID executionId = this.taskService.runExecution(user, task.getId(), (TaskJob)job, false);
        return ResponseEntity.ok((Object)executionId);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/get"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> findAnomaliesByFilter(@RequestBody AnomalyFilter filter) {
        List anomalies = this.anomalyService.findAnomaliesByFilter(filter);
        return ResponseEntity.ok((Object)anomalies);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/itemPoints"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> getItemFieldValues(@RequestBody ItemDataFilter filter) {
        JwtSecurityUser user = this.getSecurityUser();
        UUID modelId = filter.getModelId();
        AnomalyModel anomalyModel = this.anomalyModelService.getModelByIdOrThrow(user, modelId, true);
        DatasetConfig datasetConfig = anomalyModel.getDatasetConfig();
        datasetConfig.setStartTs(filter.getStartTs());
        datasetConfig.setEndTs(filter.getEndTs());
        datasetConfig.setItemSet((Set)Sets.newHashSet((Object[])new ItemLite[]{filter.getItemLite()}));
        Map itemFieldValues = this.anomalyService.getItemFieldValues(user, datasetConfig);
        return ResponseEntity.ok((Object)itemFieldValues);
    }
}

