/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.thingsboard.trendz.interceptor.StaticResourceProcessingInterceptor;
import org.thingsboard.trendz.interceptor.TrackingInterceptor;
import org.thingsboard.trendz.interceptor.WhitelabelingRedirectionInterceptor;

@Configuration
public class WebMvcConfig
implements WebMvcConfigurer {
    private final WhitelabelingRedirectionInterceptor whitelabelingRedirectionInterceptor;
    private final TrackingInterceptor trackingInterceptor;
    private final StaticResourceProcessingInterceptor staticResourceProcessingInterceptor;

    @Autowired
    public WebMvcConfig(WhitelabelingRedirectionInterceptor whitelabelingRedirectionInterceptor, TrackingInterceptor trackingInterceptor, StaticResourceProcessingInterceptor staticResourceProcessingInterceptor) {
        this.whitelabelingRedirectionInterceptor = whitelabelingRedirectionInterceptor;
        this.trackingInterceptor = trackingInterceptor;
        this.staticResourceProcessingInterceptor = staticResourceProcessingInterceptor;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.whitelabelingRedirectionInterceptor).addPathPatterns(new String[]{"/**"}).excludePathPatterns(new String[]{"/apiTrendz/**"});
        registry.addInterceptor((HandlerInterceptor)this.trackingInterceptor).addPathPatterns(new String[]{"/apiTrendz/**"});
        registry.addInterceptor((HandlerInterceptor)this.staticResourceProcessingInterceptor).addPathPatterns(new String[]{"/**"}).excludePathPatterns(new String[]{"/apiTrendz/**"});
    }
}

