CREATE TABLE IF NOT EXISTS metric_exploration(
    id                          UUID NOT NULL CONSTRAINT metric_exploration_pkey PRIMARY KEY,

    tenant_id                   UUID NOT NULL,
    customer_id                 UUID NOT NULL,

    item_id                     UUID NOT NULL,
    item_name                   VARCHAR(256) NOT NULL,

    business_entity_id          UUID NOT NULL,
    business_entity_field_id    UUID NOT NULL,
    metric_definition_id        UUID NOT NULL,

    exploration_ts              BIGINT NOT NULL,

    CONSTRAINT metric_exploration_raw_unique UNIQUE (
        tenant_id, customer_id, item_id, business_entity_id, business_entity_field_id, metric_definition_id
    )
);

ALTER TABLE cluster_model
    ADD COLUMN IF NOT EXISTS update_ts BIGINT;

UPDATE cluster_model
SET create_ts = EXTRACT(EPOCH FROM NOW())::BIGINT
WHERE create_ts IS NULL;

UPDATE cluster_model
SET update_ts = create_ts
WHERE update_ts IS NULL;

ALTER TABLE cluster_model
    ALTER COLUMN create_ts SET NOT NULL;
ALTER TABLE cluster_model
    ALTER COLUMN update_ts SET NOT NULL;

UPDATE llm_config
SET model_name = 'gemini-2.0-flash-lite'
WHERE model_name = 'gemini-1.5-flash' OR model_name = 'gemini-1.5-pro'
