let $scope;

self.actionSources = function () {
  return {
    'rowClick': {
      name: 'widget-action.row-click',
      multiple: false
    },
    'dateSelected': {
      name: 'date-selected',
      multiple: false
    },
    'changedRadioButton': {
      name: 'changed-radio-button',
      multiple: false
    }
  };
}

self.onInit = function () {
  $scope = self.ctx.$scope;
  $scope.ctx = self.ctx;
  $scope.jwt = self.getJwtToken();
  $scope.jwtRefresh = self.getRefreshToken();
  $scope.inited = false;

  $scope.getJwtToken = self.getJwtToken;
  $scope.ctx.getJwtToken = self.getJwtToken;

  $scope.getRefreshToken = self.getRefreshToken;
  $scope.ctx.getRefreshToken = self.getRefreshToken;

  $scope.onDataChannleInit = self.onDataChannleInit;
  $scope.ctx.onDataChannleInit = self.onDataChannleInit;

  self.ctx.jwt = $scope.jwt;

  settings = JSON.parse(JSON.stringify($scope.ctx.settings)) || {};
  if(!settings.viewUrl || settings.viewUrl === 'http://localhost:4200/viewMode/{id}/') {
    $scope.inited = false;
  } else {
    $scope.inited = true;
  }

  console.log('widgetJwt', self.getJwtToken());
  console.log('widgetRefresh', self.getRefreshToken());
}

self.onDataUpdated = function() {

}

self.onDestroy = function () {
}

self.onEditModeChanged = function (e) {
  console.log('edit mode changed', e, self.ctx.isEdit, self.ctx);
}

self.onResize = function () {
  console.log('on resize');
  if ($scope.subscriptionService) {
    $scope.subscriptionService.emit('parentResize', 'tb_dashboard', 'onResizeEvent');
    console.log('on resize transfered');
  }
}

self.onDataChannleInit = function (subscriptionService) {
  console.log('service received', subscriptionService);
  $scope.subscriptionService = subscriptionService;
}


self.getRefreshToken = function () {
  let jwtToken = localStorage.getItem('refresh_token');
  if (jwtToken) {
    jwtToken = jwtToken.replace(/"/g, '');
    return jwtToken;
  }

  return 'unknwown';
}

self.getJwtToken = function () {
  let jwtToken = localStorage.getItem('jwt_token');
  if (jwtToken) {
    jwtToken = jwtToken.replace(/"/g, '');
    return jwtToken;
  }

  return 'unknwown';
}
