/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.tools.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonRawSerializer
extends JsonSerializer<String> {
    public void serialize(String value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value == null) {
            gen.writeNull();
        } else if (this.isValidJson(value)) {
            gen.writeRawValue(value);
        } else {
            gen.writeString(value);
        }
    }

    private boolean isValidJson(String value) {
        try {
            new JSONObject(value);
            return true;
        }
        catch (Exception e) {
            try {
                new JSONArray(value);
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
    }
}

