/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.tools;

import java.util.Set;
import lombok.Generated;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.FilterCondition;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.ItemLite;

public final class ViewConfigUtils {
    public static void addItemFilter(BusinessEntityField nameField, ViewConfig viewConfig, ItemLite itemLite, String name) {
        ViewField filterField = new ViewField();
        filterField.setId(TimeStampUUIDGenerator.generateId());
        filterField.setLabel(name);
        filterField.setBusinessEntityId(nameField.getBusinessEntityId());
        filterField.setEntityFieldId(nameField.getId());
        filterField.setAggregationType(FieldAggregation.UNIQ);
        RuntimeFilterField runtimeFilterField = new RuntimeFilterField();
        runtimeFilterField.setName(name);
        runtimeFilterField.setViewFieldId(filterField.getId());
        runtimeFilterField.setCondition(FilterCondition.ONE_OF);
        runtimeFilterField.setOptions(Set.of(itemLite.getName()));
        runtimeFilterField.setSelection(Set.of(itemLite.getName()));
        viewConfig.getHiddenFields().add(filterField);
        viewConfig.getRuntimeFilters().add(runtimeFilterField);
    }

    public static void addDateField(ViewConfig viewConfig, DateAggregationType dateAggregationType, String name) {
        ViewField dateField = new ViewField();
        dateField.setId(TimeStampUUIDGenerator.generateId());
        dateField.setLabel(name);
        dateField.setVirtualDateField(true);
        dateField.setDateGrouping(dateAggregationType);
        viewConfig.getXAxis().add(dateField);
    }

    @Generated
    private ViewConfigUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

