/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.subscription;

import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.SystemParams;
import org.thingsboard.server.common.data.subscription.SubscriptionInfo;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.tb.configuration.TbConfigurationStorage;
import org.thingsboard.trendz.subscription.SelfHostedSubscriptionServiceV1;
import org.thingsboard.trendz.subscription.SubscriptionErrorType;
import org.thingsboard.trendz.subscription.SubscriptionService;
import org.thingsboard.trendz.subscription.SubscriptionState;
import org.thingsboard.trendz.subscription.SubscriptionType;
import org.thingsboard.trendz.subscription.SubscriptionVersion;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Mono;

@Component
public class SelfHostedSubscriptionServiceV2
implements SubscriptionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SelfHostedSubscriptionServiceV2.class);
    private final TbRestDataSource tbRestDataSource;
    private final TbConfigurationStorage tbConfigurationStorage;
    private final SelfHostedSubscriptionServiceV1 subscriptionServiceV1;

    @Autowired
    public SelfHostedSubscriptionServiceV2(TbRestDataSource tbRestDataSource, TbConfigurationStorage tbConfigurationStorage, SelfHostedSubscriptionServiceV1 subscriptionServiceV1) {
        this.tbRestDataSource = tbRestDataSource;
        this.tbConfigurationStorage = tbConfigurationStorage;
        this.subscriptionServiceV1 = subscriptionServiceV1;
    }

    public SubscriptionState getSubscriptionState(JwtSecurityUser user) {
        long now = System.currentTimeMillis();
        SystemParams systemParams = (SystemParams)DonReactive.block((Mono)this.tbRestDataSource.getTbSystemParams(user));
        if (systemParams.getLicenseVersion() == 1) {
            log.debug("Detected license v1. Using subscription check service v1.");
            return this.subscriptionServiceV1.getSubscriptionState(user);
        }
        log.debug("Detected license v2. Using subscription check service v2.");
        if (!this.tbConfigurationStorage.getTbConfiguration().isEnabled()) {
            log.error("Impossible to use license check service V2 without ThingsBoard sync.");
            return SubscriptionState.builder().valid(false).whiteLabelingEnabled(false).checkTs(now).version(SubscriptionVersion.V2).errorType(SubscriptionErrorType.TB_SYNC_ERROR).errorMsg("Impossible to use license check service V2 without ThingsBoard sync.").build();
        }
        try {
            SubscriptionInfo subscriptionInfo = (SubscriptionInfo)DonReactive.block((Mono)this.tbRestDataSource.getTbSubscriptionInfo());
            Long startTs = subscriptionInfo.isPerpetual() ? null : subscriptionInfo.getCurrentPeriodStartTs();
            Long endTs = subscriptionInfo.isPerpetual() ? subscriptionInfo.getEndTs() : subscriptionInfo.getCurrentPeriodStartTs();
            SubscriptionState state = SubscriptionState.builder().valid(subscriptionInfo.isTrendzEnabled()).whiteLabelingEnabled(subscriptionInfo.isWhiteLabelingEnabled()).checkTs(now).allowedAssets(subscriptionInfo.getMaxAssets()).allowedDevices(subscriptionInfo.getMaxDevices()).actualAssets(-1L).actualDevices(-1L).startTs(Optional.ofNullable(startTs).orElse(0L).longValue()).endTs(Optional.ofNullable(endTs).orElse(-1L).longValue()).type(SubscriptionType.fromName((String)subscriptionInfo.getSubscriptionPlanName())).name(subscriptionInfo.getSubscriptionPlanName()).version(SubscriptionVersion.V2).build();
            if (state.isValid()) {
                log.debug("Trendz subscription is active.");
            } else {
                state.setErrorType(SubscriptionErrorType.LICENSE_ERROR);
                state.setErrorMsg("Trendz subscription is inactive.");
            }
            return state;
        }
        catch (RuntimeException e) {
            log.error("Unexpected error during license check V2.", (Throwable)e);
            return SubscriptionState.builder().valid(false).whiteLabelingEnabled(false).checkTs(now).version(SubscriptionVersion.V2).errorType(SubscriptionErrorType.LICENSE_ERROR).errorMsg("Unexpected error during license check V2.").build();
        }
    }
}

