/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.subscription;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.domain.customize.UserRecord;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.customize.UserManagementService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.subscription.SubscriptionErrorType;
import org.thingsboard.trendz.subscription.SubscriptionService;
import org.thingsboard.trendz.subscription.SubscriptionState;
import org.thingsboard.trendz.subscription.SubscriptionType;
import org.thingsboard.trendz.subscription.SubscriptionVersion;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Mono;

@Component
public class CloudSubscriptionService
implements SubscriptionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudSubscriptionService.class);
    private final UserManagementService userManagementService;
    private final TbRestDataSource tbRestDataSource;

    @Autowired
    public CloudSubscriptionService(UserManagementService userManagementService, TbRestDataSource tbRestDataSource) {
        this.userManagementService = userManagementService;
        this.tbRestDataSource = tbRestDataSource;
    }

    public SubscriptionState getSubscriptionState(JwtSecurityUser user) {
        return this.checkIsValid(user);
    }

    private SubscriptionState checkIsValid(JwtSecurityUser securityUser) {
        long now = System.currentTimeMillis();
        try {
            log.debug("Going to check license for tenant {} / {}", (Object)securityUser.getTenantId(), (Object)securityUser.getUserId());
            JwtSecurityUser user = securityUser;
            if (securityUser.isCustomerUser()) {
                log.trace("Check license for customer user");
                UserRecord userRecord = (UserRecord)this.userManagementService.findFirstTenantUserByTenantId(securityUser.getTenantId()).orElseThrow(() -> new RuntimeException("Tenant not found in Trendz cache"));
                user = userRecord.getUser();
            }
            JsonNode subscription = this.fetchSubscription(user);
            JsonNode details = this.fetchSubscriptionDetails(user);
            JsonNode filteredSubscription = this.makeFilteredCopy(subscription);
            this.userManagementService.assignLicenceInfo(user, filteredSubscription);
            String name = subscription.get("name").asText();
            SubscriptionType type = SubscriptionType.fromName((String)name);
            boolean isDeprecated = this.isDeprecated(name);
            boolean licenseActive = subscription.get("active").booleanValue();
            long currentPeriodStartTs = subscription.get("currentPeriodStartTs").longValue();
            long currentPeriodEndTs = subscription.get("currentPeriodEndTs").longValue();
            boolean trendzEnabled = details.get("trendzEnabled").booleanValue();
            boolean whitelabelingEnabled = details.get("whiteLabelingEnabled").booleanValue();
            int maxAssets = details.get("maxAssets").intValue();
            int maxDevices = details.get("maxDevices").intValue();
            boolean isValid = licenseActive && trendzEnabled;
            log.debug("Tenant {} trendzEnabled {} licenseActive {}", new Object[]{user.getTenantId(), trendzEnabled, licenseActive});
            SubscriptionErrorType errorType = null;
            String errorMessage = null;
            if (!isValid) {
                errorType = SubscriptionErrorType.LICENSE_ERROR;
                if (licenseActive) {
                    errorMessage = "The current license does not include Trendz. Current subscription: " + name;
                }
            }
            return SubscriptionState.builder().valid(isValid).whiteLabelingEnabled(whitelabelingEnabled).deprecated(isDeprecated).checkTs(now).allowedAssets((long)maxAssets).allowedDevices((long)maxDevices).startTs(currentPeriodStartTs).endTs(currentPeriodEndTs).type(type).name(name).errorMsg(errorMessage).errorType(errorType).version(SubscriptionVersion.V2).build();
        }
        catch (Exception ex) {
            String errorMessage = String.format("License check error for %s: %s", securityUser.getTenantId(), ex.getMessage());
            log.error(errorMessage, (Throwable)ex);
            return SubscriptionState.builder().valid(false).whiteLabelingEnabled(false).checkTs(now).errorMsg(errorMessage).errorType(SubscriptionErrorType.LICENSE_ERROR).version(SubscriptionVersion.V2).build();
        }
    }

    private JsonNode fetchSubscriptionDetails(JwtSecurityUser user) {
        try {
            return (JsonNode)DonReactive.block((Mono)this.tbRestDataSource.getSubscriptionDetails(user));
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Could not fetch subscription details", ex);
        }
    }

    private JsonNode fetchSubscription(JwtSecurityUser user) {
        try {
            return (JsonNode)DonReactive.block((Mono)this.tbRestDataSource.getSubscription(user));
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Could not fetch subscription", ex);
        }
    }

    private Cache<TenantId, SubscriptionState> buildCache() {
        return Caffeine.newBuilder().expireAfter((Expiry)new /* Unavailable Anonymous Inner Class!! */).build();
    }

    private JsonNode makeFilteredCopy(JsonNode subscription) {
        ObjectNode copy = (ObjectNode)subscription.deepCopy();
        copy.remove("id");
        copy.remove("additionalInfo");
        copy.remove("externalId");
        copy.remove("tenantId");
        copy.remove("billingCustomerId");
        copy.remove("subscriptionPlanId");
        return copy;
    }

    private boolean isDeprecated(String name) {
        return name.contains("Deprecated") || name.contains("Legacy") || name.contains("Trendz");
    }
}

