/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Sets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.CacheSettings;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.definition.view.config.ViewType;
import org.thingsboard.trendz.domain.manual.ManualDataset;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.domain.tb.provider.RequestPriority;
import org.thingsboard.trendz.exception.BadConfiguredTaskException;
import org.thingsboard.trendz.tools.DateTimeUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ViewRequest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ViewRequest.class);
    private static final Set<DateAggregationType> allowedCachingTypes = Sets.newHashSet((Object[])new DateAggregationType[]{DateAggregationType.FULL_HOUR, DateAggregationType.FULL_DATE});
    private UUID rootEntityId;
    private UUID rowClickEntityId;
    private List<ViewField> fields;
    private List<ViewField> dateAggregationFieldsVisible;
    private List<ViewField> dateAggregationFieldsHidden;
    private List<ViewField> stateFields;
    private List<ViewField> anomalyFields;
    private List<RuntimeFilterField> runtimeFilters;
    private DatePickerConfig datePickerConfig;
    private DateAggregationType minimalDateAggregation;
    private JsonNode settings;
    private boolean streamProcessingEnabled;
    private boolean multirootItemsLoadingEnabled;
    private boolean cacheItemTelemetry;
    private boolean ownerRequired;
    private boolean fillGap;
    private boolean previewRequest;
    private int previewItemCount;
    private boolean usePersistedCacheTelemetry;
    private DateAggregationType cachingDateAggregationType;
    private long startTs;
    private long endTs;
    private long nowTs;
    private ZoneId zoneId;
    private Map<UUID, Boolean> datasetEnableMap;
    private Map<UUID, Item> datasetItemMap;
    private Map<UUID, ManualDataset> datasetDataMap;
    @JsonIgnore
    private RequestPriority requestPriority;

    public ViewRequest(ViewRequest that) {
        this.rootEntityId = that.rootEntityId;
        this.rowClickEntityId = that.rowClickEntityId;
        this.anomalyFields = that.anomalyFields;
        this.fields = that.fields == null ? null : that.fields.stream().map(ViewField::new).collect(Collectors.toList());
        this.dateAggregationFieldsVisible = that.dateAggregationFieldsVisible == null ? null : that.dateAggregationFieldsVisible.stream().map(ViewField::new).collect(Collectors.toList());
        this.dateAggregationFieldsHidden = that.dateAggregationFieldsHidden == null ? null : that.dateAggregationFieldsHidden.stream().map(ViewField::new).collect(Collectors.toList());
        this.stateFields = that.stateFields == null ? null : that.stateFields.stream().map(ViewField::new).collect(Collectors.toList());
        this.runtimeFilters = that.runtimeFilters == null ? null : that.runtimeFilters.stream().map(RuntimeFilterField::new).collect(Collectors.toList());
        this.datePickerConfig = new DatePickerConfig(that.datePickerConfig);
        this.startTs = that.startTs;
        this.endTs = that.endTs;
        this.nowTs = that.nowTs;
        this.zoneId = that.zoneId;
        this.settings = that.settings == null ? null : that.settings.deepCopy();
        this.streamProcessingEnabled = that.streamProcessingEnabled;
        this.multirootItemsLoadingEnabled = that.multirootItemsLoadingEnabled;
        this.cacheItemTelemetry = that.cacheItemTelemetry;
        this.ownerRequired = that.ownerRequired;
        this.fillGap = that.fillGap;
        this.previewRequest = that.previewRequest;
        this.previewItemCount = that.previewItemCount;
        this.minimalDateAggregation = that.minimalDateAggregation;
        this.usePersistedCacheTelemetry = that.usePersistedCacheTelemetry;
        this.cachingDateAggregationType = that.cachingDateAggregationType;
        this.datasetEnableMap = that.datasetEnableMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.datasetItemMap = that.datasetItemMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.datasetDataMap = that.datasetDataMap.entrySet().stream().map(entry -> Map.entry((UUID)entry.getKey(), new ManualDataset((ManualDataset)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.requestPriority = that.requestPriority;
    }

    public ViewRequest(ViewConfig config, long now) {
        ZoneId zoneId = DateTimeUtils.fromTzName((String)config.getTzName());
        this.rootEntityId = config.getRootEntityId();
        this.rowClickEntityId = config.getRowClickEntityId();
        this.datePickerConfig = config.getDatePickerConfig();
        this.nowTs = now;
        TimeRange timeRange = this.datePickerConfig.buildStartEndPair(zoneId, this.nowTs);
        ViewRequest.validateTimeRange((TimeRange)timeRange);
        this.startTs = timeRange.getStartTs();
        this.endTs = timeRange.getEndTs();
        this.zoneId = zoneId;
        this.runtimeFilters = config.getRuntimeFilters();
        this.settings = config.getSettings();
        this.fields = config.getAllFields();
        this.stateFields = this.fields.stream().filter(ViewField::isStateField).collect(Collectors.toList());
        this.dateAggregationFieldsVisible = this.fields.stream().filter(ViewField::isVirtualDateField).filter(field -> !field.isHidden()).collect(Collectors.toList());
        this.dateAggregationFieldsHidden = this.fields.stream().filter(ViewField::isVirtualDateField).filter(ViewField::isHidden).collect(Collectors.toList());
        this.anomalyFields = this.fields.stream().filter(ViewField::isAnomalyField).collect(Collectors.toList());
        this.fields = this.fields.stream().filter(f -> !f.isVirtualDateField()).collect(Collectors.toList());
        this.streamProcessingEnabled = false;
        this.cacheItemTelemetry = false;
        JsonNode multirootEnabled = config.getSettings().get("multirootEnabled");
        this.multirootItemsLoadingEnabled = multirootEnabled != null && multirootEnabled.booleanValue();
        this.minimalDateAggregation = this.defineMinDateAggregation();
        this.previewRequest = config.isPreviewRequest();
        this.previewItemCount = config.getPreviewItemCount();
        CacheSettings cacheSettings = config.getCacheSettings();
        this.usePersistedCacheTelemetry = cacheSettings.isUsePersistedCacheTelemetry();
        this.cachingDateAggregationType = cacheSettings.getCachingDateAggregation();
        this.fillGap = config.getViewType() == ViewType.HEATMAP;
        for (ViewField field2 : this.getAllFields()) {
            if (field2.getDebugDataSample() != null) continue;
            field2.setDebugDataSample(new ConcurrentHashMap());
        }
        this.datasetEnableMap = config.getDatasetEnableMap() == null ? new HashMap() : config.getDatasetEnableMap();
        this.datasetItemMap = config.getDatasetItemMap() == null ? new HashMap() : config.getDatasetItemMap();
        this.datasetDataMap = config.getDatasetDataMap() == null ? new HashMap() : config.getDatasetDataMap();
        this.requestPriority = config.getRequestPriority();
    }

    private DateAggregationType defineMinDateAggregation() {
        DateAggregationType minType = null;
        if (!CollectionUtils.isEmpty((Collection)this.dateAggregationFieldsVisible)) {
            Set availableGroups = this.dateAggregationFieldsVisible.stream().map(ViewField::getDateGrouping).collect(Collectors.toSet());
            for (DateAggregationType value : DateAggregationType.values()) {
                if (!availableGroups.contains(value)) continue;
                minType = value;
                break;
            }
        }
        if (minType == DateAggregationType.RAW) {
            return DateAggregationType.getDateGroupingFromPicker((String)this.datePickerConfig.getRangeBy());
        }
        return minType;
    }

    private static void validateTimeRange(TimeRange timeRange) {
        long start = timeRange.getStartTs();
        long end = timeRange.getEndTs();
        if (start == 0L || end == 0L || start >= end) {
            String message = String.format("Time range not valid (%s, %s) - [%s, %s]", start, end, DateTimeUtils.fromTs((long)start), DateTimeUtils.fromTs((long)end));
            throw new BadConfiguredTaskException(message);
        }
    }

    @JsonIgnore
    public DateAggregationType getCachingDateAggregationType() {
        if (!allowedCachingTypes.contains(this.cachingDateAggregationType)) {
            throw new BadConfiguredTaskException("The view request has unsupported caching date aggregation type: " + String.valueOf(this.cachingDateAggregationType));
        }
        HashSet options = Sets.newHashSet((Object[])new DateAggregationType[]{this.cachingDateAggregationType, DateAggregationType.getFullType((DateAggregationType)this.minimalDateAggregation)});
        for (DateAggregationType value : DateAggregationType.values()) {
            if (!options.contains(value)) continue;
            return value;
        }
        return null;
    }

    @JsonIgnore
    public boolean isCacheRequired() {
        HashMap fieldMap = new HashMap();
        this.getFields().forEach(f -> {
            fieldMap.computeIfAbsent(f.getEntityFieldId(), i -> new AtomicInteger()).incrementAndGet();
            if (MapUtils.isNotEmpty((Map)f.getConditionFieldIds())) {
                f.getConditionFieldIds().values().forEach(cf -> fieldMap.computeIfAbsent(f.getEntityFieldId(), i -> new AtomicInteger()).incrementAndGet());
            }
        });
        return fieldMap.entrySet().stream().anyMatch(e -> ((AtomicInteger)e.getValue()).get() > 1);
    }

    @JsonIgnore
    public Set<UUID> getAllowedEntityIds() {
        HashSet ids = Sets.newHashSet();
        JsonNode settings = this.getSettings();
        JsonNode missedGraphEntities = settings.get("missedGraphEntities");
        if (missedGraphEntities != null && !missedGraphEntities.isMissingNode()) {
            for (JsonNode node : missedGraphEntities) {
                UUID uuid = UUID.fromString(node.textValue());
                ids.add(uuid);
            }
        }
        return ids;
    }

    @JsonIgnore
    public List<ViewField> getAllFields() {
        ArrayList<ViewField> allFields = new ArrayList<ViewField>();
        allFields.addAll(this.getFields());
        allFields.addAll(this.getDateAggregationFieldsVisible());
        allFields.addAll(this.getDateAggregationFieldsHidden());
        return allFields;
    }

    @JsonIgnore
    public boolean isDeltaFieldsPresent() {
        return this.getAllFields().stream().anyMatch(ViewField::isUseDelta);
    }

    @JsonIgnore
    public long getStartTs(ViewField viewField) {
        if (viewField == null) {
            return this.startTs;
        }
        long startTs = this.startTs;
        if (viewField.getLocalTimeRange() != null) {
            startTs = viewField.getLocalTimeRange().buildStartEndPair(this.zoneId, this.nowTs).getStartTs();
        }
        if (viewField.isUseDelta()) {
            DateAggregationType timeAggregation = this.getMinimalDateAggregation();
            if (timeAggregation == null) {
                return startTs;
            }
            if (viewField.getAggregationType() == FieldAggregation.LATEST) {
                throw new BadConfiguredTaskException("Delta is not applicable to LATEST field aggregation.");
            }
            ChronoUnit timeUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)timeAggregation);
            ZonedDateTime startDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(startTs), this.getZoneId());
            startTs = startDate.minus(1L, timeUnit).toInstant().toEpochMilli();
        }
        return startTs;
    }

    @JsonIgnore
    public long getEndTs(ViewField viewField) {
        long result = viewField == null || viewField.getLocalTimeRange() == null ? this.endTs : viewField.getLocalTimeRange().buildStartEndPair(this.zoneId, this.nowTs).getEndTs();
        long currentTs = System.currentTimeMillis();
        if (currentTs < result && log.isWarnEnabled()) {
            ZonedDateTime currentTime = DateTimeUtils.fromTs((long)currentTs, (ZoneId)this.zoneId);
            ZonedDateTime endTime = DateTimeUtils.fromTs((long)result, (ZoneId)this.zoneId);
            log.trace("End time of the request is later then present time, current time = {}, end time = {}", (Object)currentTime, (Object)endTime);
        }
        return result;
    }

    @JsonIgnore
    public boolean isUsingManualDatasetAsParent(ViewField viewField) {
        Boolean useManualDatasetParentField = (Boolean)this.datasetEnableMap.get(viewField.getId());
        return useManualDatasetParentField != null && useManualDatasetParentField != false;
    }

    @JsonIgnore
    public boolean isUsingManualDatasetAsChild(ViewField viewField) {
        Boolean useManualDatasetChildField = viewField.getParentStateField() == null ? null : (Boolean)this.datasetEnableMap.get(viewField.getParentStateField());
        return useManualDatasetChildField != null && useManualDatasetChildField != false;
    }

    @JsonIgnore
    public Item getManualDatasetItem(ViewField viewField) {
        Item item = (Item)this.datasetItemMap.get(viewField.getId());
        if (item == null) {
            item = (Item)this.datasetItemMap.get(viewField.getParentStateField());
        }
        return item;
    }

    @JsonIgnore
    public ManualDataset getManualDataset(ViewField viewField) {
        return (ManualDataset)this.datasetDataMap.get(viewField.getParentStateField());
    }

    @JsonIgnore
    public String getGroupBy() {
        boolean raw = this.getDateAggregationFieldsVisible().stream().anyMatch(vf -> vf.getDateGrouping() == DateAggregationType.RAW);
        DateAggregationType minimalDateAggregation = this.getMinimalDateAggregation();
        if (raw) {
            return this.getDatePickerConfig().getRangeBy();
        }
        return minimalDateAggregation == null ? "null" : DateAggregationType.getPickerFromGrouping((DateAggregationType)minimalDateAggregation);
    }

    @Generated
    public UUID getRootEntityId() {
        return this.rootEntityId;
    }

    @Generated
    public UUID getRowClickEntityId() {
        return this.rowClickEntityId;
    }

    @Generated
    public List<ViewField> getFields() {
        return this.fields;
    }

    @Generated
    public List<ViewField> getDateAggregationFieldsVisible() {
        return this.dateAggregationFieldsVisible;
    }

    @Generated
    public List<ViewField> getDateAggregationFieldsHidden() {
        return this.dateAggregationFieldsHidden;
    }

    @Generated
    public List<ViewField> getStateFields() {
        return this.stateFields;
    }

    @Generated
    public List<ViewField> getAnomalyFields() {
        return this.anomalyFields;
    }

    @Generated
    public List<RuntimeFilterField> getRuntimeFilters() {
        return this.runtimeFilters;
    }

    @Generated
    public DatePickerConfig getDatePickerConfig() {
        return this.datePickerConfig;
    }

    @Generated
    public DateAggregationType getMinimalDateAggregation() {
        return this.minimalDateAggregation;
    }

    @Generated
    public JsonNode getSettings() {
        return this.settings;
    }

    @Generated
    public boolean isStreamProcessingEnabled() {
        return this.streamProcessingEnabled;
    }

    @Generated
    public boolean isMultirootItemsLoadingEnabled() {
        return this.multirootItemsLoadingEnabled;
    }

    @Generated
    public boolean isCacheItemTelemetry() {
        return this.cacheItemTelemetry;
    }

    @Generated
    public boolean isOwnerRequired() {
        return this.ownerRequired;
    }

    @Generated
    public boolean isFillGap() {
        return this.fillGap;
    }

    @Generated
    public boolean isPreviewRequest() {
        return this.previewRequest;
    }

    @Generated
    public int getPreviewItemCount() {
        return this.previewItemCount;
    }

    @Generated
    public boolean isUsePersistedCacheTelemetry() {
        return this.usePersistedCacheTelemetry;
    }

    @Generated
    public long getNowTs() {
        return this.nowTs;
    }

    @Generated
    public ZoneId getZoneId() {
        return this.zoneId;
    }

    @Generated
    public Map<UUID, Boolean> getDatasetEnableMap() {
        return this.datasetEnableMap;
    }

    @Generated
    public Map<UUID, Item> getDatasetItemMap() {
        return this.datasetItemMap;
    }

    @Generated
    public Map<UUID, ManualDataset> getDatasetDataMap() {
        return this.datasetDataMap;
    }

    @Generated
    public RequestPriority getRequestPriority() {
        return this.requestPriority;
    }

    @Generated
    public void setRootEntityId(UUID rootEntityId) {
        this.rootEntityId = rootEntityId;
    }

    @Generated
    public void setRowClickEntityId(UUID rowClickEntityId) {
        this.rowClickEntityId = rowClickEntityId;
    }

    @Generated
    public void setFields(List<ViewField> fields) {
        this.fields = fields;
    }

    @Generated
    public void setDateAggregationFieldsVisible(List<ViewField> dateAggregationFieldsVisible) {
        this.dateAggregationFieldsVisible = dateAggregationFieldsVisible;
    }

    @Generated
    public void setDateAggregationFieldsHidden(List<ViewField> dateAggregationFieldsHidden) {
        this.dateAggregationFieldsHidden = dateAggregationFieldsHidden;
    }

    @Generated
    public void setStateFields(List<ViewField> stateFields) {
        this.stateFields = stateFields;
    }

    @Generated
    public void setAnomalyFields(List<ViewField> anomalyFields) {
        this.anomalyFields = anomalyFields;
    }

    @Generated
    public void setRuntimeFilters(List<RuntimeFilterField> runtimeFilters) {
        this.runtimeFilters = runtimeFilters;
    }

    @Generated
    public void setDatePickerConfig(DatePickerConfig datePickerConfig) {
        this.datePickerConfig = datePickerConfig;
    }

    @Generated
    public void setMinimalDateAggregation(DateAggregationType minimalDateAggregation) {
        this.minimalDateAggregation = minimalDateAggregation;
    }

    @Generated
    public void setSettings(JsonNode settings) {
        this.settings = settings;
    }

    @Generated
    public void setStreamProcessingEnabled(boolean streamProcessingEnabled) {
        this.streamProcessingEnabled = streamProcessingEnabled;
    }

    @Generated
    public void setMultirootItemsLoadingEnabled(boolean multirootItemsLoadingEnabled) {
        this.multirootItemsLoadingEnabled = multirootItemsLoadingEnabled;
    }

    @Generated
    public void setCacheItemTelemetry(boolean cacheItemTelemetry) {
        this.cacheItemTelemetry = cacheItemTelemetry;
    }

    @Generated
    public void setOwnerRequired(boolean ownerRequired) {
        this.ownerRequired = ownerRequired;
    }

    @Generated
    public void setFillGap(boolean fillGap) {
        this.fillGap = fillGap;
    }

    @Generated
    public void setPreviewRequest(boolean previewRequest) {
        this.previewRequest = previewRequest;
    }

    @Generated
    public void setPreviewItemCount(int previewItemCount) {
        this.previewItemCount = previewItemCount;
    }

    @Generated
    public void setUsePersistedCacheTelemetry(boolean usePersistedCacheTelemetry) {
        this.usePersistedCacheTelemetry = usePersistedCacheTelemetry;
    }

    @Generated
    public void setCachingDateAggregationType(DateAggregationType cachingDateAggregationType) {
        this.cachingDateAggregationType = cachingDateAggregationType;
    }

    @Generated
    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    @Generated
    public void setEndTs(long endTs) {
        this.endTs = endTs;
    }

    @Generated
    public void setNowTs(long nowTs) {
        this.nowTs = nowTs;
    }

    @Generated
    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    @Generated
    public void setDatasetEnableMap(Map<UUID, Boolean> datasetEnableMap) {
        this.datasetEnableMap = datasetEnableMap;
    }

    @Generated
    public void setDatasetItemMap(Map<UUID, Item> datasetItemMap) {
        this.datasetItemMap = datasetItemMap;
    }

    @Generated
    public void setDatasetDataMap(Map<UUID, ManualDataset> datasetDataMap) {
        this.datasetDataMap = datasetDataMap;
    }

    @Generated
    public void setRequestPriority(RequestPriority requestPriority) {
        this.requestPriority = requestPriority;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ViewRequest)) {
            return false;
        }
        ViewRequest other = (ViewRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isStreamProcessingEnabled() != other.isStreamProcessingEnabled()) {
            return false;
        }
        if (this.isMultirootItemsLoadingEnabled() != other.isMultirootItemsLoadingEnabled()) {
            return false;
        }
        if (this.isCacheItemTelemetry() != other.isCacheItemTelemetry()) {
            return false;
        }
        if (this.isOwnerRequired() != other.isOwnerRequired()) {
            return false;
        }
        if (this.isFillGap() != other.isFillGap()) {
            return false;
        }
        if (this.isPreviewRequest() != other.isPreviewRequest()) {
            return false;
        }
        if (this.getPreviewItemCount() != other.getPreviewItemCount()) {
            return false;
        }
        if (this.isUsePersistedCacheTelemetry() != other.isUsePersistedCacheTelemetry()) {
            return false;
        }
        if (this.startTs != other.startTs) {
            return false;
        }
        if (this.endTs != other.endTs) {
            return false;
        }
        if (this.getNowTs() != other.getNowTs()) {
            return false;
        }
        UUID this$rootEntityId = this.getRootEntityId();
        UUID other$rootEntityId = other.getRootEntityId();
        if (this$rootEntityId == null ? other$rootEntityId != null : !((Object)this$rootEntityId).equals(other$rootEntityId)) {
            return false;
        }
        UUID this$rowClickEntityId = this.getRowClickEntityId();
        UUID other$rowClickEntityId = other.getRowClickEntityId();
        if (this$rowClickEntityId == null ? other$rowClickEntityId != null : !((Object)this$rowClickEntityId).equals(other$rowClickEntityId)) {
            return false;
        }
        List this$fields = this.getFields();
        List other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        List this$dateAggregationFieldsVisible = this.getDateAggregationFieldsVisible();
        List other$dateAggregationFieldsVisible = other.getDateAggregationFieldsVisible();
        if (this$dateAggregationFieldsVisible == null ? other$dateAggregationFieldsVisible != null : !((Object)this$dateAggregationFieldsVisible).equals(other$dateAggregationFieldsVisible)) {
            return false;
        }
        List this$dateAggregationFieldsHidden = this.getDateAggregationFieldsHidden();
        List other$dateAggregationFieldsHidden = other.getDateAggregationFieldsHidden();
        if (this$dateAggregationFieldsHidden == null ? other$dateAggregationFieldsHidden != null : !((Object)this$dateAggregationFieldsHidden).equals(other$dateAggregationFieldsHidden)) {
            return false;
        }
        List this$stateFields = this.getStateFields();
        List other$stateFields = other.getStateFields();
        if (this$stateFields == null ? other$stateFields != null : !((Object)this$stateFields).equals(other$stateFields)) {
            return false;
        }
        List this$anomalyFields = this.getAnomalyFields();
        List other$anomalyFields = other.getAnomalyFields();
        if (this$anomalyFields == null ? other$anomalyFields != null : !((Object)this$anomalyFields).equals(other$anomalyFields)) {
            return false;
        }
        List this$runtimeFilters = this.getRuntimeFilters();
        List other$runtimeFilters = other.getRuntimeFilters();
        if (this$runtimeFilters == null ? other$runtimeFilters != null : !((Object)this$runtimeFilters).equals(other$runtimeFilters)) {
            return false;
        }
        DatePickerConfig this$datePickerConfig = this.getDatePickerConfig();
        DatePickerConfig other$datePickerConfig = other.getDatePickerConfig();
        if (this$datePickerConfig == null ? other$datePickerConfig != null : !this$datePickerConfig.equals(other$datePickerConfig)) {
            return false;
        }
        DateAggregationType this$minimalDateAggregation = this.getMinimalDateAggregation();
        DateAggregationType other$minimalDateAggregation = other.getMinimalDateAggregation();
        if (this$minimalDateAggregation == null ? other$minimalDateAggregation != null : !this$minimalDateAggregation.equals(other$minimalDateAggregation)) {
            return false;
        }
        JsonNode this$settings = this.getSettings();
        JsonNode other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !this$settings.equals(other$settings)) {
            return false;
        }
        DateAggregationType this$cachingDateAggregationType = this.getCachingDateAggregationType();
        DateAggregationType other$cachingDateAggregationType = other.getCachingDateAggregationType();
        if (this$cachingDateAggregationType == null ? other$cachingDateAggregationType != null : !this$cachingDateAggregationType.equals(other$cachingDateAggregationType)) {
            return false;
        }
        ZoneId this$zoneId = this.getZoneId();
        ZoneId other$zoneId = other.getZoneId();
        if (this$zoneId == null ? other$zoneId != null : !((Object)this$zoneId).equals(other$zoneId)) {
            return false;
        }
        Map this$datasetEnableMap = this.getDatasetEnableMap();
        Map other$datasetEnableMap = other.getDatasetEnableMap();
        if (this$datasetEnableMap == null ? other$datasetEnableMap != null : !((Object)this$datasetEnableMap).equals(other$datasetEnableMap)) {
            return false;
        }
        Map this$datasetItemMap = this.getDatasetItemMap();
        Map other$datasetItemMap = other.getDatasetItemMap();
        if (this$datasetItemMap == null ? other$datasetItemMap != null : !((Object)this$datasetItemMap).equals(other$datasetItemMap)) {
            return false;
        }
        Map this$datasetDataMap = this.getDatasetDataMap();
        Map other$datasetDataMap = other.getDatasetDataMap();
        if (this$datasetDataMap == null ? other$datasetDataMap != null : !((Object)this$datasetDataMap).equals(other$datasetDataMap)) {
            return false;
        }
        RequestPriority this$requestPriority = this.getRequestPriority();
        RequestPriority other$requestPriority = other.getRequestPriority();
        return !(this$requestPriority == null ? other$requestPriority != null : !this$requestPriority.equals(other$requestPriority));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ViewRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isStreamProcessingEnabled() ? 79 : 97);
        result = result * 59 + (this.isMultirootItemsLoadingEnabled() ? 79 : 97);
        result = result * 59 + (this.isCacheItemTelemetry() ? 79 : 97);
        result = result * 59 + (this.isOwnerRequired() ? 79 : 97);
        result = result * 59 + (this.isFillGap() ? 79 : 97);
        result = result * 59 + (this.isPreviewRequest() ? 79 : 97);
        result = result * 59 + this.getPreviewItemCount();
        result = result * 59 + (this.isUsePersistedCacheTelemetry() ? 79 : 97);
        long $startTs = this.startTs;
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $endTs = this.endTs;
        result = result * 59 + (int)($endTs >>> 32 ^ $endTs);
        long $nowTs = this.getNowTs();
        result = result * 59 + (int)($nowTs >>> 32 ^ $nowTs);
        UUID $rootEntityId = this.getRootEntityId();
        result = result * 59 + ($rootEntityId == null ? 43 : ((Object)$rootEntityId).hashCode());
        UUID $rowClickEntityId = this.getRowClickEntityId();
        result = result * 59 + ($rowClickEntityId == null ? 43 : ((Object)$rowClickEntityId).hashCode());
        List $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        List $dateAggregationFieldsVisible = this.getDateAggregationFieldsVisible();
        result = result * 59 + ($dateAggregationFieldsVisible == null ? 43 : ((Object)$dateAggregationFieldsVisible).hashCode());
        List $dateAggregationFieldsHidden = this.getDateAggregationFieldsHidden();
        result = result * 59 + ($dateAggregationFieldsHidden == null ? 43 : ((Object)$dateAggregationFieldsHidden).hashCode());
        List $stateFields = this.getStateFields();
        result = result * 59 + ($stateFields == null ? 43 : ((Object)$stateFields).hashCode());
        List $anomalyFields = this.getAnomalyFields();
        result = result * 59 + ($anomalyFields == null ? 43 : ((Object)$anomalyFields).hashCode());
        List $runtimeFilters = this.getRuntimeFilters();
        result = result * 59 + ($runtimeFilters == null ? 43 : ((Object)$runtimeFilters).hashCode());
        DatePickerConfig $datePickerConfig = this.getDatePickerConfig();
        result = result * 59 + ($datePickerConfig == null ? 43 : $datePickerConfig.hashCode());
        DateAggregationType $minimalDateAggregation = this.getMinimalDateAggregation();
        result = result * 59 + ($minimalDateAggregation == null ? 43 : $minimalDateAggregation.hashCode());
        JsonNode $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : $settings.hashCode());
        DateAggregationType $cachingDateAggregationType = this.getCachingDateAggregationType();
        result = result * 59 + ($cachingDateAggregationType == null ? 43 : $cachingDateAggregationType.hashCode());
        ZoneId $zoneId = this.getZoneId();
        result = result * 59 + ($zoneId == null ? 43 : ((Object)$zoneId).hashCode());
        Map $datasetEnableMap = this.getDatasetEnableMap();
        result = result * 59 + ($datasetEnableMap == null ? 43 : ((Object)$datasetEnableMap).hashCode());
        Map $datasetItemMap = this.getDatasetItemMap();
        result = result * 59 + ($datasetItemMap == null ? 43 : ((Object)$datasetItemMap).hashCode());
        Map $datasetDataMap = this.getDatasetDataMap();
        result = result * 59 + ($datasetDataMap == null ? 43 : ((Object)$datasetDataMap).hashCode());
        RequestPriority $requestPriority = this.getRequestPriority();
        result = result * 59 + ($requestPriority == null ? 43 : $requestPriority.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ViewRequest(rootEntityId=" + String.valueOf(this.getRootEntityId()) + ", rowClickEntityId=" + String.valueOf(this.getRowClickEntityId()) + ", fields=" + String.valueOf(this.getFields()) + ", dateAggregationFieldsVisible=" + String.valueOf(this.getDateAggregationFieldsVisible()) + ", dateAggregationFieldsHidden=" + String.valueOf(this.getDateAggregationFieldsHidden()) + ", stateFields=" + String.valueOf(this.getStateFields()) + ", anomalyFields=" + String.valueOf(this.getAnomalyFields()) + ", runtimeFilters=" + String.valueOf(this.getRuntimeFilters()) + ", datePickerConfig=" + String.valueOf(this.getDatePickerConfig()) + ", minimalDateAggregation=" + String.valueOf(this.getMinimalDateAggregation()) + ", settings=" + String.valueOf(this.getSettings()) + ", streamProcessingEnabled=" + this.isStreamProcessingEnabled() + ", multirootItemsLoadingEnabled=" + this.isMultirootItemsLoadingEnabled() + ", cacheItemTelemetry=" + this.isCacheItemTelemetry() + ", ownerRequired=" + this.isOwnerRequired() + ", fillGap=" + this.isFillGap() + ", previewRequest=" + this.isPreviewRequest() + ", previewItemCount=" + this.getPreviewItemCount() + ", usePersistedCacheTelemetry=" + this.isUsePersistedCacheTelemetry() + ", cachingDateAggregationType=" + String.valueOf(this.getCachingDateAggregationType()) + ", startTs=" + this.startTs + ", endTs=" + this.endTs + ", nowTs=" + this.getNowTs() + ", zoneId=" + String.valueOf(this.getZoneId()) + ", datasetEnableMap=" + String.valueOf(this.getDatasetEnableMap()) + ", datasetItemMap=" + String.valueOf(this.getDatasetItemMap()) + ", datasetDataMap=" + String.valueOf(this.getDatasetDataMap()) + ", requestPriority=" + String.valueOf(this.getRequestPriority()) + ")";
    }

    @Generated
    public ViewRequest() {
    }
}

