/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.exception.BadConfiguredTaskException;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.service.view.proto.FillGapService;
import org.thingsboard.trendz.service.view.proto.FillGapSettings;
import org.thingsboard.trendz.service.view.proto.FillGapStrategy;
import org.thingsboard.trendz.service.view.proto.GapSolveService;
import org.thingsboard.trendz.tools.DateTimeUtils;

@Service
public class FillGapService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FillGapService.class);
    private final GapSolveService gapSolveService;

    @Autowired
    public FillGapService(GapSolveService gapSolveService) {
        this.gapSolveService = gapSolveService;
    }

    public List<FieldValue> process(List<FieldValue> fieldValues, long startTs, long endTs, ZoneId requestZoneId, FillGapSettings settings) {
        if (fieldValues.isEmpty() || fieldValues.size() == 1 && fieldValues.get(0).getFieldType() == FieldType.BLANK) {
            return fieldValues;
        }
        List sortedValues = fieldValues.stream().sorted(Comparator.comparingLong(FieldValue::getTs)).collect(Collectors.toList());
        this.validateFieldTypeMonotone(sortedValues);
        this.validateFieldTypeToProvidedStrategy(((FieldValue)sortedValues.get(0)).getFieldType(), settings.getFillGapStrategy());
        this.validateTimeRangeCorresponding(sortedValues, startTs, endTs, requestZoneId);
        List ranges = new TimeRange(startTs, endTs).splitTimeRange(settings.getTimeUnit(), requestZoneId);
        List groupedRangeValues = this.groupValuesToRanges(sortedValues, ranges);
        List finalValues = this.findAndSolveGaps(groupedRangeValues, settings.getFillGapStrategy());
        return finalValues;
    }

    private void validateFieldTypeMonotone(List<FieldValue> fieldValues) {
        FieldType fieldType = fieldValues.get(0).getFieldType();
        boolean isMonotone = fieldValues.stream().map(FieldValue::getFieldType).allMatch(type -> type.equals((Object)fieldType));
        if (!isMonotone) {
            throw new TrendzInternalException("The fields have different field type during fill gaps!");
        }
    }

    private void validateFieldTypeToProvidedStrategy(FieldType fieldType, FillGapStrategy strategy) {
        switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$field$FieldType[fieldType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                if (Set.of(FieldType.BLANK, FillGapStrategy.LEFT, FillGapStrategy.RIGHT).contains(strategy)) break;
                throw new BadConfiguredTaskException("Unsupported field type for given strategy, type = [" + String.valueOf(fieldType) + "], strategy = [" + String.valueOf(strategy) + "]");
            }
            default: {
                throw new BadConfiguredTaskException("Unsupported field type: " + String.valueOf(fieldType));
            }
        }
    }

    private void validateTimeRangeCorresponding(List<FieldValue> fieldValues, long startTs, long endTs, ZoneId zoneId) {
        FieldValue first = fieldValues.get(0);
        FieldValue last = fieldValues.get(fieldValues.size() - 1);
        if (first.getTs() < startTs || endTs < last.getTs()) {
            String message = "The provided data does not corresponding to given time range:\n    range start = %s [%s],\n    range end = %s [%s],\n    first point time = %s [%s],\n    last point time = %s [%s],\n".formatted(startTs, DateTimeUtils.fromTs((long)startTs, (ZoneId)zoneId), endTs, DateTimeUtils.fromTs((long)endTs, (ZoneId)zoneId), first.getTs(), DateTimeUtils.fromTs((long)first.getTs(), (ZoneId)zoneId), last.getTs(), DateTimeUtils.fromTs((long)last.getTs(), (ZoneId)zoneId));
            throw new TrendzInternalException(message);
        }
    }

    private List<Pair<TimeRange, List<FieldValue>>> groupValuesToRanges(List<FieldValue> values, List<TimeRange> ranges) {
        ArrayList<Pair<TimeRange, List<FieldValue>>> result = new ArrayList<Pair<TimeRange, List<FieldValue>>>();
        ArrayList<FieldValue> currentRangeValues = new ArrayList<FieldValue>();
        Iterator<FieldValue> valueIterator = values.iterator();
        FieldValue currentValue = valueIterator.next();
        TimeRange prevRange = null;
        for (TimeRange range : ranges) {
            if (currentValue == null) {
                if (!currentRangeValues.isEmpty()) {
                    result.add((Pair<TimeRange, List<FieldValue>>)Pair.of((Object)prevRange, currentRangeValues));
                    currentRangeValues = new ArrayList();
                }
                result.add((Pair<TimeRange, List<FieldValue>>)Pair.of((Object)range, new ArrayList()));
            } else {
                while (currentValue != null) {
                    if (currentValue.getTs() < range.getEndTs()) {
                        currentRangeValues.add(currentValue);
                        currentValue = valueIterator.hasNext() ? valueIterator.next() : null;
                        continue;
                    }
                    result.add((Pair<TimeRange, List<FieldValue>>)Pair.of((Object)range, currentRangeValues));
                    currentRangeValues = new ArrayList();
                    break;
                }
            }
            prevRange = range;
        }
        if (!currentRangeValues.isEmpty()) {
            result.add((Pair<TimeRange, List<FieldValue>>)Pair.of((Object)ranges.get(ranges.size() - 1), currentRangeValues));
        }
        return result;
    }

    private List<FieldValue> findAndSolveGaps(List<Pair<TimeRange, List<FieldValue>>> groupedRangeValues, FillGapStrategy strategy) {
        ArrayList<FieldValue> resultPoints = new ArrayList<FieldValue>();
        ArrayList<TimeRange> gaps = new ArrayList<TimeRange>();
        FieldValue left = null;
        FieldValue right = null;
        boolean previousWasEmpty = false;
        for (Pair<TimeRange, List<FieldValue>> groupedRangeValue : groupedRangeValues) {
            TimeRange currentTimeRange = (TimeRange)groupedRangeValue.getLeft();
            List currentValueGroup = (List)groupedRangeValue.getRight();
            if (currentValueGroup.isEmpty()) {
                previousWasEmpty = true;
                gaps.add(currentTimeRange);
                continue;
            }
            if (previousWasEmpty) {
                right = (FieldValue)currentValueGroup.get(0);
                List newValues = this.gapSolveService.resolveGap(left, right, gaps, strategy);
                resultPoints.addAll(newValues);
                gaps.clear();
                previousWasEmpty = false;
            }
            resultPoints.addAll(currentValueGroup);
            left = (FieldValue)currentValueGroup.get(currentValueGroup.size() - 1);
        }
        if (previousWasEmpty) {
            List newValues = this.gapSolveService.resolveGap(left, null, gaps, strategy);
            resultPoints.addAll(newValues);
        }
        return resultPoints;
    }
}

