/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.service.aggregation.DateAggregationGroup;

public class AggregatedValue {
    private FieldValue fieldValue;
    private Set<Item> items;
    private Map<DateAggregationGroup, FieldValue> dateGroups;

    public AggregatedValue(AggregatedValue that) {
        this.fieldValue = that.fieldValue == null ? null : new FieldValue(that.fieldValue);
        this.items = that.items == null ? null : that.items.stream().map(Item::new).collect(Collectors.toSet());
        this.dateGroups = that.dateGroups == null ? null : that.dateGroups.entrySet().stream().map(entry -> Map.entry(new DateAggregationGroup((DateAggregationGroup)entry.getKey()), new FieldValue((FieldValue)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public AggregatedValue(FieldValue fieldValue, Set<Item> items) {
        this.fieldValue = fieldValue;
        this.items = items;
    }

    public boolean hasDateGroups() {
        return MapUtils.isNotEmpty((Map)this.dateGroups);
    }

    public String toString() {
        return "AggregatedValue[fieldValue=" + String.valueOf(this.fieldValue == null ? null : this.fieldValue.getInnerValue()) + ", items=" + Arrays.toString(this.items.toArray()) + ", dateAggregationGroup=" + (this.dateGroups == null ? null : Integer.valueOf(this.dateGroups.entrySet().size())) + "]";
    }

    @Generated
    public FieldValue getFieldValue() {
        return this.fieldValue;
    }

    @Generated
    public Set<Item> getItems() {
        return this.items;
    }

    @Generated
    public Map<DateAggregationGroup, FieldValue> getDateGroups() {
        return this.dateGroups;
    }

    @Generated
    public AggregatedValue(FieldValue fieldValue, Set<Item> items, Map<DateAggregationGroup, FieldValue> dateGroups) {
        this.fieldValue = fieldValue;
        this.items = items;
        this.dateGroups = dateGroups;
    }
}

