/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.version;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.info.BuildProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.system.Deployment;
import org.thingsboard.trendz.domain.version.TrendzVersion;
import org.thingsboard.trendz.service.startup.TrendzStartupService;

@Service
public class TrendzVersionService
implements TrendzStartupService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrendzVersionService.class);
    private final Deployment deployment;
    private final BuildProperties buildProperties;

    @Autowired
    public TrendzVersionService(Deployment deployment, BuildProperties buildProperties) {
        this.deployment = deployment;
        this.buildProperties = buildProperties;
    }

    public TrendzVersion getTrendzVersion() {
        if (this.buildProperties == null) {
            return TrendzVersion.builder().version("unknown").build();
        }
        Instant time = this.buildProperties.getTime();
        String formattedTime = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm").withZone(ZoneId.systemDefault()).format(time);
        return TrendzVersion.builder().version(this.buildProperties.getVersion()).artifact(this.buildProperties.getArtifact()).name(this.buildProperties.getName()).time(formattedTime).cloud(this.deployment.isCloud()).test(this.deployment.isTest()).build();
    }

    public void onStartup(ApplicationContext context) {
        TrendzVersion v = this.getTrendzVersion();
        log.info(" \n=== Trendz Version Data ===\n           Version: {}\n          Artifact: {}\n              Name: {}\n        Build time: {}\n    Cloud instance: {}\n     Test instance: {}\n", new Object[]{v.getVersion(), v.getArtifact(), v.getName(), v.getTime(), v.isCloud(), v.isTest()});
    }

    public int priority() {
        return 1;
    }
}

