/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.topology;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.business.RelationId;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityQuery;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityFieldQuery;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.entity.relation.Relation;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.service.task.progress_content.TopologyDiscoveryProgressContent;

@Service
public class TopologyMergeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TopologyMergeService.class);

    public List<BusinessEntity> merge(TopologyDiscoveryProgressContent mutableContent, Collection<BusinessEntity> oldTopology, Collection<BusinessEntity> newTopology) {
        BusinessEntity newEntity;
        BusinessEntity oldEntity;
        BusinessEntity newEntity2;
        BusinessEntity oldEntity2;
        this.validateTopology(oldTopology, "old");
        this.validateTopology(newTopology, "new");
        this.clearRemovedRelations(oldTopology);
        ArrayList<BusinessEntity> resultTopology = new ArrayList<BusinessEntity>();
        Map oldTopologyEntityMap = this.getTopologyEntityMap(oldTopology, "old");
        Map newTopologyEntityMap = this.getTopologyEntityMap(newTopology, "new");
        Set oldTopologyEntityIds = oldTopologyEntityMap.keySet();
        Set newTopologyEntityIds = newTopologyEntityMap.keySet();
        Sets.SetView oldEntityIds = Sets.difference(oldTopologyEntityIds, newTopologyEntityIds);
        Sets.SetView newEntityIds = Sets.difference(newTopologyEntityIds, oldTopologyEntityIds);
        Sets.SetView mergingEntityIds = Sets.intersection(oldTopologyEntityIds, newTopologyEntityIds);
        mutableContent.setEntitiesDetectedOld(oldEntityIds.size());
        mutableContent.setEntitiesDetectedNew(newEntityIds.size());
        mutableContent.setEntitiesDetectedIntersects(mergingEntityIds.size());
        for (BusinessEntityQuery entityQuery : oldEntityIds) {
            oldEntity2 = (BusinessEntity)oldTopologyEntityMap.get(entityQuery);
            resultTopology.add(oldEntity2);
        }
        for (BusinessEntityQuery entityQuery : newEntityIds) {
            BusinessEntity newEntity3 = (BusinessEntity)newTopologyEntityMap.get(entityQuery);
            resultTopology.add(newEntity3);
        }
        for (BusinessEntityQuery entityQuery : mergingEntityIds) {
            oldEntity2 = (BusinessEntity)oldTopologyEntityMap.get(entityQuery);
            newEntity2 = (BusinessEntity)newTopologyEntityMap.get(entityQuery);
            Set oldTopologyFieldIds = oldEntity2.getFields().stream().map(BusinessEntityField::getQuery).collect(Collectors.toSet());
            Set newTopologyFieldIds = newEntity2.getFields().stream().map(BusinessEntityField::getQuery).collect(Collectors.toSet());
            Set newFieldIds = this.difference(newTopologyFieldIds, oldTopologyFieldIds);
            Map newFieldsMap = this.getTopologyEntityFieldMap(newEntity2, "new");
            for (BusinessEntityFieldQuery fieldQuery : newFieldIds) {
                BusinessEntityField newField = new BusinessEntityField((BusinessEntityField)newFieldsMap.get(fieldQuery));
                newField.setBusinessEntityId(oldEntity2.getId());
                oldEntity2.getFields().add(newField);
            }
            resultTopology.add(oldEntity2);
        }
        HashMap<UUID, UUID> newToOldEntityIdMap = new HashMap<UUID, UUID>();
        for (BusinessEntityQuery entityQuery : mergingEntityIds) {
            oldEntity = (BusinessEntity)oldTopologyEntityMap.get(entityQuery);
            newEntity = (BusinessEntity)newTopologyEntityMap.get(entityQuery);
            newToOldEntityIdMap.put(newEntity.getId(), oldEntity.getId());
        }
        for (BusinessEntityQuery entityQuery : mergingEntityIds) {
            oldEntity = (BusinessEntity)oldTopologyEntityMap.get(entityQuery);
            newEntity = (BusinessEntity)newTopologyEntityMap.get(entityQuery);
            this.mergeRelations(oldEntity, oldEntity.getRelations(), newEntity.getRelations(), newToOldEntityIdMap);
        }
        for (BusinessEntityQuery entityQuery : newEntityIds) {
            newEntity2 = (BusinessEntity)newTopologyEntityMap.get(entityQuery);
            this.mergeRelations(newEntity2, Collections.emptyList(), newEntity2.getRelations(), newToOldEntityIdMap);
        }
        return resultTopology;
    }

    private void validateTopology(Collection<BusinessEntity> topology, String oldOrNew) {
        topology.stream().filter(businessEntity -> businessEntity.getQuery() == null).findAny().ifPresent(businessEntity -> {
            String message = String.format("Topology (%s) entity has null query: %s", oldOrNew, businessEntity.getName());
            throw new TrendzException(message);
        });
        topology.stream().filter(businessEntity -> businessEntity.getFields() == null).findAny().ifPresent(businessEntity -> {
            String message = String.format("Topology (%s) entity has null field list: %s", oldOrNew, businessEntity.getName());
            throw new TrendzException(message);
        });
        topology.stream().map(BusinessEntity::getFields).flatMap(Collection::stream).filter(businessEntityField -> businessEntityField.getQuery() == null).findAny().ifPresent(businessEntityField -> {
            String message = String.format("Topology (%s) entity field has null query: %s", oldOrNew, businessEntityField.getName());
            throw new TrendzException(message);
        });
        topology.stream().filter(businessEntity -> businessEntity.getRelations() == null).findAny().ifPresent(businessEntity -> {
            String message = String.format("Topology (%s) entity has null relation list: %s", oldOrNew, businessEntity.getName());
            throw new TrendzException(message);
        });
    }

    private void clearRemovedRelations(Collection<BusinessEntity> topology) {
        Set entityIdSet = topology.stream().map(BusinessEntity::getId).collect(Collectors.toSet());
        for (BusinessEntity entity : topology) {
            if (!CollectionUtils.isNotEmpty((Collection)entity.getRelations())) continue;
            HashSet<Relation> relationsToRemove = new HashSet<Relation>();
            for (Relation relation : entity.getRelations()) {
                if (entityIdSet.contains(relation.getRelatedEntityId())) continue;
                relationsToRemove.add(relation);
                log.warn("Removed relation {} for {}", (Object)relation, (Object)entity.getName());
            }
            entity.getRelations().removeAll(relationsToRemove);
        }
    }

    private Map<BusinessEntityQuery, BusinessEntity> getTopologyEntityMap(Collection<BusinessEntity> topology, String oldOrNew) {
        return topology.stream().collect(Collectors.toMap(BusinessEntity::getQuery, Function.identity(), (o1, o2) -> {
            String message = String.format("Can not proceed topology merge - (%s) topology has entities with the same Query. Please, remove excess business entities.", oldOrNew);
            throw new TrendzException(message);
        }));
    }

    private Map<BusinessEntityFieldQuery, BusinessEntityField> getTopologyEntityFieldMap(BusinessEntity entity, String oldOrNew) {
        return entity.getFields().stream().collect(Collectors.toMap(BusinessEntityField::getQuery, Function.identity(), (o1, o2) -> {
            String message = String.format("Can not proceed topology merge - (%s) topology entity has fields with the same Query. Please, remove excess business entity fields.", oldOrNew);
            throw new TrendzException(message);
        }));
    }

    private void mergeRelations(BusinessEntity entity, List<Relation> oldRelations, List<Relation> newRelations, Map<UUID, UUID> newToOldEntityIdMap) {
        ArrayList<Relation> startRelations = new ArrayList<Relation>();
        startRelations.addAll(oldRelations);
        startRelations.addAll(newRelations);
        HashSet<RelationId> uniqueRelationIds = new HashSet<RelationId>();
        HashSet<Relation> finalRelations = new HashSet<Relation>();
        for (Relation relation : startRelations) {
            RelationId relationId;
            UUID relatedEntityId = relation.getRelatedEntityId();
            if (newToOldEntityIdMap.containsKey(relatedEntityId)) {
                UUID oldRelatedEntityId = newToOldEntityIdMap.get(relatedEntityId);
                relation.setRelatedEntityId(oldRelatedEntityId);
            }
            if (uniqueRelationIds.contains(relationId = relation.makeRelationId(null))) continue;
            uniqueRelationIds.add(relationId);
            finalRelations.add(relation);
        }
        entity.setRelations(new ArrayList(finalRelations));
    }

    private Set<BusinessEntityFieldQuery> difference(Set<BusinessEntityFieldQuery> newFields, Set<BusinessEntityFieldQuery> oldFields) {
        Set newFieldsTransformed = newFields.stream().map(BusinessEntityFieldQuery::new).peek(query -> {
            if (query.getQueryType().hasTime()) {
                query.setQueryType(FieldQueryType.TELEMETRY);
            }
        }).collect(Collectors.toSet());
        Set oldFieldsTransformed = oldFields.stream().map(BusinessEntityFieldQuery::new).peek(query -> {
            if (query.getQueryType().hasTime()) {
                query.setQueryType(FieldQueryType.TELEMETRY);
            }
        }).collect(Collectors.toSet());
        return Sets.difference(newFieldsTransformed, oldFieldsTransformed);
    }
}

