/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.topology;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityQuery;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityFieldQuery;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.provider.TbAssetService;
import org.thingsboard.trendz.service.provider.TbDeviceService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.task.progress_content.TopologyDiscoveryProgressContent;
import org.thingsboard.trendz.service.topology.DiscoveryConfig;
import org.thingsboard.trendz.service.topology.TbRelationDiscovery;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class TopologyDiscoveryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TopologyDiscoveryService.class);
    private final TbRelationDiscovery relationDiscovery;
    private final TbAssetService assetService;
    private final TbDeviceService deviceService;
    private final TbRestDataSource apiClient;

    @Autowired
    public TopologyDiscoveryService(TbRelationDiscovery relationDiscovery, TbAssetService assetService, TbDeviceService deviceService, TbRestDataSource apiClient) {
        this.relationDiscovery = relationDiscovery;
        this.assetService = assetService;
        this.deviceService = deviceService;
        this.apiClient = apiClient;
    }

    public Flux<BusinessEntity> discoverTopology(TaskExecutionProgressStepBuilder progressBuilder, DiscoveryConfig discoveryConfig, JwtSecurityUser user) {
        TopologyDiscoveryProgressContent mutableContent = (TopologyDiscoveryProgressContent)progressBuilder.getStepContent(TopologyDiscoveryProgressContent.class);
        mutableContent.setCurrentState("Start new topology discovery");
        return Flux.merge((Publisher[])new Publisher[]{progressBuilder.makeStep("Discover Assets", this.fetchAssetSchema(mutableContent, discoveryConfig, user)), progressBuilder.makeStep("Discover Devices", this.fetchDeviceSchema(mutableContent, discoveryConfig, user))}).doOnNext(businessEntity -> businessEntity.getFields().forEach(field -> {
            field.setId(TimeStampUUIDGenerator.generateId());
            field.setBusinessEntityId(businessEntity.getId());
        })).collectList().doOnNext(businessEntities -> log.info("Discovered topology has {} business entities.", (Object)businessEntities.size())).flatMapMany(businessEntities -> progressBuilder.makeStep("Discover Relations", this.relationDiscovery.discoverRelations(mutableContent, businessEntities, discoveryConfig, user)));
    }

    private Flux<BusinessEntity> fetchAssetSchema(TopologyDiscoveryProgressContent mutableContent, DiscoveryConfig discoveryConfig, JwtSecurityUser user) {
        return this.assetService.loadAssetTypes(user).filter(arg_0 -> this.isNotIgnorableAssetType(arg_0)).collect(Collectors.toSet()).doOnNext(assetTypes -> log.info("Found asset types {}", (Object)assetTypes.size())).doOnNext(assetTypes -> mutableContent.setAssetTypes(assetTypes.size())).flatMapIterable(Function.identity()).flatMap(assetType -> this.processAssetType(assetType, user, mutableContent, discoveryConfig)).collectList().doOnNext(list -> log.info("Finish asset schema loading")).flatMapIterable(Function.identity());
    }

    private Mono<BusinessEntity> processAssetType(String assetType, JwtSecurityUser user, TopologyDiscoveryProgressContent mutableContent, DiscoveryConfig discoveryConfig) {
        return this.assetService.countAssetsByType(user, assetType).flatMap(assetCount -> {
            int neededCount = Math.toIntExact(discoveryConfig.determineItemToAnalyze(assetCount.longValue()));
            return this.assetService.loadAssetByType(assetType, user, neededCount).collect(Collectors.toSet()).doOnNext(assets -> mutableContent.getAssetsDetected().addAndGet(assets.size())).flatMap(assets -> this.processAssets(assets, assetType, user).doOnNext(businessEntity -> mutableContent.getAssetsAnalyzed().addAndGet(assets.size())));
        });
    }

    private Mono<BusinessEntity> processAssets(Set<Asset> assets, String assetType, JwtSecurityUser user) {
        log.info("Load {} assets for type {}", (Object)assets.size(), (Object)assetType);
        if (assets.isEmpty()) {
            return Mono.empty();
        }
        Map fieldMap = this.createInitialFieldsMap(assetType);
        return Flux.fromIterable(assets).flatMap(a -> this.fetchAssetFields(a, fieldMap, user, user.getTenantId())).collectList().map(list -> this.fromFieldMap(fieldMap, assetType, BusinessEntityType.ASSET, user));
    }

    private Flux<BusinessEntity> fetchDeviceSchema(TopologyDiscoveryProgressContent mutableContent, DiscoveryConfig discoveryConfig, JwtSecurityUser user) {
        return this.deviceService.loadDeviceTypes(user).filter(arg_0 -> this.isNotIgnorableAssetType(arg_0)).collect(Collectors.toSet()).doOnNext(deviceTypes -> log.info("Found device types {}", (Object)deviceTypes.size())).doOnNext(deviceTypes -> mutableContent.setDeviceTypes(deviceTypes.size())).flatMapIterable(Function.identity()).flatMap(deviceType -> this.processDevicesType(deviceType, user, mutableContent, discoveryConfig)).collectList().doOnNext(list -> log.info("Finish device schema loading")).flatMapIterable(Function.identity());
    }

    private Mono<BusinessEntity> processDevicesType(String deviceType, JwtSecurityUser user, TopologyDiscoveryProgressContent mutableContent, DiscoveryConfig discoveryConfig) {
        return this.deviceService.countDevicesByType(user, deviceType).flatMap(deviceCount -> {
            int neededCount = Math.toIntExact(discoveryConfig.determineItemToAnalyze(deviceCount.longValue()));
            return this.deviceService.loadDeviceByType(deviceType, user, neededCount).collect(Collectors.toSet()).doOnNext(devices -> mutableContent.getDevicesDetected().addAndGet(devices.size())).flatMap(devices -> this.processDevices(devices, deviceType, user).doOnNext(businessEntity -> mutableContent.getDevicesAnalyzed().addAndGet(devices.size())));
        });
    }

    private Mono<BusinessEntity> processDevices(Set<Device> devices, String deviceType, JwtSecurityUser user) {
        log.info("Load {} devices for type {}", (Object)devices.size(), (Object)deviceType);
        if (devices.isEmpty()) {
            return Mono.empty();
        }
        Map fieldMap = this.createInitialFieldsMap(deviceType);
        return Flux.fromIterable(devices).flatMap(device -> this.fetchDeviceFields(device, fieldMap, user, user.getTenantId())).collectList().map(list -> this.fromFieldMap(fieldMap, deviceType, BusinessEntityType.DEVICE, user));
    }

    private BusinessEntity fromFieldMap(Map<String, BusinessEntityField> fieldMap, String profileName, BusinessEntityType businessEntityType, JwtSecurityUser user) {
        ArrayList entityFields = Lists.newArrayList(fieldMap.values());
        this.resolveNameDuplicates((List)entityFields);
        return BusinessEntity.builder().id(TimeStampUUIDGenerator.generateId()).tenantId(user.getTenantId()).name(profileName).description("").fields((List)entityFields).relations(new ArrayList()).query(new BusinessEntityQuery(businessEntityType, profileName)).sharedWithCustomers(false).build();
    }

    private Map<String, BusinessEntityField> createInitialFieldsMap(String profileName) {
        ConcurrentHashMap<String, BusinessEntityField> fields = new ConcurrentHashMap<String, BusinessEntityField>();
        BusinessEntityField idField = this.buildField(profileName + " ID", FieldQueryType.ENTITY_ID, null, (Object)"");
        BusinessEntityField nameField = this.buildField(profileName, FieldQueryType.ENTITY_NAME, null, (Object)"");
        BusinessEntityField labelField = this.buildField(profileName + " Label", FieldQueryType.ENTITY_LABEL, null, (Object)"");
        BusinessEntityField ownerField = this.buildField("Owner", FieldQueryType.OWNER, null, (Object)"");
        fields.put(idField.getName() + System.currentTimeMillis(), idField);
        fields.put(nameField.getName() + System.currentTimeMillis(), nameField);
        fields.put(labelField.getName() + System.currentTimeMillis(), labelField);
        fields.put(ownerField.getName() + System.currentTimeMillis(), ownerField);
        return fields;
    }

    private Flux<Long> fetchAssetFields(Asset asset, Map<String, BusinessEntityField> fields, JwtSecurityUser user, UUID tenantId) {
        return Flux.merge((Publisher[])new Publisher[]{this.fetchAttributeFields("SERVER_SCOPE", EntityType.ASSET, asset.getUuidId(), fields, user, tenantId), this.fetchTelemetryFields(BusinessEntityType.ASSET, asset.getUuidId(), fields, user, tenantId)}).doOnError(throwable -> log.error("Error fetching asset fields", throwable));
    }

    private Flux<Long> fetchDeviceFields(Device device, Map<String, BusinessEntityField> fields, JwtSecurityUser user, UUID tenantId) {
        return Flux.merge((Publisher[])new Publisher[]{this.fetchAttributeFields("CLIENT_SCOPE", EntityType.DEVICE, device.getUuidId(), fields, user, tenantId), this.fetchAttributeFields("SHARED_SCOPE", EntityType.DEVICE, device.getUuidId(), fields, user, tenantId), this.fetchAttributeFields("SERVER_SCOPE", EntityType.DEVICE, device.getUuidId(), fields, user, tenantId), this.fetchTelemetryFields(BusinessEntityType.DEVICE, device.getUuidId(), fields, user, tenantId)}).doOnError(throwable -> log.error("Error fetching device fields", throwable));
    }

    private Mono<Long> fetchAttributeFields(String scope, EntityType entityType, UUID id, Map<String, BusinessEntityField> fields, JwtSecurityUser user, UUID tenantId) {
        return this.apiClient.findAttributeKeys(scope, entityType.name(), id, user).map(Optional::get).map(keys -> keys.stream().filter(key -> {
            if (key == null) {
                log.warn("null key was detected for item {} for tenant {} for scope {}. Skipped.", new Object[]{id, tenantId, scope});
                return false;
            }
            String uniqueKey = key + "_" + scope + "_attr";
            return !fields.containsKey(uniqueKey);
        }).collect(Collectors.toSet())).filter(keys -> !keys.isEmpty()).flatMapMany(key -> this.apiClient.loadAttribute(user, entityType.name(), id, scope, key)).map(attr -> this.buildField(attr.getKey(), FieldQueryType.ATTRIBUTE, scope, attr.getValue())).doOnNext(field -> fields.put(field.uniqKey(), (BusinessEntityField)field)).count();
    }

    private Mono<Long> fetchTelemetryFields(BusinessEntityType entityType, UUID id, Map<String, BusinessEntityField> fields, JwtSecurityUser user, UUID tenantId) {
        return this.apiClient.findTelemetryKeys(entityType.name(), id, user).map(Optional::get).map(keys -> keys.stream().filter(key -> {
            if (key == null) {
                log.warn("null key was detected for item {} for tenant {}. Skipped.", (Object)id, (Object)tenantId);
                return false;
            }
            String uniqueKey = key + "_ts_key";
            return !fields.containsKey(uniqueKey);
        }).collect(Collectors.toSet())).filter(keys -> !keys.isEmpty()).flatMapMany(key -> this.apiClient.loadLatestTelemetry(user, entityType, id, key, null)).flatMapIterable(Map::entrySet).flatMapIterable(entry -> ((List)entry.getValue()).stream().filter(v -> v.getValue() != null).map(v -> Pair.of((Object)((String)entry.getKey()), (Object)v.getValue())).collect(Collectors.toList())).map(tuple -> this.buildField((String)tuple.getLeft(), FieldQueryType.TELEMETRY, null, tuple.getRight())).doOnNext(field -> fields.put(field.uniqKey(), (BusinessEntityField)field)).count();
    }

    private void resolveNameDuplicates(List<BusinessEntityField> entityFields) {
        Map nameDuplicatedFieldsMap = entityFields.stream().filter(field -> {
            if (field.getName() == null) {
                throw new TrendzException("Found null name for field %s, query = %s".formatted(field.getId(), field.getQuery()));
            }
            return true;
        }).collect(Collectors.groupingBy(BusinessEntityField::getName, Collectors.toList()));
        for (List fieldListByName : nameDuplicatedFieldsMap.values()) {
            if (fieldListByName.size() <= 1) continue;
            Map typeDuplicatedFieldMap = fieldListByName.stream().collect(Collectors.groupingBy(i -> i.getQuery().getQueryType(), Collectors.toList()));
            for (List fieldListByType : typeDuplicatedFieldMap.values()) {
                if (fieldListByName.size() <= 1) {
                    BusinessEntityField field2 = (BusinessEntityField)fieldListByName.iterator().next();
                    FieldQueryType queryType = field2.getQuery().getQueryType();
                    field2.setName(field2.getName() + "_" + queryType.name());
                    continue;
                }
                Map scopeDuplicatedFieldMap = fieldListByType.stream().collect(Collectors.groupingBy(i -> (String)ObjectUtils.firstNonNull((Object[])new String[]{i.getQuery().getScope(), ""}), Collectors.toList()));
                for (List fieldListByScope : scopeDuplicatedFieldMap.values()) {
                    if (fieldListByScope.size() <= 1) {
                        BusinessEntityField field3 = (BusinessEntityField)fieldListByScope.iterator().next();
                        FieldQueryType queryType = field3.getQuery().getQueryType();
                        String scope = (String)ObjectUtils.firstNonNull((Object[])new String[]{field3.getQuery().getScope(), ""});
                        field3.setName(field3.getName() + "_" + queryType.name() + (String)(scope.isEmpty() ? "" : "_" + scope));
                        continue;
                    }
                    throw new IllegalStateException("The business fields are absolutely same: " + Arrays.toString(fieldListByScope.stream().map(BusinessEntityField::getName).toArray()));
                }
            }
        }
    }

    private BusinessEntityField buildField(String key, FieldQueryType queryType, String scope, Object value) {
        FieldType fieldType = this.detectType(value.toString());
        return BusinessEntityField.builder().id(TimeStampUUIDGenerator.generateId()).businessEntityId(null).name(key).description("").hidden(false).type(fieldType).query(new BusinessEntityFieldQuery(queryType, key, scope)).calcFunction(null).build();
    }

    private FieldType detectType(String value) {
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
            return FieldType.BOOLEAN;
        }
        if (NumberUtils.isParsable((String)value)) {
            try {
                Double.parseDouble(value);
            }
            catch (NumberFormatException ignored) {
                return FieldType.STRING;
            }
            return FieldType.NUMERIC;
        }
        return FieldType.STRING;
    }

    private boolean isNotIgnorableAssetType(String assetType) {
        return !Set.of("AlarmPropagationAsset", "TbServiceQueue").contains(assetType);
    }

    public static <T> List<T> chooseItemsToAnalyse(Set<T> allItems, DiscoveryConfig discoveryConfig) {
        if ((long)allItems.size() < discoveryConfig.getMinItemToAnalyze()) {
            return new ArrayList<T>(allItems);
        }
        ArrayList itemsToAnalyze = Lists.newArrayList();
        int analyzed = 0;
        for (T item : allItems) {
            if (!((double)(++analyzed % 100) < discoveryConfig.getAnalyzePercent())) continue;
            itemsToAnalyze.add(item);
        }
        return itemsToAnalyze;
    }
}

