/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.topology;

import lombok.Generated;

public class DiscoveryConfig {
    private long minItemToAnalyze;
    private long maxItemToAnalyze;
    private double analyzePercent;

    public DiscoveryConfig(DiscoveryConfig that) {
        this.minItemToAnalyze = that.minItemToAnalyze;
        this.maxItemToAnalyze = that.maxItemToAnalyze;
        this.analyzePercent = that.analyzePercent;
    }

    public DiscoveryConfig clone() {
        return new DiscoveryConfig(this);
    }

    public long determineItemToAnalyze(long totalCount) {
        long count = this.maxItemToAnalyze * totalCount;
        return Math.min(this.maxItemToAnalyze, Math.max(this.minItemToAnalyze, count));
    }

    public static DiscoveryConfig getDefault() {
        return new DiscoveryConfig(500L, 10000L, 5.0);
    }

    @Generated
    public void setMinItemToAnalyze(long minItemToAnalyze) {
        this.minItemToAnalyze = minItemToAnalyze;
    }

    @Generated
    public void setMaxItemToAnalyze(long maxItemToAnalyze) {
        this.maxItemToAnalyze = maxItemToAnalyze;
    }

    @Generated
    public void setAnalyzePercent(double analyzePercent) {
        this.analyzePercent = analyzePercent;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DiscoveryConfig)) {
            return false;
        }
        DiscoveryConfig other = (DiscoveryConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getMinItemToAnalyze() != other.getMinItemToAnalyze()) {
            return false;
        }
        if (this.getMaxItemToAnalyze() != other.getMaxItemToAnalyze()) {
            return false;
        }
        return Double.compare(this.getAnalyzePercent(), other.getAnalyzePercent()) == 0;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DiscoveryConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $minItemToAnalyze = this.getMinItemToAnalyze();
        result = result * 59 + (int)($minItemToAnalyze >>> 32 ^ $minItemToAnalyze);
        long $maxItemToAnalyze = this.getMaxItemToAnalyze();
        result = result * 59 + (int)($maxItemToAnalyze >>> 32 ^ $maxItemToAnalyze);
        long $analyzePercent = Double.doubleToLongBits(this.getAnalyzePercent());
        result = result * 59 + (int)($analyzePercent >>> 32 ^ $analyzePercent);
        return result;
    }

    @Generated
    public String toString() {
        return "DiscoveryConfig(minItemToAnalyze=" + this.getMinItemToAnalyze() + ", maxItemToAnalyze=" + this.getMaxItemToAnalyze() + ", analyzePercent=" + this.getAnalyzePercent() + ")";
    }

    @Generated
    public long getMinItemToAnalyze() {
        return this.minItemToAnalyze;
    }

    @Generated
    public long getMaxItemToAnalyze() {
        return this.maxItemToAnalyze;
    }

    @Generated
    public double getAnalyzePercent() {
        return this.analyzePercent;
    }

    @Generated
    public DiscoveryConfig(long minItemToAnalyze, long maxItemToAnalyze, double analyzePercent) {
        this.minItemToAnalyze = minItemToAnalyze;
        this.maxItemToAnalyze = maxItemToAnalyze;
        this.analyzePercent = analyzePercent;
    }

    @Generated
    public DiscoveryConfig() {
    }
}

