/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.tb.widget;

import com.google.common.collect.Sets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.WidgetTypeId;
import org.thingsboard.server.common.data.id.WidgetsBundleId;
import org.thingsboard.trendz.domain.customize.CustomViewSettings;
import org.thingsboard.trendz.domain.definition.ApplicationProperty;
import org.thingsboard.trendz.domain.tb.widget.base.TbResourceStatus;
import org.thingsboard.trendz.domain.tb.widget.base.UploadTbResourceStatus;
import org.thingsboard.trendz.domain.tb.widget.v1.TbWidgetBundleConfigCollectionV1;
import org.thingsboard.trendz.domain.tb.widget.v1.TbWidgetBundleConfigV1;
import org.thingsboard.trendz.domain.tb.widget.v1.TbWidgetBundleItemV1;
import org.thingsboard.trendz.domain.tb.widget.v1.TbWidgetTypeItemV1;
import org.thingsboard.trendz.exception.tb.widget.InvalidActualConfiguration;
import org.thingsboard.trendz.exception.tb.widget.NativeWidgetBundleException;
import org.thingsboard.trendz.exception.tb.widget.UnsupportedVersionException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.customize.CustomizationService;
import org.thingsboard.trendz.service.definition.ApplicationPropertyService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.provider.version.TbVersion;
import org.thingsboard.trendz.service.provider.version.TbVersionChecker;
import org.thingsboard.trendz.service.provider.version.TbVersionNumber;
import org.thingsboard.trendz.service.tb.widget.NativeWidgetBundleService;
import org.thingsboard.trendz.tools.DonReactive;
import org.thingsboard.trendz.tools.json.JsonUtils;
import reactor.core.publisher.Mono;

@Service
public class NativeWidgetBundleServiceV1
implements NativeWidgetBundleService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NativeWidgetBundleServiceV1.class);
    private static final List<String> TYPE_ALIAS_SET = List.of("trendz_builder", "trendz_view_latest", "trendz_view_static");
    private static final Integer MAX_DUPLICATES_COUNT = 10;
    private static final String FILE_V_ANG12 = "native_trendz_bundle_ang12.json";
    private static final String FILE_V_ANG15 = "native_trendz_bundle_ang15.json";
    private final TbVersionChecker versionChecker;
    private final TbRestDataSource restDataSource;
    private final ApplicationPropertyService applicationPropertyService;
    private final CustomizationService customizationService;

    @Autowired
    public NativeWidgetBundleServiceV1(TbVersionChecker versionChecker, TbRestDataSource restDataSource, ApplicationPropertyService applicationPropertyService, CustomizationService customizationService) {
        this.versionChecker = versionChecker;
        this.restDataSource = restDataSource;
        this.applicationPropertyService = applicationPropertyService;
        this.customizationService = customizationService;
    }

    public boolean bundleExists(JwtSecurityUser user) {
        TbWidgetBundleConfigCollectionV1 actualConfigCollection = this.loadConfigCollection(user);
        return !actualConfigCollection.isEmpty();
    }

    public TbResourceStatus getBundleStatus(JwtSecurityUser user, String domain, String externalUrl) {
        try {
            TbVersion version = this.versionChecker.getVersion(user);
            CustomViewSettings customViewSettings = this.customizationService.getCustomViewSettings(domain, user);
            String urlPrefix = customViewSettings.getUrl();
            String companyName = this.customizationService.getCompanyName(urlPrefix);
            TbWidgetBundleConfigCollectionV1 expectedConfigCollection = this.loadWidgetBundleDataForUploading(version, urlPrefix, companyName, externalUrl);
            TbWidgetBundleConfigCollectionV1 actualConfigCollection = this.loadConfigCollection(user);
            if (actualConfigCollection.isEmpty()) {
                this.applicationPropertyService.deleteProperty(ApplicationProperty.Key.BUNDLE_ALIAS);
                return TbResourceStatus.DO_NOT_EXIST;
            }
            TbWidgetBundleConfigV1 config = this.validateActualCollection(actualConfigCollection);
            Map expectedToActualMap = this.makeAliasFqnMapping(version, config);
            this.validateActualConfig(config, expectedToActualMap, version);
            boolean isEqual = this.compareWidgetBundles(actualConfigCollection, expectedConfigCollection, expectedToActualMap);
            if (isEqual) {
                return TbResourceStatus.LATEST;
            }
            return TbResourceStatus.OUTDATED;
        }
        catch (InvalidActualConfiguration e) {
            log.error("The bundle status is {}", (Object)TbResourceStatus.INVALID);
            return TbResourceStatus.INVALID;
        }
    }

    public UploadTbResourceStatus uploadNativeWidgetBundle(JwtSecurityUser user, String domain, String externalUrl) {
        TbVersion version = this.versionChecker.getVersion(user);
        CustomViewSettings customViewSettings = this.customizationService.getCustomViewSettings(domain, user);
        String urlPrefix = customViewSettings.getUrl();
        String companyName = this.customizationService.getCompanyName(urlPrefix);
        TbWidgetBundleConfigCollectionV1 expectedConfigCollection = this.loadWidgetBundleDataForUploading(version, urlPrefix, companyName, externalUrl);
        TbWidgetBundleConfigCollectionV1 actualConfigCollection = this.loadConfigCollection(user);
        if (actualConfigCollection.isEmpty()) {
            log.info("The version of TB is {} {} {}", new Object[]{version.getVersion(), version.isPe() ? "PE" : "CE", version.isCloud() ? "Cloud" : "Self-Managed"});
            TbWidgetBundleConfigCollectionV1 savedCollection = this.createWidgetBundleOnTB(expectedConfigCollection, user);
            String alias = ((TbWidgetBundleConfigV1)savedCollection.getConfigList().iterator().next()).getWidgetsBundle().getAlias();
            this.applicationPropertyService.setProperty(ApplicationProperty.Key.BUNDLE_ALIAS, alias);
            return UploadTbResourceStatus.CREATED;
        }
        TbWidgetBundleConfigV1 config = this.validateActualCollection(actualConfigCollection);
        Map expectedToActualMap = this.makeAliasFqnMapping(version, config);
        this.validateActualConfig(config, expectedToActualMap, version);
        boolean isEqual = this.compareWidgetBundles(actualConfigCollection, expectedConfigCollection, expectedToActualMap);
        if (isEqual) {
            String currentAlias = config.getWidgetsBundle().getAlias();
            this.applicationPropertyService.setProperty(ApplicationProperty.Key.BUNDLE_ALIAS, currentAlias);
            return UploadTbResourceStatus.ALREADY_EXISTS;
        }
        TbWidgetBundleConfigCollectionV1 savedCollection = this.updateWidgetBundleOnTB(actualConfigCollection, expectedConfigCollection, expectedToActualMap, user);
        String savedAlias = ((TbWidgetBundleConfigV1)savedCollection.getConfigList().iterator().next()).getWidgetsBundle().getAlias();
        this.applicationPropertyService.setProperty(ApplicationProperty.Key.BUNDLE_ALIAS, savedAlias);
        return UploadTbResourceStatus.UPDATED;
    }

    private String getWidgetPrefixLocal(TbVersion version) {
        if (version.getVersion().less(TbVersionNumber.V_3_6_1)) {
            return "";
        }
        return "trendz_bundle.";
    }

    private Map<String, String> makeAliasFqnMapping(TbVersion version, TbWidgetBundleConfigV1 config) {
        TbWidgetBundleItemV1 widgetsBundle = config.getWidgetsBundle();
        List widgetTypes = config.getWidgetTypes();
        Map<String, Long> uniqTypeFqns = widgetTypes.stream().collect(Collectors.groupingBy(TbWidgetTypeItemV1::getAlias, Collectors.counting()));
        Map<String, String> expectedToActualMap = uniqTypeFqns.keySet().stream().map(actualFqn -> {
            for (String expectedFqn : TYPE_ALIAS_SET) {
                String expectedFqnFull = this.getWidgetPrefixLocal(version) + expectedFqn;
                String pattern = "^%s\\d*_%s\\d*$".formatted("trendz_bundle", expectedFqn);
                if (!actualFqn.matches(pattern)) continue;
                return Map.entry(expectedFqnFull, actualFqn);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (o1, o2) -> o1));
        expectedToActualMap.put("trendz_bundle", widgetsBundle.getAlias());
        return expectedToActualMap;
    }

    private TbWidgetBundleConfigCollectionV1 loadWidgetBundleDataForUploading(TbVersion version, String urlPrefix, String companyName, String externalUrl) {
        TbWidgetBundleConfigV1 config = this.loadWidgetBundleFromFile(version);
        TbWidgetBundleItemV1 widgetsBundle = config.getWidgetsBundle();
        List widgetTypes = config.getWidgetTypes();
        for (TbWidgetTypeItemV1 widgetsType : widgetTypes) {
            Map descriptor = (Map)widgetsType.getAdditionalProperties().get("descriptor");
            List resourceList = (List)descriptor.get("resources");
            if (resourceList.isEmpty()) continue;
            Map resource = (Map)resourceList.iterator().next();
            String url = resource.get("url").toString();
            String newUrl = externalUrl + "/" + urlPrefix + url.substring(7);
            resource.put("url", newUrl);
        }
        if (!companyName.equals("Trendz")) {
            String title = this.replaceCompanyLabel(widgetsBundle.getTitle(), companyName);
            String description = this.replaceCompanyLabel(widgetsBundle.getDescription(), companyName);
            widgetsBundle.setTitle(title);
            widgetsBundle.setDescription(description);
            for (TbWidgetTypeItemV1 widgetsType : widgetTypes) {
                String typeName = this.replaceCompanyLabel(widgetsType.getName(), companyName);
                widgetsType.setName(typeName);
                Map descriptor = (Map)widgetsType.getAdditionalProperties().get("descriptor");
                String typeTemplateHtml = this.replaceCompanyLabel(descriptor.get("templateHtml").toString(), companyName);
                String typeDefaultConfig = this.replaceCompanyLabel(descriptor.get("defaultConfig").toString(), companyName);
                descriptor.put("templateHtml", typeTemplateHtml);
                descriptor.put("defaultConfig", typeDefaultConfig);
            }
        }
        return new TbWidgetBundleConfigCollectionV1(List.of(config));
    }

    private TbWidgetBundleConfigV1 loadWidgetBundleFromFile(TbVersion version) {
        TbVersionNumber versionNumber = version.getVersion();
        try {
            Path path;
            if (versionNumber.less(TbVersionNumber.V_3_5_0)) {
                path = Path.of(this.getClass().getClassLoader().getResource("native-widgets-bundle/native_trendz_bundle_ang12.json").toURI());
            } else if (versionNumber.less(TbVersionNumber.V_3_6_0)) {
                path = Path.of(this.getClass().getClassLoader().getResource("native-widgets-bundle/native_trendz_bundle_ang15.json").toURI());
            } else {
                throw new UnsupportedVersionException(versionNumber);
            }
            String data = Files.readString(path);
            return (TbWidgetBundleConfigV1)JsonUtils.fromJson((String)data, TbWidgetBundleConfigV1.class);
        }
        catch (Exception e) {
            throw new NativeWidgetBundleException("Can not load widget bundle from file, version: " + String.valueOf(versionNumber), (Throwable)e);
        }
    }

    private String replaceCompanyLabel(String input, String companyLabel) {
        if (input == null || companyLabel == null) {
            return input;
        }
        return input.replaceAll("Trendz", companyLabel);
    }

    private TbWidgetBundleConfigCollectionV1 loadConfigCollection(JwtSecurityUser user) {
        ArrayList<TbWidgetBundleConfigV1> configs = new ArrayList<TbWidgetBundleConfigV1>();
        List widgetBundles = this.loadTrendzWidgetBundles(user);
        for (TbWidgetBundleItemV1 widgetBundle : widgetBundles) {
            List widgetTypes = ((List)DonReactive.block((Mono)this.restDataSource.loadWidgetTypesV1(widgetBundle.getAlias(), widgetBundle.isSystem(), user))).stream().sorted().collect(Collectors.toList());
            TbWidgetBundleConfigV1 config = new TbWidgetBundleConfigV1(widgetBundle, widgetTypes);
            configs.add(config);
        }
        return new TbWidgetBundleConfigCollectionV1(configs);
    }

    private List<TbWidgetBundleItemV1> loadTrendzWidgetBundles(JwtSecurityUser user) {
        List allBundles = (List)DonReactive.block((Mono)this.restDataSource.loadAllWidgetBundlesV1(user));
        assert (allBundles != null);
        ArrayList<TbWidgetBundleItemV1> trendzBundles = new ArrayList<TbWidgetBundleItemV1>();
        for (int i = 0; i < MAX_DUPLICATES_COUNT; ++i) {
            Object suffix = i == 0 ? "" : "" + i;
            String alias = "trendz_bundle" + (String)suffix;
            List<TbWidgetBundleItemV1> currentBundles = allBundles.stream().filter(bundleItem -> bundleItem.getAlias().equals(alias)).sorted().toList();
            trendzBundles.addAll(currentBundles);
        }
        return trendzBundles;
    }

    private TbWidgetBundleConfigV1 validateActualCollection(TbWidgetBundleConfigCollectionV1 configCollection) {
        if (configCollection.isEmpty()) {
            throw new InvalidActualConfiguration("no bundle detected - need just to be installed");
        }
        if (configCollection.size() != 1) {
            throw new InvalidActualConfiguration("bundle/types duplicate detected - check duplicates and SAFELY remove them");
        }
        return (TbWidgetBundleConfigV1)configCollection.getConfigList().iterator().next();
    }

    private void validateActualConfig(TbWidgetBundleConfigV1 config, Map<String, String> expectedToActualMap, TbVersion version) {
        if (config.getWidgetsBundle().isSystem()) {
            throw new InvalidActualConfiguration("the bundle is added by sysadmin - remove it from sysadmin account and create as tenant again");
        }
        List widgetTypes = config.getWidgetTypes();
        Map<String, Long> uniqTypeAliases = widgetTypes.stream().collect(Collectors.groupingBy(TbWidgetTypeItemV1::getAlias, Collectors.counting()));
        Set expectedAliases = TYPE_ALIAS_SET.stream().map(alias -> {
            String fullAlias = this.getWidgetPrefixLocal(version) + alias;
            return (String)((Object)expectedToActualMap.getOrDefault(fullAlias, fullAlias));
        }).collect(Collectors.toSet());
        Set<String> actualAliases = uniqTypeAliases.keySet();
        Sets.SetView difference = Sets.difference(actualAliases, expectedAliases);
        if (!difference.isEmpty()) {
            String message = "unknown widget types were detected (%s) - SAFELY remove them".formatted(difference);
            throw new InvalidActualConfiguration(message);
        }
        Set duplicatedTypes = uniqTypeAliases.entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (!duplicatedTypes.isEmpty()) {
            String message = "duplicated widget types were detected (%s) - check duplicates and SAFELY remove them".formatted(duplicatedTypes);
            throw new InvalidActualConfiguration(message);
        }
    }

    private boolean compareWidgetBundles(TbWidgetBundleConfigCollectionV1 actualCollection, TbWidgetBundleConfigCollectionV1 expectedCollection, Map<String, String> expectedToActualMap) {
        boolean equals = true;
        if (actualCollection.size() != expectedCollection.size()) {
            return false;
        }
        int configCount = expectedCollection.size();
        for (int i = 0; i < configCount; ++i) {
            TbWidgetBundleConfigV1 actualConfig = (TbWidgetBundleConfigV1)actualCollection.getConfigList().get(i);
            TbWidgetBundleConfigV1 expectedConfig = (TbWidgetBundleConfigV1)expectedCollection.getConfigList().get(i);
            TbWidgetBundleItemV1 actualWidgetsBundle = actualConfig.getWidgetsBundle();
            TbWidgetBundleItemV1 expectedWidgetsBundle = expectedConfig.getWidgetsBundle();
            equals = equals && this.compareField(actualWidgetsBundle, expectedWidgetsBundle, TbWidgetBundleItemV1::getAlias, expectedToActualMap);
            equals = equals && this.compareField(actualWidgetsBundle, expectedWidgetsBundle, TbWidgetBundleItemV1::getTitle);
            equals = equals && this.compareField(actualWidgetsBundle, expectedWidgetsBundle, TbWidgetBundleItemV1::getImage);
            equals = equals && this.compareField(actualWidgetsBundle, expectedWidgetsBundle, TbWidgetBundleItemV1::getDescription);
            List actualWidgetTypesJsonList = actualConfig.getWidgetTypes();
            List expectedWidgetTypesJsonList = expectedConfig.getWidgetTypes();
            Map actualBundleWidgetTypesNodeMap = actualWidgetTypesJsonList.stream().collect(Collectors.toMap(TbWidgetTypeItemV1::getAlias, Function.identity()));
            Map expectedBundleWidgetTypesNodeMap = expectedWidgetTypesJsonList.stream().collect(Collectors.toMap(item -> expectedToActualMap.getOrDefault(item.getAlias(), item.getAlias()), Function.identity()));
            Set<String> actualKeySet = actualBundleWidgetTypesNodeMap.keySet();
            Set<String> expectedKeySet = expectedBundleWidgetTypesNodeMap.keySet();
            boolean bl = equals = equals && actualKeySet.containsAll(expectedKeySet);
            if (!equals) {
                return false;
            }
            for (String alias : expectedKeySet) {
                TbWidgetTypeItemV1 actualWidgetType = (TbWidgetTypeItemV1)actualBundleWidgetTypesNodeMap.get(alias);
                TbWidgetTypeItemV1 expectedWidgetType = (TbWidgetTypeItemV1)expectedBundleWidgetTypesNodeMap.get(alias);
                equals = equals && this.compareField(actualWidgetType, expectedWidgetType, TbWidgetTypeItemV1::getBundleAlias, expectedToActualMap);
                equals = equals && this.compareField(actualWidgetType, expectedWidgetType, TbWidgetTypeItemV1::getAlias, expectedToActualMap);
                equals = equals && this.compareField(actualWidgetType, expectedWidgetType, TbWidgetTypeItemV1::getName);
                Map actualDescriptor = (Map)actualWidgetType.getAdditionalProperties().get("descriptor");
                Map expectedDescriptor = (Map)expectedWidgetType.getAdditionalProperties().get("descriptor");
                equals = equals && this.compareFieldMap((Object)actualDescriptor, (Object)expectedDescriptor, item -> item.get("templateHtml"));
                equals = equals && this.compareFieldMap((Object)actualDescriptor, (Object)expectedDescriptor, item -> item.get("templateCss"));
                equals = equals && this.compareFieldMap((Object)actualDescriptor, (Object)expectedDescriptor, item -> item.get("controllerScript"));
                equals = equals && this.compareFieldMap((Object)actualDescriptor, (Object)expectedDescriptor, item -> item.get("settingsSchema"));
                equals = equals && this.compareFieldMap((Object)actualDescriptor, (Object)expectedDescriptor, item -> item.get("dataKeySettingsSchema"));
                equals = equals && this.compareFieldMap((Object)actualDescriptor, (Object)expectedDescriptor, item -> item.get("defaultConfig"));
                List actualResourceList = (List)actualDescriptor.get("resources");
                List expectedResourceList = (List)expectedDescriptor.get("resources");
                if (!equals || actualResourceList.size() != expectedResourceList.size()) {
                    return false;
                }
                if (actualResourceList.isEmpty()) continue;
                Object actualResource = actualResourceList.iterator().next();
                Object expectedResource = expectedResourceList.iterator().next();
                equals = equals && this.compareFieldMap(actualResource, expectedResource, item -> item.get("url"));
                if (equals = equals && this.compareFieldMap(actualResource, expectedResource, item -> item.get("isModule"))) continue;
                return false;
            }
        }
        return equals;
    }

    private boolean compareField(TbWidgetBundleItemV1 actualItem, TbWidgetBundleItemV1 expectedItem, Function<TbWidgetBundleItemV1, String> fieldFunction, Map<String, String> expectedToActualMap) {
        if (actualItem == null && expectedItem == null) {
            return true;
        }
        if (actualItem == null || expectedItem == null) {
            return false;
        }
        String actualValue = fieldFunction.apply(actualItem);
        String expectedValue = fieldFunction.apply(expectedItem);
        String translatedExpectedValue = expectedToActualMap.getOrDefault(expectedValue, expectedValue);
        return Objects.equals(actualValue, translatedExpectedValue);
    }

    private boolean compareField(TbWidgetBundleItemV1 actualItem, TbWidgetBundleItemV1 expectedItem, Function<TbWidgetBundleItemV1, Object> fieldFunction) {
        if (actualItem == null && expectedItem == null) {
            return true;
        }
        if (actualItem == null || expectedItem == null) {
            return false;
        }
        Object actualValue = fieldFunction.apply(actualItem);
        Object expectedValue = fieldFunction.apply(expectedItem);
        return Objects.equals(actualValue, expectedValue);
    }

    private boolean compareField(TbWidgetTypeItemV1 actualItem, TbWidgetTypeItemV1 expectedItem, Function<TbWidgetTypeItemV1, String> fieldFunction, Map<String, String> expectedToActualMap) {
        if (actualItem == null && expectedItem == null) {
            return true;
        }
        if (actualItem == null || expectedItem == null) {
            return false;
        }
        String actualValue = fieldFunction.apply(actualItem);
        String expectedValue = fieldFunction.apply(expectedItem);
        String translatedExpectedValue = expectedToActualMap.getOrDefault(expectedValue, expectedValue);
        return Objects.equals(actualValue, translatedExpectedValue);
    }

    private boolean compareField(TbWidgetTypeItemV1 actualItem, TbWidgetTypeItemV1 expectedItem, Function<TbWidgetTypeItemV1, Object> fieldFunction) {
        if (actualItem == null && expectedItem == null) {
            return true;
        }
        if (actualItem == null || expectedItem == null) {
            return false;
        }
        Object actualValue = fieldFunction.apply(actualItem);
        Object expectedValue = fieldFunction.apply(expectedItem);
        return Objects.equals(actualValue, expectedValue);
    }

    private boolean compareFieldMap(Object actualItem, Object expectedItem, Function<Map<String, Object>, Object> fieldFunction) {
        if (actualItem == null && expectedItem == null) {
            return true;
        }
        if (actualItem == null || expectedItem == null) {
            return false;
        }
        Map actualMap = (Map)actualItem;
        Map expectedMap = (Map)expectedItem;
        Object actualValue = fieldFunction.apply(actualMap);
        Object expectedValue = fieldFunction.apply(expectedMap);
        return Objects.equals(actualValue, expectedValue);
    }

    private TbWidgetBundleConfigCollectionV1 createWidgetBundleOnTB(TbWidgetBundleConfigCollectionV1 configCollection, JwtSecurityUser user) {
        ArrayList<TbWidgetBundleConfigV1> savedConfigList = new ArrayList<TbWidgetBundleConfigV1>();
        for (TbWidgetBundleConfigV1 config : configCollection.getConfigList()) {
            TbWidgetBundleItemV1 widgetsBundle = config.getWidgetsBundle();
            List widgetTypesList = config.getWidgetTypes();
            TbWidgetBundleItemV1 savedWidgetBundle = (TbWidgetBundleItemV1)DonReactive.block((Mono)this.restDataSource.uploadWidgetBundleV1(widgetsBundle, user));
            ArrayList<TbWidgetTypeItemV1> savedWidgetTypeList = new ArrayList<TbWidgetTypeItemV1>();
            for (TbWidgetTypeItemV1 widgetType : widgetTypesList) {
                TbWidgetTypeItemV1 savedWidgetType = (TbWidgetTypeItemV1)DonReactive.block((Mono)this.restDataSource.uploadWidgetTypeV1(widgetType, user));
                savedWidgetTypeList.add(savedWidgetType);
            }
            TbWidgetBundleConfigV1 savedConfig = new TbWidgetBundleConfigV1(savedWidgetBundle, savedWidgetTypeList);
            savedConfigList.add(savedConfig);
        }
        return new TbWidgetBundleConfigCollectionV1(savedConfigList);
    }

    private TbWidgetBundleConfigCollectionV1 updateWidgetBundleOnTB(TbWidgetBundleConfigCollectionV1 actualCollection, TbWidgetBundleConfigCollectionV1 expectedCollection, Map<String, String> expectedToActualMap, JwtSecurityUser user) {
        TbWidgetBundleConfigV1 actualConfig = (TbWidgetBundleConfigV1)actualCollection.getConfigList().iterator().next();
        TbWidgetBundleConfigV1 expectedConfig = (TbWidgetBundleConfigV1)expectedCollection.getConfigList().iterator().next();
        TbWidgetBundleItemV1 actualWidgetsBundle = actualConfig.getWidgetsBundle();
        TbWidgetBundleItemV1 expectedWidgetsBundle = expectedConfig.getWidgetsBundle();
        WidgetsBundleId actualBundleId = actualWidgetsBundle.getId();
        TenantId actualBundleTenantId = actualWidgetsBundle.getTenantId();
        String actualBundleAlias = actualWidgetsBundle.getAlias();
        expectedWidgetsBundle.setId(actualBundleId);
        expectedWidgetsBundle.setTenantId(actualBundleTenantId);
        expectedWidgetsBundle.setAlias(actualBundleAlias);
        TbWidgetBundleItemV1 savedBundle = (TbWidgetBundleItemV1)DonReactive.block((Mono)this.restDataSource.uploadWidgetBundleV1(expectedWidgetsBundle, user));
        List actualWidgetTypes = actualConfig.getWidgetTypes();
        List expectedWidgetTypes = expectedConfig.getWidgetTypes();
        Map actualBundleWidgetTypesMap = actualWidgetTypes.stream().collect(Collectors.toMap(TbWidgetTypeItemV1::getAlias, Function.identity()));
        Map expectedBundleWidgetTypesMap = expectedWidgetTypes.stream().collect(Collectors.toMap(TbWidgetTypeItemV1::getAlias, Function.identity()));
        ArrayList<TbWidgetTypeItemV1> savedTypeList = new ArrayList<TbWidgetTypeItemV1>();
        for (String expectedAlias : expectedBundleWidgetTypesMap.keySet()) {
            String actualAlias = expectedToActualMap.getOrDefault(expectedAlias, expectedAlias);
            TbWidgetTypeItemV1 actualWidgetType = (TbWidgetTypeItemV1)actualBundleWidgetTypesMap.get(actualAlias);
            TbWidgetTypeItemV1 expectedWidgetType = (TbWidgetTypeItemV1)expectedBundleWidgetTypesMap.get(expectedAlias);
            if (actualWidgetType == null) {
                TbWidgetTypeItemV1 savedWidgetType = (TbWidgetTypeItemV1)DonReactive.block((Mono)this.restDataSource.uploadWidgetTypeV1(expectedWidgetType, user));
                savedTypeList.add(savedWidgetType);
                continue;
            }
            WidgetTypeId typeId = actualWidgetType.getId();
            TenantId typeTenantId = actualWidgetType.getTenantId();
            expectedWidgetType.setId(typeId);
            expectedWidgetType.setTenantId(typeTenantId);
            expectedWidgetType.setAlias(actualAlias);
            TbWidgetTypeItemV1 savedWidgetType = (TbWidgetTypeItemV1)DonReactive.block((Mono)this.restDataSource.uploadWidgetTypeV1(expectedWidgetType, user));
            savedTypeList.add(savedWidgetType);
        }
        TbWidgetBundleConfigV1 savedConfig = new TbWidgetBundleConfigV1(savedBundle, savedTypeList);
        return new TbWidgetBundleConfigCollectionV1(List.of(savedConfig));
    }
}

