/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.tb.dashboard;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.dao.customize.CustomViewSettingsDao;
import org.thingsboard.trendz.domain.customize.CustomViewSettings;
import org.thingsboard.trendz.domain.definition.ApplicationProperty;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.DataRow;
import org.thingsboard.trendz.domain.runtime.ViewReport;
import org.thingsboard.trendz.domain.tb.dashboard.dto.Dashboard;
import org.thingsboard.trendz.domain.tb.dashboard.dto.DashboardConfiguration;
import org.thingsboard.trendz.domain.tb.dashboard.dto.DashboardEntityAlias;
import org.thingsboard.trendz.domain.tb.dashboard.dto.DashboardEntityAliasFilter;
import org.thingsboard.trendz.domain.tb.dashboard.dto.DashboardState;
import org.thingsboard.trendz.domain.tb.dashboard.dto.DashboardStateLayout;
import org.thingsboard.trendz.domain.tb.dashboard.dto.DashboardWidget;
import org.thingsboard.trendz.domain.tb.dashboard.dto.DashboardWidgetLayout;
import org.thingsboard.trendz.domain.tb.dashboard.entity.DashboardData;
import org.thingsboard.trendz.domain.tb.dashboard.entity.DashboardLite;
import org.thingsboard.trendz.domain.tb.dashboard.entity.TrendzViewParams;
import org.thingsboard.trendz.domain.tb.dashboard.request.DashboardExportViewsRequest;
import org.thingsboard.trendz.domain.tb.dashboard.response.DashboardExportResponse;
import org.thingsboard.trendz.exception.tb.dashboard.DashboardException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.ViewConfigService;
import org.thingsboard.trendz.service.customize.CustomizationService;
import org.thingsboard.trendz.service.definition.ApplicationPropertyService;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.filter.FilterRequestService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.provider.version.TbVersion;
import org.thingsboard.trendz.service.provider.version.TbVersionChecker;
import org.thingsboard.trendz.service.provider.version.TbVersionNumber;
import org.thingsboard.trendz.service.tb.dashboard.factory.DashboardWidgetFactory;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Mono;

@Service
public class DashboardService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DashboardService.class);
    private static final int WIDGET_HEIGHT = 8;
    private static final int WIDGET_WIDTH = 24;
    private static final String TRENDZ_WIDGET_NAME = "New Trendz Widget";
    private static final String DASHBOARD_STATE_LAYOUT_MAIN = "main";
    private final TbRestDataSource restDataSource;
    private final TbVersionChecker versionChecker;
    private final BusinessEntityService businessEntityService;
    private final ViewConfigService viewConfigService;
    private final FilterRequestService filterRequestService;
    private final CustomizationService customizationService;
    private final ApplicationPropertyService applicationPropertyService;
    private final CustomViewSettingsDao customViewSettingsDao;

    @Autowired
    public DashboardService(TbRestDataSource restDataSource, TbVersionChecker versionChecker, BusinessEntityService businessEntityService, ViewConfigService viewConfigService, FilterRequestService filterRequestService, CustomizationService customizationService, ApplicationPropertyService applicationPropertyService, CustomViewSettingsDao customViewSettingsDao) {
        this.restDataSource = restDataSource;
        this.versionChecker = versionChecker;
        this.businessEntityService = businessEntityService;
        this.viewConfigService = viewConfigService;
        this.filterRequestService = filterRequestService;
        this.customizationService = customizationService;
        this.applicationPropertyService = applicationPropertyService;
        this.customViewSettingsDao = customViewSettingsDao;
    }

    public List<DashboardLite> getAllDashboardLabels(JwtSecurityUser user) {
        PageData dashboardLitePage = (PageData)DonReactive.block((Mono)this.restDataSource.loadAllDashboards(user));
        assert (dashboardLitePage != null);
        return dashboardLitePage.getData().stream().map(DashboardLite::new).sorted().collect(Collectors.toList());
    }

    public DashboardData loadSelectedDashboard(UUID dashboardId, JwtSecurityUser user) {
        Dashboard dashboard = this.loadDashboard(dashboardId, user);
        return new DashboardData(dashboard);
    }

    public DashboardExportResponse exportCurrentViewOnDashboard(boolean isNewDashboard, String name, UUID dashboardId, String dashboardState, UUID entityId, JwtSecurityUser user, String domain, String trendzUrl, UUID viewConfigId, String filterName) {
        TbVersion version = this.versionChecker.getVersion(user);
        if (version.getVersion().less(TbVersionNumber.V_3_0_0)) {
            throw new IllegalStateException("2.x versions of TB is not supported anymore.");
        }
        String bundleAlias = (String)this.applicationPropertyService.getProperty(ApplicationProperty.Key.BUNDLE_ALIAS).orElseThrow(() -> new DashboardException("Basic bundle alias is not set, please choose bundle on the setting page."));
        Dashboard dashboard = isNewDashboard ? this.createEmptyDashboard(name, user) : this.loadDashboard(dashboardId, user);
        String widgetName = this.getWidgetNameWithCompanyName(domain, user);
        if (this.isUsingFilterForWidget(entityId, filterName)) {
            BusinessEntity businessEntity = this.businessEntityService.findEntityById(user, entityId);
            String newGeneratedAliasSuffix = businessEntity.getName() + " " + String.valueOf(UUID.randomUUID());
            Pair entityAliases = this.createDashboardAliasesForEntity(dashboard, businessEntity, newGeneratedAliasSuffix);
            DashboardEntityAlias aliasForAllEntities = (DashboardEntityAlias)entityAliases.getLeft();
            DashboardEntityAlias aliasForSelectedEntity = (DashboardEntityAlias)entityAliases.getRight();
            this.createBasicTableWidget(dashboard, aliasForAllEntities.getId().toString(), dashboardState, newGeneratedAliasSuffix);
            this.addViewWithAliases(widgetName, trendzUrl, viewConfigId, dashboard, dashboardState, aliasForSelectedEntity, filterName, user, bundleAlias, version);
        } else {
            this.addViewWithoutAliases(widgetName, trendzUrl, viewConfigId, dashboard, dashboardState, bundleAlias, version);
        }
        Dashboard savedDashboard = this.saveDashboard(dashboard, user);
        String dashboardPublicUrl = this.getDashboardPublicUrl(domain, savedDashboard.getId().getId());
        return DashboardExportResponse.builder().status(DashboardExportResponse.Status.OK).dashboardRedirectUrl(dashboardPublicUrl).build();
    }

    public DashboardExportResponse exportSelectedViewsOnDashboard(DashboardExportViewsRequest request, String domain, JwtSecurityUser user) {
        TbVersion version = this.versionChecker.getVersion(user);
        if (version.getVersion().less(TbVersionNumber.V_3_0_0)) {
            throw new IllegalStateException("2.x versions of TB is not supported anymore.");
        }
        String bundleAlias = (String)this.applicationPropertyService.getProperty(ApplicationProperty.Key.BUNDLE_ALIAS).orElseThrow(() -> new DashboardException("Basic bundle alias is not set, please choose bundle on the setting page."));
        boolean isNewDashboard = request.getIsNewDashboard();
        String dashboardName = request.getDashboardName();
        UUID dashboardId = request.getDashboardId();
        Dashboard dashboard = isNewDashboard ? this.createEmptyDashboard(dashboardName, user) : this.loadDashboard(dashboardId, user);
        String widgetName = this.getWidgetNameWithCompanyName(domain, user);
        for (TrendzViewParams viewToAdd : request.getViews()) {
            this.addViewWithoutAliases(widgetName, request.getUrl(), viewToAdd.getViewConfigId(), dashboard, request.getDashboardState(), bundleAlias, version);
        }
        Dashboard savedDashboard = this.saveDashboard(dashboard, user);
        String dashboardPublicUrl = this.getDashboardPublicUrl(domain, savedDashboard.getId().getId());
        return DashboardExportResponse.builder().status(DashboardExportResponse.Status.OK).dashboardRedirectUrl(dashboardPublicUrl).build();
    }

    private Dashboard loadDashboard(UUID id, JwtSecurityUser user) {
        Dashboard dashboard = (Dashboard)DonReactive.block((Mono)this.restDataSource.loadDashboardById(id, user));
        assert (dashboard != null);
        if (dashboard.getConfiguration() == null) {
            dashboard.setConfiguration(DashboardConfiguration.getDefault((String)dashboard.getTitle()));
        }
        if (dashboard.getConfiguration().getStates().isEmpty()) {
            dashboard.getConfiguration().getStates().put("default", DashboardState.getDefault((String)dashboard.getTitle()));
        }
        return dashboard;
    }

    private Dashboard createEmptyDashboard(String name, JwtSecurityUser user) {
        Dashboard dashboard = Dashboard.builder().name(name).title(name).configuration(DashboardConfiguration.getDefault((String)name)).build();
        return this.saveDashboard(dashboard, user);
    }

    private Dashboard saveDashboard(Dashboard dashboard, JwtSecurityUser user) {
        Dashboard savedDashboard = (Dashboard)DonReactive.block((Mono)this.restDataSource.saveDashboard(dashboard, user));
        assert (savedDashboard != null);
        return savedDashboard;
    }

    private boolean isUsingFilterForWidget(UUID entityId, String filterName) {
        return Objects.nonNull(entityId) || Objects.nonNull(filterName);
    }

    private Pair<DashboardEntityAlias, DashboardEntityAlias> createDashboardAliasesForEntity(Dashboard dashboard, BusinessEntity businessEntity, String newGeneratedAliasSuffix) {
        String entityName = businessEntity.getName();
        BusinessEntityType entityType = businessEntity.getQuery().getEntityType();
        DashboardEntityAlias aliasForAllEntities = DashboardEntityAlias.createAliasAll((String)newGeneratedAliasSuffix, (String)entityName, (BusinessEntityType)entityType);
        DashboardEntityAlias aliasForSelectedEntity = DashboardEntityAlias.createAliasSelected((String)newGeneratedAliasSuffix);
        DashboardConfiguration dashboardConfiguration = dashboard.getConfiguration();
        dashboardConfiguration.getEntityAliases().put(aliasForAllEntities.getId().toString(), aliasForAllEntities);
        dashboardConfiguration.getEntityAliases().put(aliasForSelectedEntity.getId().toString(), aliasForSelectedEntity);
        return Pair.of((Object)aliasForAllEntities, (Object)aliasForSelectedEntity);
    }

    private void createBasicTableWidget(Dashboard dashboard, String entityAliasId, String stateId, String newGeneratedAliasSuffix) {
        DashboardWidget basicWidget = DashboardWidgetFactory.createBasicTableWidget((String)entityAliasId, (String)stateId, (String)newGeneratedAliasSuffix);
        DashboardConfiguration dashboardConfiguration = dashboard.getConfiguration();
        Map widgets = dashboardConfiguration.getWidgets();
        widgets.put(basicWidget.getId(), basicWidget);
        DashboardState dashboardState = (DashboardState)dashboardConfiguration.getStates().get(stateId);
        DashboardStateLayout dashboardStateLayout = (DashboardStateLayout)dashboardState.getLayouts().get(DASHBOARD_STATE_LAYOUT_MAIN);
        Map stateWidgets = dashboardStateLayout.getWidgets();
        int lowestPosition = this.getLowestPositionForNewWidget(dashboardStateLayout);
        DashboardWidgetLayout stateBasicWidgetLayout = DashboardWidgetLayout.builder().sizeX(Double.valueOf(8.0)).sizeY(Double.valueOf(8.0)).row(Integer.valueOf(lowestPosition)).col(Integer.valueOf(0)).build();
        stateWidgets.put(basicWidget.getId(), stateBasicWidgetLayout);
    }

    private void addViewWithAliases(String widgetName, String trendzUrl, UUID viewConfigId, Dashboard dashboard, String stateName, DashboardEntityAlias dashboardAlias, String filterName, JwtSecurityUser securityUser, String bundleAlias, TbVersion version) {
        UUID widgetId = TimeStampUUIDGenerator.generateId();
        String widgetAlias = version.getVersion().greaterOrEqual(TbVersionNumber.V_4_3_0) ? "advanced_analytics_view" : "trendz_view_latest";
        DashboardWidget dashboardWidgetLatest = DashboardWidgetFactory.createBasicTrendzWidget((String)trendzUrl, (UUID)widgetId, (UUID)viewConfigId, (String)widgetAlias, (String)bundleAlias, (String)widgetName, (DashboardEntityAlias)dashboardAlias, (String)filterName, (TbVersion)version);
        DashboardConfiguration dashboardConfiguration = dashboard.getConfiguration();
        Map widgets = dashboardConfiguration.getWidgets();
        widgets.put(widgetId.toString(), dashboardWidgetLatest);
        DashboardState state = (DashboardState)dashboardConfiguration.getStates().get(stateName);
        DashboardStateLayout dashboardStateLayout = (DashboardStateLayout)state.getLayouts().get(DASHBOARD_STATE_LAYOUT_MAIN);
        Map stateWidgets = dashboardStateLayout.getWidgets();
        int lowestPosition = this.getLowestPositionForNewWidget(dashboardStateLayout);
        DashboardWidgetLayout stateWidgetLatestNew = DashboardWidgetLayout.builder().sizeX(Double.valueOf(16.0)).sizeY(Double.valueOf(8.0)).row(Integer.valueOf(lowestPosition - 8)).col(Integer.valueOf(8)).build();
        stateWidgets.put(widgetId.toString(), stateWidgetLatestNew);
        Map aliasMap = dashboardConfiguration.getEntityAliases();
        this.setEntityAliasDefaultState(securityUser, viewConfigId, filterName, aliasMap, dashboardAlias);
    }

    private void addViewWithoutAliases(String widgetName, String trendzUrl, UUID viewConfigId, Dashboard dashboard, String stateName, String bundleAlias, TbVersion version) {
        UUID widgetId = TimeStampUUIDGenerator.generateId();
        String widgetAlias = version.getVersion().greaterOrEqual(TbVersionNumber.V_4_3_0) ? "advanced_analytics_view" : "trendz_view_static";
        DashboardWidget widget = DashboardWidgetFactory.createBasicTrendzWidget((String)trendzUrl, (UUID)widgetId, (UUID)viewConfigId, (String)widgetAlias, (String)bundleAlias, (String)widgetName, null, null, (TbVersion)version);
        DashboardConfiguration dashboardConfiguration = dashboard.getConfiguration();
        Map widgets = dashboardConfiguration.getWidgets();
        widgets.put(widgetId.toString(), widget);
        DashboardState state = (DashboardState)dashboardConfiguration.getStates().get(stateName);
        DashboardStateLayout dashboardStateLayout = (DashboardStateLayout)state.getLayouts().get(DASHBOARD_STATE_LAYOUT_MAIN);
        Map stateWidgets = dashboardStateLayout.getWidgets();
        int lowestPosition = this.getLowestPositionForNewWidget(dashboardStateLayout);
        DashboardWidgetLayout stateWidgetStaticNew = DashboardWidgetLayout.builder().sizeX(Double.valueOf(24.0)).sizeY(Double.valueOf(8.0)).row(Integer.valueOf(lowestPosition)).col(Integer.valueOf(0)).build();
        stateWidgets.put(widgetId.toString(), stateWidgetStaticNew);
    }

    private String getWidgetNameWithCompanyName(String domain, JwtSecurityUser securityUser) {
        CustomViewSettings customViewSettings = this.customizationService.getCustomViewSettings(domain, securityUser);
        String domainUrl = customViewSettings.getUrl();
        String companyName = this.customizationService.getCompanyName(domainUrl);
        return TRENDZ_WIDGET_NAME.replaceAll("Trendz", companyName);
    }

    private void setEntityAliasDefaultState(JwtSecurityUser user, UUID viewConfigId, String filterName, Map<String, DashboardEntityAlias> aliasMap, DashboardEntityAlias dashboardAlias) {
        ViewConfig viewConfig = (ViewConfig)this.viewConfigService.findConfigById(user, viewConfigId).orElseThrow(() -> new DashboardException("The view config is not found"));
        UUID viewFieldId = viewConfig.getRuntimeFilters().stream().filter(f -> filterName.equals(f.getName())).map(RuntimeFilterField::getViewFieldId).findAny().orElseThrow(() -> new DashboardException("The the filter is not found"));
        ViewField viewField = viewConfig.getAllFields().stream().filter(fv -> viewFieldId.equals(fv.getId())).findAny().orElseThrow(() -> new DashboardException("The view field of the filter is not found"));
        BusinessEntity businessEntity = this.businessEntityService.findEntityById(user, viewField.getBusinessEntityId());
        String type = businessEntity.getQuery().getEntityType().name();
        viewConfig.setPreviewRequest(true);
        viewConfig.setPreviewItemCount(1);
        viewConfig.setSelectedFilterViewFieldId(viewFieldId);
        viewConfig.setRowClickEntityId(businessEntity.getId());
        ViewReport viewReport = (ViewReport)DonReactive.block((Mono)this.filterRequestService.processFilterRequest(viewConfig, user));
        assert (viewReport != null);
        if (!viewReport.getRows().isEmpty()) {
            DataRow row = (DataRow)viewReport.getRows().iterator().next();
            Optional<EntityId> optional = Optional.ofNullable(row.getEntityIds()).map(eIds -> ((DataRow.EntityIdAndName)eIds.get(0)).entityId());
            if (optional.isPresent()) {
                EntityId entityId = optional.get();
                DashboardEntityAlias dashboardEntityAlias = aliasMap.get(dashboardAlias.getId().toString());
                dashboardEntityAlias.getFilter().setDefaultStateEntity(new DashboardEntityAliasFilter.DefaultStateEntity(entityId.toString(), type, Collections.emptyMap()));
            }
        } else {
            log.warn("The view report (view config id = {}) is empty", (Object)viewConfig.getId());
        }
    }

    private int getLowestPositionForNewWidget(DashboardStateLayout mainLayout) {
        return mainLayout.getWidgets().values().stream().mapToInt(widget -> (int)((double)widget.getRow().intValue() + widget.getSizeY())).max().orElse(0);
    }

    private String getDashboardPublicUrl(String domain, UUID dashboardId) {
        return this.customViewSettingsDao.findCustomSettings(domain).map(CustomViewSettings::getThingsboardRedirectUrl).map(tbPublicUrl -> {
            if ("None".equals(tbPublicUrl)) {
                return "None";
            }
            return "%s/dashboards/all/%s".formatted(tbPublicUrl, dashboardId);
        }).orElseThrow(() -> new DashboardException("Public TB URL is not present in the white labeling settings!"));
    }
}

