/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.tb.configuration;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.ApplicationProperty;
import org.thingsboard.trendz.domain.tb.configuration.TbConfiguration;
import org.thingsboard.trendz.service.definition.ApplicationPropertyService;
import org.thingsboard.trendz.service.provider.cache.CacheConfigurationName;
import org.thingsboard.trendz.service.provider.cache.CacheService;
import org.thingsboard.trendz.tools.json.JsonUtils;

@Service
public class TbConfigurationStorage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbConfigurationStorage.class);
    private final String defaultTbApiUrl;
    private final ApplicationPropertyService applicationPropertyService;
    private final CacheService cacheService;
    private volatile TbConfiguration cachedTbConfiguration;

    @Autowired
    public TbConfigurationStorage(@Value(value="${tb.api.url}") String defaultTbApiUrl, ApplicationPropertyService applicationPropertyService, CacheService cacheService) {
        this.defaultTbApiUrl = defaultTbApiUrl;
        this.applicationPropertyService = applicationPropertyService;
        this.cacheService = cacheService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TbConfiguration getTbConfiguration() {
        if (!this.flagIsPresent()) {
            this.cachedTbConfiguration = null;
        }
        if (this.cachedTbConfiguration == null) {
            TbConfigurationStorage tbConfigurationStorage = this;
            synchronized (tbConfigurationStorage) {
                if (this.cachedTbConfiguration == null) {
                    this.cachedTbConfiguration = this.applicationPropertyService.getProperty(ApplicationProperty.Key.TB_CONFIGURATION).map(jsonString -> (TbConfiguration)JsonUtils.fromJson((String)jsonString, TbConfiguration.class)).orElse(TbConfiguration.getDefault((String)this.defaultTbApiUrl));
                    this.setFlag();
                }
            }
        }
        return this.cachedTbConfiguration;
    }

    public synchronized void save(TbConfiguration newConfig) {
        this.applicationPropertyService.setProperty(ApplicationProperty.Key.TB_CONFIGURATION, JsonUtils.toJson((Object)newConfig));
        this.cachedTbConfiguration = newConfig;
        this.clearFlags();
    }

    private boolean flagIsPresent() {
        Cache cache = this.cacheService.getCache(CacheConfigurationName.tbConfigurationFlagCacheName);
        String value = (String)cache.get((Object)this.getInstanceName(), String.class);
        return value != null;
    }

    private void setFlag() {
        Cache cache = this.cacheService.getCache(CacheConfigurationName.tbConfigurationFlagCacheName);
        cache.put((Object)this.getInstanceName(), (Object)ApplicationProperty.Key.TB_CONFIGURATION.getStrValue());
    }

    private void clearFlags() {
        Cache cache = this.cacheService.getCache(CacheConfigurationName.tbConfigurationFlagCacheName);
        cache.clear();
    }

    private String getInstanceName() {
        String hostname = System.getenv("TB_SERVICE_ID");
        return hostname == null ? "no_name" : hostname;
    }
}

