/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.tb.configuration;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import jakarta.transaction.Transactional;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.reactive.function.client.WebClientRequestException;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.thingsboard.trendz.domain.definition.ApplicationProperty;
import org.thingsboard.trendz.domain.tb.configuration.ServiceAvailabilityStatus;
import org.thingsboard.trendz.domain.tb.configuration.SyncCheckRequest;
import org.thingsboard.trendz.domain.tb.configuration.SyncInitRequest;
import org.thingsboard.trendz.domain.tb.configuration.SyncResponse;
import org.thingsboard.trendz.domain.tb.configuration.SyncStatus;
import org.thingsboard.trendz.domain.tb.configuration.TbConfiguration;
import org.thingsboard.trendz.domain.tb.configuration.TrendzConfigurations;
import org.thingsboard.trendz.domain.version.TrendzVersion;
import org.thingsboard.trendz.exception.tb.configuration.TbConfigurationException;
import org.thingsboard.trendz.service.customize.CustomizationService;
import org.thingsboard.trendz.service.definition.ApplicationPropertyService;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.startup.SystemInitializationService;
import org.thingsboard.trendz.service.tb.configuration.TbConfigurationStorage;
import org.thingsboard.trendz.service.version.TrendzVersionService;
import reactor.core.publisher.Mono;

@Service
@Transactional
public class TbConfigurationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbConfigurationService.class);
    private final ListeningExecutorService listeningExecutorService;
    private final TrendzVersionService trendzVersionService;
    private final TbRestDataSource tbRestDataSource;
    private final TbConfigurationStorage tbConfigurationStorage;
    private final CustomizationService customizationService;
    private final SystemInitializationService systemInitializationService;
    private final ApplicationPropertyService applicationPropertyService;
    private final boolean enableSyncInit;
    private final ExecutorService tbPostSyncExecutor;

    @Autowired
    public TbConfigurationService(ExecutorManagementService executorManagementService, TrendzVersionService trendzVersionService, TbRestDataSource tbRestDataSource, TbConfigurationStorage tbConfigurationStorage, CustomizationService customizationService, SystemInitializationService systemInitializationService, ApplicationPropertyService applicationPropertyService, @Value(value="${tb.api.sync.init.enable}") boolean enableSyncInit) {
        this.listeningExecutorService = MoreExecutors.listeningDecorator((ExecutorService)executorManagementService.getExecutorByName(ExecutorName.TB_SYNCHRONIZATION));
        this.tbPostSyncExecutor = executorManagementService.getExecutorByName(ExecutorName.TB_POST_SYNCHRONIZATION);
        this.tbConfigurationStorage = tbConfigurationStorage;
        this.trendzVersionService = trendzVersionService;
        this.tbRestDataSource = tbRestDataSource;
        this.customizationService = customizationService;
        this.systemInitializationService = systemInitializationService;
        this.applicationPropertyService = applicationPropertyService;
        this.enableSyncInit = enableSyncInit;
    }

    public DeferredResult<ResponseEntity<SyncResponse>> doSynchronization(SyncInitRequest request, String domain) {
        ListenableFuture future = this.listeningExecutorService.submit(() -> (SyncResponse)this.processSynchronization(request, domain).block());
        DeferredResult result = new DeferredResult();
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)MoreExecutors.directExecutor());
        return result;
    }

    public Mono<SyncResponse> doHealthCheck(SyncCheckRequest request) {
        return this.processHealthCheck(request).map(arg_0 -> this.mapStatusToResponse(arg_0));
    }

    private Mono<SyncResponse> processSynchronization(SyncInitRequest request, String internalTrendzUrl) {
        return Mono.just((Object)request).flatMap(r -> {
            if (!this.enableSyncInit) {
                return Mono.just((Object)SyncStatus.SYNC_DISABLED);
            }
            TbConfiguration oldConfig = this.tbConfigurationStorage.getTbConfiguration();
            if (oldConfig.isEnabled()) {
                String providedToken;
                String savedToken = oldConfig.getAccessToken();
                String string = providedToken = request.getPrevTbAccessToken() == null ? request.getCurrentTbAccessToken() : request.getPrevTbAccessToken();
                if (!Objects.equals(savedToken, providedToken)) {
                    return Mono.just((Object)SyncStatus.TB_AUTH_INVALID);
                }
            }
            String tbUrl = request.getInternalTbUrl();
            String token = request.getCurrentTbAccessToken();
            return this.loadTrendzConfiguration(tbUrl, token).map(loadedConfig -> {
                TbConfiguration newConfig = new TbConfiguration(true, request.getInternalTbUrl(), request.getCurrentTbAccessToken());
                this.tbConfigurationStorage.save(newConfig);
                this.customizationService.updateTbBaseUrl(request.getExternalTbUrl());
                this.applicationPropertyService.setProperty(ApplicationProperty.Key.INTERNAL_TRENDZ_URL, internalTrendzUrl);
                return SyncStatus.SYNC_COMPLETED;
            }).onErrorResume(arg_0 -> this.processThrowable(arg_0));
        }).doOnNext(syncStatus -> {
            if (syncStatus == SyncStatus.SYNC_COMPLETED) {
                this.tbPostSyncExecutor.submit(() -> ((SystemInitializationService)this.systemInitializationService).uploadResources());
            }
        }).map(arg_0 -> this.mapStatusToResponse(arg_0));
    }

    private Mono<SyncStatus> processHealthCheck(SyncCheckRequest request) {
        TbConfiguration tbConfiguration = this.tbConfigurationStorage.getTbConfiguration();
        if (!tbConfiguration.isEnabled()) {
            return Mono.just((Object)SyncStatus.SYNC_NOT_INITIALIZED);
        }
        if (!Objects.equals(tbConfiguration.getAccessToken(), request.getApiKey())) {
            return Mono.just((Object)SyncStatus.TB_AUTH_INVALID);
        }
        return this.loadTrendzConfiguration(tbConfiguration.getUrl(), tbConfiguration.getAccessToken()).map(loadedConfig -> SyncStatus.SYNC_COMPLETED).onErrorResume(arg_0 -> this.processThrowable(arg_0));
    }

    private SyncResponse mapStatusToResponse(SyncStatus syncStatus) {
        TrendzVersion trendzVersion = this.trendzVersionService.getTrendzVersion();
        String message = syncStatus.getMessage();
        ServiceAvailabilityStatus status = syncStatus == SyncStatus.SYNC_COMPLETED ? ServiceAvailabilityStatus.SYNCED : ServiceAvailabilityStatus.AVAILABLE;
        return SyncResponse.builder().version(trendzVersion.getVersion()).type(syncStatus).message(message).status(status).build();
    }

    private Mono<TrendzConfigurations> loadTrendzConfiguration(String tbUrl, String token) {
        return this.tbRestDataSource.loadTrendzConfigurations(tbUrl, token).doOnNext(loadedConfig -> {
            if (!Objects.equals(tbUrl, loadedConfig.getTbUrl())) {
                throw new TbConfigurationException(SyncStatus.TB_URL_MISMATCH);
            }
        }).onErrorMap(throwable -> {
            if (throwable instanceof TbConfigurationException) {
                TbConfigurationException tbConfigurationException = (TbConfigurationException)throwable;
                return tbConfigurationException;
            }
            if (throwable.getCause() instanceof WebClientRequestException) {
                return new TbConfigurationException(SyncStatus.TB_URL_UNREACHABLE);
            }
            if (throwable.getCause() instanceof WebClientResponseException.Unauthorized) {
                return new TbConfigurationException(SyncStatus.TB_AUTH_INVALID);
            }
            return new TbConfigurationException(SyncStatus.TB_CONNECTION_ERROR);
        });
    }

    private Mono<SyncStatus> processThrowable(Throwable throwable) {
        log.error("Error during synchronization", throwable);
        if (throwable instanceof TbConfigurationException) {
            TbConfigurationException tbConfigurationException = (TbConfigurationException)throwable;
            return Mono.just((Object)tbConfigurationException.getSyncStatus());
        }
        return Mono.just((Object)SyncStatus.SYNC_INTERNAL_ERROR);
    }
}

