/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.model;

import java.util.UUID;
import lombok.Generated;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskConfig;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskRetryPolicy;
import org.thingsboard.trendz.service.task.model.TaskSchedule;
import org.thingsboard.trendz.service.task.model.TaskStoreExecutionConfig;
import org.thingsboard.trendz.service.task.model.TaskTimeoutConfig;
import org.thingsboard.trendz.service.task.model.TaskTtlConfig;

public class TaskConfig {
    private UUID id;
    private String name;
    private Boolean enabled;
    private TaskSchedule schedule;
    private TaskTtlConfig ttlConfig;
    private TaskStoreExecutionConfig storeExecutionConfig;
    private TaskTimeoutConfig timeoutConfig;
    private TaskRetryPolicy retryPolicy;
    private TaskReference reference;
    private TaskJob job;

    public TaskConfig(TaskJob job, TaskReference reference) {
        this.job = job;
        this.reference = reference;
    }

    public TaskConfig(TaskConfig that) {
        this.id = that.id;
        this.name = that.name;
        this.enabled = that.enabled;
        this.schedule = new TaskSchedule(that.schedule);
        this.ttlConfig = new TaskTtlConfig(that.ttlConfig);
        this.storeExecutionConfig = new TaskStoreExecutionConfig(that.storeExecutionConfig);
        this.timeoutConfig = new TaskTimeoutConfig(that.timeoutConfig);
        this.retryPolicy = new TaskRetryPolicy(that.retryPolicy);
        this.reference = new TaskReference(that.reference);
        this.job = that.job.clone();
    }

    public TaskConfig(Task task) {
        this.id = task.getId();
        this.name = task.getName();
        this.enabled = task.isEnabled();
        this.schedule = new TaskSchedule(task.getSchedule());
        this.ttlConfig = new TaskTtlConfig(task.getTtlConfig());
        this.storeExecutionConfig = new TaskStoreExecutionConfig(task.getStoreExecutionConfig());
        this.timeoutConfig = new TaskTimeoutConfig(task.getTimeoutConfig());
        this.retryPolicy = new TaskRetryPolicy(task.getRetryPolicy());
        this.reference = new TaskReference(task.getReference());
        this.job = task.getJob().clone();
    }

    @Generated
    public static TaskConfigBuilder builder() {
        return new TaskConfigBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Generated
    public TaskSchedule getSchedule() {
        return this.schedule;
    }

    @Generated
    public TaskTtlConfig getTtlConfig() {
        return this.ttlConfig;
    }

    @Generated
    public TaskStoreExecutionConfig getStoreExecutionConfig() {
        return this.storeExecutionConfig;
    }

    @Generated
    public TaskTimeoutConfig getTimeoutConfig() {
        return this.timeoutConfig;
    }

    @Generated
    public TaskRetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    @Generated
    public TaskReference getReference() {
        return this.reference;
    }

    @Generated
    public TaskJob getJob() {
        return this.job;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setSchedule(TaskSchedule schedule) {
        this.schedule = schedule;
    }

    @Generated
    public void setTtlConfig(TaskTtlConfig ttlConfig) {
        this.ttlConfig = ttlConfig;
    }

    @Generated
    public void setStoreExecutionConfig(TaskStoreExecutionConfig storeExecutionConfig) {
        this.storeExecutionConfig = storeExecutionConfig;
    }

    @Generated
    public void setTimeoutConfig(TaskTimeoutConfig timeoutConfig) {
        this.timeoutConfig = timeoutConfig;
    }

    @Generated
    public void setRetryPolicy(TaskRetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    @Generated
    public void setReference(TaskReference reference) {
        this.reference = reference;
    }

    @Generated
    public void setJob(TaskJob job) {
        this.job = job;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskConfig)) {
            return false;
        }
        TaskConfig other = (TaskConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        TaskSchedule this$schedule = this.getSchedule();
        TaskSchedule other$schedule = other.getSchedule();
        if (this$schedule == null ? other$schedule != null : !this$schedule.equals(other$schedule)) {
            return false;
        }
        TaskTtlConfig this$ttlConfig = this.getTtlConfig();
        TaskTtlConfig other$ttlConfig = other.getTtlConfig();
        if (this$ttlConfig == null ? other$ttlConfig != null : !this$ttlConfig.equals(other$ttlConfig)) {
            return false;
        }
        TaskStoreExecutionConfig this$storeExecutionConfig = this.getStoreExecutionConfig();
        TaskStoreExecutionConfig other$storeExecutionConfig = other.getStoreExecutionConfig();
        if (this$storeExecutionConfig == null ? other$storeExecutionConfig != null : !this$storeExecutionConfig.equals(other$storeExecutionConfig)) {
            return false;
        }
        TaskTimeoutConfig this$timeoutConfig = this.getTimeoutConfig();
        TaskTimeoutConfig other$timeoutConfig = other.getTimeoutConfig();
        if (this$timeoutConfig == null ? other$timeoutConfig != null : !this$timeoutConfig.equals(other$timeoutConfig)) {
            return false;
        }
        TaskRetryPolicy this$retryPolicy = this.getRetryPolicy();
        TaskRetryPolicy other$retryPolicy = other.getRetryPolicy();
        if (this$retryPolicy == null ? other$retryPolicy != null : !this$retryPolicy.equals(other$retryPolicy)) {
            return false;
        }
        TaskReference this$reference = this.getReference();
        TaskReference other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
            return false;
        }
        TaskJob this$job = this.getJob();
        TaskJob other$job = other.getJob();
        return !(this$job == null ? other$job != null : !this$job.equals(other$job));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TaskConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        TaskSchedule $schedule = this.getSchedule();
        result = result * 59 + ($schedule == null ? 43 : $schedule.hashCode());
        TaskTtlConfig $ttlConfig = this.getTtlConfig();
        result = result * 59 + ($ttlConfig == null ? 43 : $ttlConfig.hashCode());
        TaskStoreExecutionConfig $storeExecutionConfig = this.getStoreExecutionConfig();
        result = result * 59 + ($storeExecutionConfig == null ? 43 : $storeExecutionConfig.hashCode());
        TaskTimeoutConfig $timeoutConfig = this.getTimeoutConfig();
        result = result * 59 + ($timeoutConfig == null ? 43 : $timeoutConfig.hashCode());
        TaskRetryPolicy $retryPolicy = this.getRetryPolicy();
        result = result * 59 + ($retryPolicy == null ? 43 : $retryPolicy.hashCode());
        TaskReference $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
        TaskJob $job = this.getJob();
        result = result * 59 + ($job == null ? 43 : $job.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TaskConfig(id=" + String.valueOf(this.getId()) + ", name=" + this.getName() + ", enabled=" + this.getEnabled() + ", schedule=" + String.valueOf(this.getSchedule()) + ", ttlConfig=" + String.valueOf(this.getTtlConfig()) + ", storeExecutionConfig=" + String.valueOf(this.getStoreExecutionConfig()) + ", timeoutConfig=" + String.valueOf(this.getTimeoutConfig()) + ", retryPolicy=" + String.valueOf(this.getRetryPolicy()) + ", reference=" + String.valueOf(this.getReference()) + ", job=" + String.valueOf(this.getJob()) + ")";
    }

    @Generated
    public TaskConfig(UUID id, String name, Boolean enabled, TaskSchedule schedule, TaskTtlConfig ttlConfig, TaskStoreExecutionConfig storeExecutionConfig, TaskTimeoutConfig timeoutConfig, TaskRetryPolicy retryPolicy, TaskReference reference, TaskJob job) {
        this.id = id;
        this.name = name;
        this.enabled = enabled;
        this.schedule = schedule;
        this.ttlConfig = ttlConfig;
        this.storeExecutionConfig = storeExecutionConfig;
        this.timeoutConfig = timeoutConfig;
        this.retryPolicy = retryPolicy;
        this.reference = reference;
        this.job = job;
    }
}

