/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.thingsboard.trendz.domain.definition.migration.TrendzEntity;
import org.thingsboard.trendz.exception.task.TrendzTaskException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskExecution;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskRetryPolicy;
import org.thingsboard.trendz.service.task.model.TaskSchedule;
import org.thingsboard.trendz.service.task.model.TaskStoreExecutionConfig;
import org.thingsboard.trendz.service.task.model.TaskTimeoutConfig;
import org.thingsboard.trendz.service.task.model.TaskTtlConfig;

public class Task
implements TrendzEntity {
    private UUID id;
    private JwtSecurityUser user;
    private long createdTs;
    private long updatedTs;
    private String name;
    private boolean enabled;
    private TaskSchedule schedule;
    private TaskTtlConfig ttlConfig;
    private TaskStoreExecutionConfig storeExecutionConfig;
    private TaskTimeoutConfig timeoutConfig;
    private TaskRetryPolicy retryPolicy;
    private TaskJobType jobType;
    private TaskJob job;
    private TaskReference reference;
    private List<TaskExecution> executions;

    public Task() {
        this.schedule = TaskSchedule.getDefault();
        this.ttlConfig = TaskTtlConfig.getDefault();
        this.storeExecutionConfig = TaskStoreExecutionConfig.getDefault();
        this.timeoutConfig = TaskTimeoutConfig.getDefault();
        this.retryPolicy = TaskRetryPolicy.getDefault();
        this.reference = TaskReference.getDefault();
        this.executions = new ArrayList();
    }

    public Task(Task that) {
        this.id = that.id;
        this.user = new JwtSecurityUser(that.user);
        this.createdTs = that.createdTs;
        this.updatedTs = that.updatedTs;
        this.name = that.name;
        this.enabled = that.enabled;
        this.schedule = new TaskSchedule(that.schedule);
        this.ttlConfig = new TaskTtlConfig(that.ttlConfig);
        this.storeExecutionConfig = new TaskStoreExecutionConfig(that.storeExecutionConfig);
        this.timeoutConfig = new TaskTimeoutConfig(that.timeoutConfig);
        this.retryPolicy = new TaskRetryPolicy(that.retryPolicy);
        this.job = that.job.clone();
        this.jobType = that.jobType;
        this.reference = new TaskReference(that.reference);
        this.executions = that.getExecutions().stream().map(TaskExecution::new).collect(Collectors.toList());
    }

    public String toString() {
        return String.format("Task(%s)", this.name);
    }

    public List<TaskExecution> getExecutions() {
        if (this.executions == null) {
            throw new TrendzTaskException("The execution list is null, it's internal task usage");
        }
        return this.executions;
    }

    @JsonIgnore
    public UUID getTenantId() {
        return this.user.getTenantId();
    }

    @Generated
    public static TaskBuilder builder() {
        return new TaskBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public JwtSecurityUser getUser() {
        return this.user;
    }

    @Generated
    public long getCreatedTs() {
        return this.createdTs;
    }

    @Generated
    public long getUpdatedTs() {
        return this.updatedTs;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public TaskSchedule getSchedule() {
        return this.schedule;
    }

    @Generated
    public TaskTtlConfig getTtlConfig() {
        return this.ttlConfig;
    }

    @Generated
    public TaskStoreExecutionConfig getStoreExecutionConfig() {
        return this.storeExecutionConfig;
    }

    @Generated
    public TaskTimeoutConfig getTimeoutConfig() {
        return this.timeoutConfig;
    }

    @Generated
    public TaskRetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    @Generated
    public TaskJobType getJobType() {
        return this.jobType;
    }

    @Generated
    public TaskJob getJob() {
        return this.job;
    }

    @Generated
    public TaskReference getReference() {
        return this.reference;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setUser(JwtSecurityUser user) {
        this.user = user;
    }

    @Generated
    public void setCreatedTs(long createdTs) {
        this.createdTs = createdTs;
    }

    @Generated
    public void setUpdatedTs(long updatedTs) {
        this.updatedTs = updatedTs;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setSchedule(TaskSchedule schedule) {
        this.schedule = schedule;
    }

    @Generated
    public void setTtlConfig(TaskTtlConfig ttlConfig) {
        this.ttlConfig = ttlConfig;
    }

    @Generated
    public void setStoreExecutionConfig(TaskStoreExecutionConfig storeExecutionConfig) {
        this.storeExecutionConfig = storeExecutionConfig;
    }

    @Generated
    public void setTimeoutConfig(TaskTimeoutConfig timeoutConfig) {
        this.timeoutConfig = timeoutConfig;
    }

    @Generated
    public void setRetryPolicy(TaskRetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    @Generated
    public void setJobType(TaskJobType jobType) {
        this.jobType = jobType;
    }

    @Generated
    public void setJob(TaskJob job) {
        this.job = job;
    }

    @Generated
    public void setReference(TaskReference reference) {
        this.reference = reference;
    }

    @Generated
    public void setExecutions(List<TaskExecution> executions) {
        this.executions = executions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Task)) {
            return false;
        }
        Task other = (Task)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getCreatedTs() != other.getCreatedTs()) {
            return false;
        }
        if (this.getUpdatedTs() != other.getUpdatedTs()) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        JwtSecurityUser this$user = this.getUser();
        JwtSecurityUser other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        TaskSchedule this$schedule = this.getSchedule();
        TaskSchedule other$schedule = other.getSchedule();
        if (this$schedule == null ? other$schedule != null : !this$schedule.equals(other$schedule)) {
            return false;
        }
        TaskTtlConfig this$ttlConfig = this.getTtlConfig();
        TaskTtlConfig other$ttlConfig = other.getTtlConfig();
        if (this$ttlConfig == null ? other$ttlConfig != null : !this$ttlConfig.equals(other$ttlConfig)) {
            return false;
        }
        TaskStoreExecutionConfig this$storeExecutionConfig = this.getStoreExecutionConfig();
        TaskStoreExecutionConfig other$storeExecutionConfig = other.getStoreExecutionConfig();
        if (this$storeExecutionConfig == null ? other$storeExecutionConfig != null : !this$storeExecutionConfig.equals(other$storeExecutionConfig)) {
            return false;
        }
        TaskTimeoutConfig this$timeoutConfig = this.getTimeoutConfig();
        TaskTimeoutConfig other$timeoutConfig = other.getTimeoutConfig();
        if (this$timeoutConfig == null ? other$timeoutConfig != null : !this$timeoutConfig.equals(other$timeoutConfig)) {
            return false;
        }
        TaskRetryPolicy this$retryPolicy = this.getRetryPolicy();
        TaskRetryPolicy other$retryPolicy = other.getRetryPolicy();
        if (this$retryPolicy == null ? other$retryPolicy != null : !this$retryPolicy.equals(other$retryPolicy)) {
            return false;
        }
        TaskJobType this$jobType = this.getJobType();
        TaskJobType other$jobType = other.getJobType();
        if (this$jobType == null ? other$jobType != null : !this$jobType.equals(other$jobType)) {
            return false;
        }
        TaskJob this$job = this.getJob();
        TaskJob other$job = other.getJob();
        if (this$job == null ? other$job != null : !this$job.equals(other$job)) {
            return false;
        }
        TaskReference this$reference = this.getReference();
        TaskReference other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
            return false;
        }
        List this$executions = this.getExecutions();
        List other$executions = other.getExecutions();
        return !(this$executions == null ? other$executions != null : !((Object)this$executions).equals(other$executions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Task;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $createdTs = this.getCreatedTs();
        result = result * 59 + (int)($createdTs >>> 32 ^ $createdTs);
        long $updatedTs = this.getUpdatedTs();
        result = result * 59 + (int)($updatedTs >>> 32 ^ $updatedTs);
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        JwtSecurityUser $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        TaskSchedule $schedule = this.getSchedule();
        result = result * 59 + ($schedule == null ? 43 : $schedule.hashCode());
        TaskTtlConfig $ttlConfig = this.getTtlConfig();
        result = result * 59 + ($ttlConfig == null ? 43 : $ttlConfig.hashCode());
        TaskStoreExecutionConfig $storeExecutionConfig = this.getStoreExecutionConfig();
        result = result * 59 + ($storeExecutionConfig == null ? 43 : $storeExecutionConfig.hashCode());
        TaskTimeoutConfig $timeoutConfig = this.getTimeoutConfig();
        result = result * 59 + ($timeoutConfig == null ? 43 : $timeoutConfig.hashCode());
        TaskRetryPolicy $retryPolicy = this.getRetryPolicy();
        result = result * 59 + ($retryPolicy == null ? 43 : $retryPolicy.hashCode());
        TaskJobType $jobType = this.getJobType();
        result = result * 59 + ($jobType == null ? 43 : $jobType.hashCode());
        TaskJob $job = this.getJob();
        result = result * 59 + ($job == null ? 43 : $job.hashCode());
        TaskReference $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
        List $executions = this.getExecutions();
        result = result * 59 + ($executions == null ? 43 : ((Object)$executions).hashCode());
        return result;
    }

    @Generated
    public Task(UUID id, JwtSecurityUser user, long createdTs, long updatedTs, String name, boolean enabled, TaskSchedule schedule, TaskTtlConfig ttlConfig, TaskStoreExecutionConfig storeExecutionConfig, TaskTimeoutConfig timeoutConfig, TaskRetryPolicy retryPolicy, TaskJobType jobType, TaskJob job, TaskReference reference, List<TaskExecution> executions) {
        this.id = id;
        this.user = user;
        this.createdTs = createdTs;
        this.updatedTs = updatedTs;
        this.name = name;
        this.enabled = enabled;
        this.schedule = schedule;
        this.ttlConfig = ttlConfig;
        this.storeExecutionConfig = storeExecutionConfig;
        this.timeoutConfig = timeoutConfig;
        this.retryPolicy = retryPolicy;
        this.jobType = jobType;
        this.job = job;
        this.reference = reference;
        this.executions = executions;
    }
}

