/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.job;

import java.util.concurrent.ExecutorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.assistance.view.ViewAiSummaryService;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskJobExecutor;
import org.thingsboard.trendz.service.task.job.ViewAiSummaryJob;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Service
public class ViewAiSummaryJobExecutor
implements TaskJobExecutor {
    private final Scheduler threadPoolScheduler;
    private final ViewAiSummaryService viewAiSummaryService;

    @Autowired
    public ViewAiSummaryJobExecutor(ExecutorManagementService executorManagementService, ViewAiSummaryService viewAiSummaryService) {
        this.viewAiSummaryService = viewAiSummaryService;
        ExecutorService executor = executorManagementService.getExecutorByName(ExecutorName.AI_PROCESSOR);
        this.threadPoolScheduler = Schedulers.fromExecutorService((ExecutorService)executor, (String)"view ai summary processor");
    }

    public TaskJobType getJobType() {
        return TaskJobType.AI_SUMMARY_REQUEST;
    }

    public Class<? extends ViewAiSummaryJob> getJobClass() {
        return ViewAiSummaryJob.class;
    }

    public Scheduler getExecuteScheduler() {
        return this.threadPoolScheduler;
    }

    public Mono<?> execute(JwtSecurityUser user, TaskJob taskJob, TaskExecutionProgressStepBuilder progressBuilder) {
        ViewAiSummaryJob job = (ViewAiSummaryJob)TaskJobExecutor.mapJob((TaskJob)taskJob, (Class)this.getJobClass());
        return Mono.just((Object)this.viewAiSummaryService.getAiSummary(job.getViewAiSummaryRequest(), user));
    }
}

