/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.job;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.view.config.CacheSettings;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.measurement.MeasurementReport;
import org.thingsboard.trendz.exception.view.ViewConfigNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.ViewConfigService;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskJobExecutor;
import org.thingsboard.trendz.service.task.job.CacheRefreshJob;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import org.thingsboard.trendz.service.view.ViewBuildingService;
import org.thingsboard.trendz.tools.DateTimeUtils;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Service
public class CacheRefreshJobExecutor
implements TaskJobExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacheRefreshJobExecutor.class);
    private final Scheduler threadPoolScheduler;
    private final ViewConfigService viewConfigService;
    private final ViewBuildingService viewBuildingService;

    @Autowired
    public CacheRefreshJobExecutor(ExecutorManagementService executorManagementService, ViewConfigService viewConfigService, ViewBuildingService viewBuildingService) {
        ExecutorService executor = executorManagementService.getExecutorByName(ExecutorName.BACKGROUND_TASK);
        this.threadPoolScheduler = Schedulers.fromExecutorService((ExecutorService)executor, (String)"cache refresh scheduler");
        this.viewConfigService = viewConfigService;
        this.viewBuildingService = viewBuildingService;
    }

    public TaskJobType getJobType() {
        return TaskJobType.CACHE_REFRESH;
    }

    public Class<CacheRefreshJob> getJobClass() {
        return CacheRefreshJob.class;
    }

    public Scheduler getExecuteScheduler() {
        return this.threadPoolScheduler;
    }

    public Mono<?> execute(JwtSecurityUser user, TaskJob taskJob, TaskExecutionProgressStepBuilder progressBuilder) {
        CacheRefreshJob job = (CacheRefreshJob)TaskJobExecutor.mapJob((TaskJob)taskJob, (Class)this.getJobClass());
        long now = System.currentTimeMillis();
        UUID viewConfigId = job.getViewConfigId();
        long lastRefreshTime = job.getLastRefreshTime();
        return Mono.just((Object)new Object()).flatMap(o -> {
            ViewConfig viewConfig = (ViewConfig)this.viewConfigService.findConfigById(user, viewConfigId).orElseThrow(() -> new ViewConfigNotFoundException(viewConfigId));
            DatePickerConfig datePicker = viewConfig.getDatePickerConfig();
            datePicker.setStartTs(lastRefreshTime);
            datePicker.setEndTs(now);
            job.setLastRefreshTime(now);
            CacheSettings cacheSettings = viewConfig.getCacheSettings();
            cacheSettings.setUsePersistedCacheTelemetry(true);
            if (this.isTooShortTimeRange(viewConfig)) {
                return Mono.just((Object)String.format("The range is too small - %s to %s", DateTimeUtils.fromTs((long)datePicker.getStartTs()), DateTimeUtils.fromTs((long)datePicker.getEndTs())));
            }
            return this.viewBuildingService.buildView(viewConfig, user, new MeasurementReport()).map(viewReport -> String.format("The caching job is finished successfully - %s to %s", DateTimeUtils.fromTs((long)datePicker.getStartTs()), DateTimeUtils.fromTs((long)datePicker.getEndTs())));
        });
    }

    private boolean isTooShortTimeRange(ViewConfig viewConfig) {
        ZonedDateTime truncatedEndDate;
        boolean result;
        DatePickerConfig datePicker = viewConfig.getDatePickerConfig();
        ZoneId requestZoneId = ZoneId.of(viewConfig.getTzName());
        ChronoUnit timeUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)viewConfig.getCacheSettings().getCachingDateAggregation());
        ZonedDateTime startDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(datePicker.getStartTs()), requestZoneId);
        ZonedDateTime endDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(datePicker.getEndTs()), requestZoneId);
        ZonedDateTime truncatedStartDate = DateTimeUtils.extendedTruncateTo((ZonedDateTime)startDate, (ChronoUnit)timeUnit);
        boolean bl = result = timeUnit.between(truncatedStartDate, truncatedEndDate = DateTimeUtils.extendedTruncateTo((ZonedDateTime)endDate, (ChronoUnit)timeUnit)) == 0L;
        if (result) {
            log.warn("Cache refresh job will skip the execution because of too small range ({} - {} of timeunit {})", new Object[]{startDate, endDate, timeUnit});
        }
        return result;
    }
}

