/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task.job;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.job.AnomalyModelRefreshJob;
import org.thingsboard.trendz.service.task.model.TaskJobType;

public class AnomalyModelRefreshJob
implements TaskJob {
    private UUID modelId;
    private Set<ItemLite> itemSet;
    private long lastExecutionTs;
    private Map<UUID, Long> itemIdLastSegmentMap;

    public AnomalyModelRefreshJob(AnomalyModelRefreshJob that) {
        this.modelId = that.modelId;
        this.itemSet = that.itemSet == null ? null : that.itemSet.stream().map(ItemLite::new).collect(Collectors.toSet());
        this.lastExecutionTs = that.lastExecutionTs;
        this.itemIdLastSegmentMap = that.itemIdLastSegmentMap == null ? null : new HashMap(that.itemIdLastSegmentMap);
    }

    public TaskJobType getJobType() {
        return TaskJobType.ANOMALY_MODEL_REFRESH;
    }

    public AnomalyModelRefreshJob clone() {
        return new AnomalyModelRefreshJob(this);
    }

    @Generated
    public static AnomalyModelRefreshJobBuilder builder() {
        return new AnomalyModelRefreshJobBuilder();
    }

    @Generated
    public UUID getModelId() {
        return this.modelId;
    }

    @Generated
    public Set<ItemLite> getItemSet() {
        return this.itemSet;
    }

    @Generated
    public long getLastExecutionTs() {
        return this.lastExecutionTs;
    }

    @Generated
    public Map<UUID, Long> getItemIdLastSegmentMap() {
        return this.itemIdLastSegmentMap;
    }

    @Generated
    public void setModelId(UUID modelId) {
        this.modelId = modelId;
    }

    @Generated
    public void setItemSet(Set<ItemLite> itemSet) {
        this.itemSet = itemSet;
    }

    @Generated
    public void setLastExecutionTs(long lastExecutionTs) {
        this.lastExecutionTs = lastExecutionTs;
    }

    @Generated
    public void setItemIdLastSegmentMap(Map<UUID, Long> itemIdLastSegmentMap) {
        this.itemIdLastSegmentMap = itemIdLastSegmentMap;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnomalyModelRefreshJob)) {
            return false;
        }
        AnomalyModelRefreshJob other = (AnomalyModelRefreshJob)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getLastExecutionTs() != other.getLastExecutionTs()) {
            return false;
        }
        UUID this$modelId = this.getModelId();
        UUID other$modelId = other.getModelId();
        if (this$modelId == null ? other$modelId != null : !((Object)this$modelId).equals(other$modelId)) {
            return false;
        }
        Set this$itemSet = this.getItemSet();
        Set other$itemSet = other.getItemSet();
        if (this$itemSet == null ? other$itemSet != null : !((Object)this$itemSet).equals(other$itemSet)) {
            return false;
        }
        Map this$itemIdLastSegmentMap = this.getItemIdLastSegmentMap();
        Map other$itemIdLastSegmentMap = other.getItemIdLastSegmentMap();
        return !(this$itemIdLastSegmentMap == null ? other$itemIdLastSegmentMap != null : !((Object)this$itemIdLastSegmentMap).equals(other$itemIdLastSegmentMap));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AnomalyModelRefreshJob;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $lastExecutionTs = this.getLastExecutionTs();
        result = result * 59 + (int)($lastExecutionTs >>> 32 ^ $lastExecutionTs);
        UUID $modelId = this.getModelId();
        result = result * 59 + ($modelId == null ? 43 : ((Object)$modelId).hashCode());
        Set $itemSet = this.getItemSet();
        result = result * 59 + ($itemSet == null ? 43 : ((Object)$itemSet).hashCode());
        Map $itemIdLastSegmentMap = this.getItemIdLastSegmentMap();
        result = result * 59 + ($itemIdLastSegmentMap == null ? 43 : ((Object)$itemIdLastSegmentMap).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AnomalyModelRefreshJob(modelId=" + String.valueOf(this.getModelId()) + ", itemSet=" + String.valueOf(this.getItemSet()) + ", lastExecutionTs=" + this.getLastExecutionTs() + ", itemIdLastSegmentMap=" + String.valueOf(this.getItemIdLastSegmentMap()) + ")";
    }

    @Generated
    public AnomalyModelRefreshJob() {
    }

    @Generated
    public AnomalyModelRefreshJob(UUID modelId, Set<ItemLite> itemSet, long lastExecutionTs, Map<UUID, Long> itemIdLastSegmentMap) {
        this.modelId = modelId;
        this.itemSet = itemSet;
        this.lastExecutionTs = lastExecutionTs;
        this.itemIdLastSegmentMap = itemIdLastSegmentMap;
    }
}

