/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.task;

import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.service.startup.TrendzStartupService;
import org.thingsboard.trendz.service.task.TaskExecutionProgressContent;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskJobExecutor;
import org.thingsboard.trendz.service.task.model.TaskJobType;

@Service
public class TaskJobExecutorManager
implements TrendzStartupService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskJobExecutorManager.class);
    private final CountDownLatch initLatch = new CountDownLatch(1);
    private final Map<TaskJobType, TaskJobExecutor> typeToExecutorMap = new EnumMap(TaskJobType.class);
    private final Map<TaskJobType, Class<? extends TaskJob>> typeToJobClassMap = new EnumMap(TaskJobType.class);
    private final Map<TaskJobType, Class<? extends TaskExecutionProgressContent>> typeToProgressContentClassMap = new EnumMap(TaskJobType.class);

    public void onStartup(ApplicationContext context) {
        Map nameToBeanMap = context.getBeansOfType(TaskJobExecutor.class);
        for (TaskJobExecutor executor : nameToBeanMap.values()) {
            TaskJobType type = executor.getJobType();
            if (this.typeToExecutorMap.containsKey(type) || this.typeToJobClassMap.containsKey(type) || this.typeToProgressContentClassMap.containsKey(type)) {
                throw new TrendzInternalException("Ambiguous mapping for task job executors: " + String.valueOf(type));
            }
            this.typeToExecutorMap.put(type, executor);
            this.typeToJobClassMap.put(type, executor.getJobClass());
            this.typeToProgressContentClassMap.put(type, executor.getProgressContentClass());
        }
        this.initLatch.countDown();
    }

    public int priority() {
        return 30;
    }

    public TaskJobExecutor getExecutorByType(TaskJobType type) {
        this.awaitInitialization();
        return (TaskJobExecutor)this.typeToExecutorMap.get(type);
    }

    public Class<? extends TaskJob> getJobClassByType(TaskJobType type) {
        this.awaitInitialization();
        return (Class)this.typeToJobClassMap.get(type);
    }

    public Class<? extends TaskExecutionProgressContent> getProgressContentClassByType(TaskJobType type) {
        this.awaitInitialization();
        return (Class)this.typeToProgressContentClassMap.get(type);
    }

    private void awaitInitialization() {
        try {
            this.initLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Initialization was interrupted", e);
        }
    }
}

