/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.system;

import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.thingsboard.trendz.domain.definition.ApplicationProperty;
import org.thingsboard.trendz.domain.system.Deployment;
import org.thingsboard.trendz.domain.tb.configuration.TbConfiguration;
import org.thingsboard.trendz.exception.security.JwtTokenException;
import org.thingsboard.trendz.exception.system.SigningKeySetupException;
import org.thingsboard.trendz.security.entity.AuthToken;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.entity.MfaAuthResponse;
import org.thingsboard.trendz.security.jwt.JwtSettings;
import org.thingsboard.trendz.security.jwt.JwtTokenBuilder;
import org.thingsboard.trendz.security.service.AuthenticationService;
import org.thingsboard.trendz.security.service.TokenExtractor;
import org.thingsboard.trendz.service.definition.ApplicationPropertyService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.system.SysadminCredentials;
import org.thingsboard.trendz.service.system.SysadminTokenRequest;
import org.thingsboard.trendz.service.tb.configuration.TbConfigurationStorage;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Mono;

@Service
public class SigningKeySetupService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SigningKeySetupService.class);
    private final TbRestDataSource restDataSource;
    private final TbConfigurationStorage tbConfigurationStorage;
    private final ApplicationPropertyService applicationPropertyService;
    private final AuthenticationService authenticationService;
    private final JwtTokenBuilder jwtTokenBuilder;
    private final TokenExtractor tokenExtractor;
    private final Deployment deployment;

    @Autowired
    public SigningKeySetupService(TbRestDataSource restDataSource, TbConfigurationStorage tbConfigurationStorage, ApplicationPropertyService applicationPropertyService, AuthenticationService authenticationService, JwtTokenBuilder jwtTokenBuilder, TokenExtractor tokenExtractor, Deployment deployment) {
        this.restDataSource = restDataSource;
        this.tbConfigurationStorage = tbConfigurationStorage;
        this.applicationPropertyService = applicationPropertyService;
        this.authenticationService = authenticationService;
        this.jwtTokenBuilder = jwtTokenBuilder;
        this.tokenExtractor = tokenExtractor;
        this.deployment = deployment;
    }

    public boolean checkSigningKey(JwtSecurityUser user) {
        if (this.deployment.isCloud()) {
            throw new SigningKeySetupException("Forbidden for cloud instance.");
        }
        if (this.isTbConfigurationEnabled()) {
            throw new SigningKeySetupException("Forbidden for trendz access token setup.");
        }
        if (user.isCustomerUser()) {
            throw new SigningKeySetupException("Forbidden for customers.");
        }
        String jwtToken = this.jwtTokenBuilder.buildToken(user);
        return this.authenticationService.validateToken(jwtToken, user).isValid();
    }

    public AuthToken loginAsSysadmin(JwtSecurityUser user, SysadminCredentials credentials) {
        if (this.deployment.isCloud()) {
            throw new SigningKeySetupException("Forbidden for cloud instance.");
        }
        if (this.isTbConfigurationEnabled()) {
            throw new SigningKeySetupException("Forbidden for trendz access token setup.");
        }
        if (user.isCustomerUser()) {
            throw new SigningKeySetupException("Forbidden for customers.");
        }
        AuthToken authToken = (AuthToken)DonReactive.block((Mono)this.restDataSource.login(credentials.getLogin(), credentials.getPassword()).onErrorMap(throwable -> {
            if (throwable.getCause() instanceof WebClientResponseException.Unauthorized) {
                return new SigningKeySetupException("Sysadmin credentials are not correct.");
            }
            return throwable;
        }));
        if (Objects.isNull(authToken.getRefreshToken())) {
            if (!this.ifUserSysadmin(authToken)) {
                throw new SigningKeySetupException("Sysadmin credentials are not correct.");
            }
            return new MfaAuthResponse(authToken);
        }
        return authToken;
    }

    public void setupSigningKey(JwtSecurityUser user, SysadminTokenRequest sysadminTokenRequest) {
        if (this.deployment.isCloud()) {
            throw new SigningKeySetupException("Forbidden for cloud instance.");
        }
        if (this.isTbConfigurationEnabled()) {
            throw new SigningKeySetupException("Forbidden for trendz access token setup.");
        }
        if (user.isCustomerUser()) {
            throw new SigningKeySetupException("Forbidden for customers.");
        }
        Mono signingKeyMono = Mono.just((Object)sysadminTokenRequest.getToken()).flatMap(arg_0 -> ((TbRestDataSource)this.restDataSource).fetchSigningKeyWithSysadminToken(arg_0)).onErrorMap(throwable -> {
            if (throwable.getCause() instanceof WebClientResponseException.Forbidden) {
                return new SigningKeySetupException("Sysadmin credentials are not correct.");
            }
            if (throwable instanceof JwtTokenException) {
                return new SigningKeySetupException("Can not extract sysadmin JWT token");
            }
            return throwable;
        }).map(JwtSettings::getTokenSigningKey);
        String signingKey = (String)DonReactive.block((Mono)signingKeyMono);
        this.applicationPropertyService.setProperty(ApplicationProperty.Key.SIGNING_KEY, signingKey);
        log.info("The signing key property was fetched and saved successfully.");
    }

    private boolean isTbConfigurationEnabled() {
        TbConfiguration configuration = this.tbConfigurationStorage.getTbConfiguration();
        return configuration.isEnabled();
    }

    private boolean ifUserSysadmin(AuthToken authToken) {
        JwtSecurityUser user = this.tokenExtractor.extractUser(authToken.getToken());
        return user.isSysadmin();
    }
}

