/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.summary;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.anomaly.AnomalyModelSortingField;
import org.thingsboard.trendz.domain.chat.ChatFilteringField;
import org.thingsboard.trendz.domain.chat.ChatSortingField;
import org.thingsboard.trendz.domain.chat.ChatType;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldSortingField;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfigSortingField;
import org.thingsboard.trendz.domain.metric.MetricDefinition;
import org.thingsboard.trendz.domain.metric.exploration.MetricExploration;
import org.thingsboard.trendz.domain.metric.exploration.MetricExplorationSortingField;
import org.thingsboard.trendz.domain.summary.TrendzEntityUsage;
import org.thingsboard.trendz.domain.summary.TrendzSimpleEntityUsage;
import org.thingsboard.trendz.domain.summary.TrendzSummary;
import org.thingsboard.trendz.domain.summary.TrendzUsageSummary;
import org.thingsboard.trendz.domain.summary.item.AiSummaryItem;
import org.thingsboard.trendz.domain.summary.item.AnomalyModelSummaryItem;
import org.thingsboard.trendz.domain.summary.item.CalculationFieldSummaryItem;
import org.thingsboard.trendz.domain.summary.item.MetricSummaryItem;
import org.thingsboard.trendz.domain.summary.item.PredictionModelSummaryItem;
import org.thingsboard.trendz.domain.summary.item.ViewSummaryItem;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.ViewConfigService;
import org.thingsboard.trendz.service.calculation.CalculationFieldService;
import org.thingsboard.trendz.service.chat.ChatService;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.metric.MetricDefinitionService;
import org.thingsboard.trendz.service.metric.MetricExplorationService;
import org.thingsboard.trendz.service.model.anomaly.AnomalyModelService;
import org.thingsboard.trendz.service.model.prediction.PredictionModelService;
import org.thingsboard.trendz.service.model.prediction.PredictionModelSortingField;

@Service
public class TrendzSummaryService {
    private static final int ANALYZED_ENTITY_COUNT = 10;
    private final MetricExplorationService metricExplorationService;
    private final AnomalyModelService anomalyModelService;
    private final CalculationFieldService calculationFieldService;
    private final PredictionModelService predictionModelService;
    private final ViewConfigService viewConfigService;
    private final ChatService chatService;
    private final BusinessEntityService businessEntityService;
    private final MetricDefinitionService metricDefinitionService;

    @Autowired
    public TrendzSummaryService(MetricExplorationService metricExplorationService, AnomalyModelService anomalyModelService, CalculationFieldService calculationFieldService, PredictionModelService predictionModelService, ViewConfigService viewConfigService, ChatService chatService, BusinessEntityService businessEntityService, MetricDefinitionService metricDefinitionService) {
        this.metricExplorationService = metricExplorationService;
        this.anomalyModelService = anomalyModelService;
        this.calculationFieldService = calculationFieldService;
        this.predictionModelService = predictionModelService;
        this.viewConfigService = viewConfigService;
        this.chatService = chatService;
        this.businessEntityService = businessEntityService;
        this.metricDefinitionService = metricDefinitionService;
    }

    public TrendzSummary getTrendzSummary(JwtSecurityUser user) {
        Map sourceMap = this.businessEntityService.getBusinessEntitySourceMap(user);
        List metricSummaryItems = this.getMetricSummary(user, sourceMap);
        List anomalyModelSummaryItems = this.getAnomalyModelSummary(user, sourceMap);
        List calculationFieldSummaryItems = this.getCalculationFieldSummary(user, sourceMap);
        List predictionModelSummaryItems = this.getPredictionModelSummary(user, sourceMap);
        List viewSummaryItems = this.getViewSummary(user);
        List aiSummaryItems = this.getAiSummary(user);
        return TrendzSummary.builder().metricSummaryItems(metricSummaryItems).anomalyModelSummaryItems(anomalyModelSummaryItems).calculationFieldSummaryItems(calculationFieldSummaryItems).predictionModelSummaryItems(predictionModelSummaryItems).viewSummaryItems(viewSummaryItems).aiSummaryItems(aiSummaryItems).build();
    }

    public TrendzUsageSummary getUsageSummary(JwtSecurityUser user) {
        TrendzEntityUsage anomalyUsage = this.anomalyModelService.findUsage(user);
        TrendzEntityUsage calculationUsage = this.calculationFieldService.findUsage(user);
        TrendzEntityUsage predictionUsage = this.predictionModelService.findUsage(user);
        TrendzSimpleEntityUsage viewUsage = this.viewConfigService.findUsage(user);
        TrendzSimpleEntityUsage metricUsage = this.metricDefinitionService.findUsage(user);
        TrendzSimpleEntityUsage chatUsage = this.chatService.findUsage(user);
        boolean used = anomalyUsage.isUsed() || calculationUsage.isUsed() || predictionUsage.isUsed() || viewUsage.isUsed() || metricUsage.isUsed() || chatUsage.isUsed();
        return TrendzUsageSummary.builder().used(used).anomalyUsage(anomalyUsage).calculationUsage(calculationUsage).predictionUsage(predictionUsage).viewUsage(viewUsage).metricUsage(metricUsage).chatUsage(chatUsage).build();
    }

    private List<MetricSummaryItem> getMetricSummary(JwtSecurityUser user, Map<UUID, BusinessEntity> sourceMap) {
        List<MetricExplorationSortingField> sortingFields = List.of(new MetricExplorationSortingField(MetricExplorationSortingField.Type.EXPLORATION_TS, Sort.Direction.DESC));
        List metricExplorations = this.metricExplorationService.getAllMetricExplorations(0, 20, user, Collections.emptyList(), sortingFields).getContent();
        Map metricDefinitionMap = this.getMetricDefinitionMap(user, metricExplorations);
        Map businessEntityFieldMap = sourceMap.values().stream().map(BusinessEntity::getFields).flatMap(Collection::stream).collect(Collectors.toMap(BusinessEntityField::getId, Function.identity()));
        return metricExplorations.stream().map(exploration -> {
            MetricDefinition metricDefinition = exploration.getMetricDefinitionId() == null ? null : (MetricDefinition)metricDefinitionMap.get(exploration.getMetricDefinitionId());
            BusinessEntityField field = exploration.getBusinessEntityFieldId() == null ? null : (BusinessEntityField)businessEntityFieldMap.get(exploration.getBusinessEntityFieldId());
            MetricSummaryItem.FieldData fieldData = null;
            MetricSummaryItem.MetricData metricData = null;
            if (field != null) {
                fieldData = MetricSummaryItem.FieldData.builder().fieldId(field.getId()).fieldType(field.getQuery() == null ? null : field.getQuery().getQueryType()).fieldName(field.getName()).build();
            } else if (metricDefinition != null) {
                metricData = MetricSummaryItem.MetricData.builder().metricId(metricDefinition.getId()).metricName(metricDefinition.getName()).build();
            }
            return MetricSummaryItem.builder().entityId(exploration.getBusinessEntityId()).entityName(this.getEntityName(exploration.getBusinessEntityId(), sourceMap)).itemId(exploration.getItemId()).itemName(exploration.getItemName()).updatedTs(exploration.getExplorationTs()).metricData(metricData).fieldData(fieldData).build();
        }).filter(metricSummaryItem -> metricSummaryItem.getFieldData() != null || metricSummaryItem.getMetricData() != null).limit(10L).toList();
    }

    private List<AnomalyModelSummaryItem> getAnomalyModelSummary(JwtSecurityUser user, Map<UUID, BusinessEntity> sourceMap) {
        List<AnomalyModelSortingField> sortingFields = List.of(new AnomalyModelSortingField(AnomalyModelSortingField.Type.CREATE_TS, Sort.Direction.DESC));
        List anomalyModelLites = this.anomalyModelService.getAllLite(0, 10, user, Collections.emptyList(), sortingFields).getContent();
        return anomalyModelLites.stream().map(lite -> AnomalyModelSummaryItem.builder().enabled(lite.isEnabledRefresh()).modelName(lite.getName()).modelId(lite.getId()).entityId(lite.getBusinessEntityId()).updatedTs(lite.getUpdateTs()).entityName(this.getEntityName(lite.getBusinessEntityId(), sourceMap)).build()).toList();
    }

    private List<CalculationFieldSummaryItem> getCalculationFieldSummary(JwtSecurityUser user, Map<UUID, BusinessEntity> sourceMap) {
        List<CalculationFieldSortingField> sortingFields = List.of(new CalculationFieldSortingField(CalculationFieldSortingField.Type.UPDATE_TIME, Sort.Direction.DESC));
        List calculationFieldLites = this.calculationFieldService.getAllLite(user, 0, 10, Collections.emptyList(), sortingFields).getContent();
        return calculationFieldLites.stream().map(lite -> CalculationFieldSummaryItem.builder().calculationId(lite.getId()).enabled(lite.isEnabled()).updatedTs(lite.getUpdateTime()).calculationName(lite.getName()).entityId(lite.getBusinessEntityId()).entityName(this.getEntityName(lite.getBusinessEntityId(), sourceMap)).build()).toList();
    }

    private List<PredictionModelSummaryItem> getPredictionModelSummary(JwtSecurityUser user, Map<UUID, BusinessEntity> sourceMap) {
        List<PredictionModelSortingField> sortingFields = List.of(new PredictionModelSortingField(PredictionModelSortingField.Type.UPDATED_TS, Sort.Direction.DESC));
        List predictionModels = this.predictionModelService.getAllLite(0, 10, user, Collections.emptyList(), sortingFields).getContent();
        return predictionModels.stream().map(lite -> PredictionModelSummaryItem.builder().modelId(lite.getId()).enabled(lite.isEnabled()).updatedTs(lite.getUpdatedTs()).entityId(lite.getBusinessEntityId()).modelName(lite.getName()).entityName(this.getEntityName(lite.getBusinessEntityId(), sourceMap)).build()).toList();
    }

    private List<ViewSummaryItem> getViewSummary(JwtSecurityUser user) {
        List<ViewConfigSortingField> sortingFields = List.of(new ViewConfigSortingField(ViewConfigSortingField.Type.UPDATED_AT, Sort.Direction.DESC));
        List viewConfigLites = this.viewConfigService.getAllLite(0, 10, user, sortingFields).getContent();
        return viewConfigLites.stream().map(lite -> ViewSummaryItem.builder().viewConfigId(lite.getId()).viewName(lite.getName()).viewType(lite.getViewType()).updatedTs(lite.getUpdatedAt()).build()).toList();
    }

    private List<AiSummaryItem> getAiSummary(JwtSecurityUser user) {
        List<ChatSortingField> sortingFields = List.of(new ChatSortingField(ChatSortingField.Type.LAST_MODIFIED_TS, Sort.Direction.DESC));
        List<ChatFilteringField> filteringFields = List.of(new ChatFilteringField(ChatFilteringField.Type.TYPE, ChatType.VIEW_ASSISTANT.name()));
        List chatLites = this.chatService.getAllChatLite(0, 10, user, filteringFields, sortingFields).getContent();
        return chatLites.stream().map(lite -> AiSummaryItem.builder().chatSummary(lite.getChatSummary()).chatId(lite.getId()).lastMessage(lite.getLastMessage().getUserQuestion()).messageCount(lite.getMessageCount().longValue()).updatedTs(lite.getLastModifiedTs().longValue()).build()).toList();
    }

    private String getEntityName(UUID entityId, Map<UUID, BusinessEntity> sourceMap) {
        return Optional.of(entityId).map(sourceMap::get).map(BusinessEntity::getName).orElse(null);
    }

    private Map<UUID, MetricDefinition> getMetricDefinitionMap(JwtSecurityUser user, List<MetricExploration> metricExplorations) {
        Set metricDefinitionUUIDs = metricExplorations.stream().map(MetricExploration::getMetricDefinitionId).filter(Objects::nonNull).collect(Collectors.toSet());
        if (metricDefinitionUUIDs.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.metricDefinitionService.getAllMetricDefinitions(user).stream().collect(Collectors.toMap(MetricDefinition::getId, Function.identity()));
    }
}

