/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.startup;

import java.util.Comparator;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.availability.AvailabilityChangeEvent;
import org.springframework.boot.availability.AvailabilityState;
import org.springframework.boot.availability.ReadinessState;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.service.startup.TrendzPostReadyStartupService;
import org.thingsboard.trendz.service.startup.TrendzStartupService;

@Service
public class TrendzStartupManagerService
implements HealthIndicator,
SmartLifecycle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrendzStartupManagerService.class);
    private final ApplicationContext applicationContext;
    private final long startDelayMs;
    private final AtomicBoolean phase1Started = new AtomicBoolean(false);
    private final AtomicBoolean phase2Started = new AtomicBoolean(false);
    private volatile boolean ready = false;

    @Autowired
    public TrendzStartupManagerService(ApplicationContext applicationContext, @Value(value="${initialization.secondPhase.startDelayMs}") long startDelayMs) {
        this.applicationContext = applicationContext;
        this.startDelayMs = startDelayMs;
    }

    public void start() {
        if (!this.phase1Started.compareAndSet(false, true)) {
            return;
        }
        log.info("Trendz startup Phase 1 (blocking) started");
        AvailabilityChangeEvent.publish((ApplicationContext)this.applicationContext, (AvailabilityState)ReadinessState.REFUSING_TRAFFIC);
        try {
            this.applicationContext.getBeansOfType(TrendzStartupService.class).values().stream().sorted(Comparator.comparingInt(TrendzStartupService::priority)).forEach(service -> {
                log.info("Phase 1 startup started for {}", (Object)service.getClass().getSimpleName());
                service.onStartup(this.applicationContext);
                log.info("Phase 1 startup completed for {}", (Object)service.getClass().getSimpleName());
            });
            this.ready = true;
            AvailabilityChangeEvent.publish((ApplicationContext)this.applicationContext, (AvailabilityState)ReadinessState.ACCEPTING_TRAFFIC);
            log.info("Trendz startup Phase 1 completed successfully. Application is READY.");
        }
        catch (Exception e) {
            log.error("Trendz startup Phase 1 FAILED. Application will terminate.", (Throwable)e);
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }

    @Async
    @EventListener(value={ApplicationReadyEvent.class})
    public void onApplicationReady(ApplicationReadyEvent event) {
        if (!this.ready) {
            log.warn("ApplicationReadyEvent received before startup readiness. Skipping Phase 2.");
            return;
        }
        if (!this.phase2Started.compareAndSet(false, true)) {
            return;
        }
        log.info("Awaiting {} ms before start second phase...", (Object)this.startDelayMs);
        try {
            Thread.sleep(this.startDelayMs);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        log.info("Trendz startup Phase 2 (post-ready) started");
        this.applicationContext.getBeansOfType(TrendzPostReadyStartupService.class).values().stream().sorted(Comparator.comparingInt(TrendzPostReadyStartupService::priority)).forEach(service -> {
            try {
                log.info("Phase 2 startup started for {}", (Object)service.getClass().getSimpleName());
                service.onPostReady(this.applicationContext);
                log.info("Phase 2 startup completed for {}", (Object)service.getClass().getSimpleName());
            }
            catch (Exception e) {
                log.error("Phase 2 startup failed for {}", (Object)service.getClass().getSimpleName(), (Object)e);
            }
        });
        log.info("Trendz startup Phase 2 completed");
    }

    public Health health() {
        return this.ready ? Health.up().withDetail("startup", (Object)"READY").build() : Health.outOfService().withDetail("startup", (Object)"STARTING").build();
    }

    public boolean isRunning() {
        return this.phase1Started.get();
    }

    public void stop() {
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public boolean isAutoStartup() {
        return true;
    }
}

