/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.sql.dialect;

import com.ibm.icu.util.TimeZone;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.sql.RelationalDatabaseType;
import org.thingsboard.trendz.service.sql.dialect.SqlQueryDialectBuilder;
import org.thingsboard.trendz.service.sql.dialect.SqlQueryMssqlDialectBuilder;

@Component
public class SqlQueryMssqlDialectBuilder
implements SqlQueryDialectBuilder {
    public RelationalDatabaseType getType() {
        return RelationalDatabaseType.SQLSERVER;
    }

    public String queryTemplate() {
        return "SELECT %s\nFROM %s\nWHERE %s\nGROUP BY %s;\n";
    }

    public String quote(String s) {
        return "[" + s.replace("]", "]]") + "]";
    }

    public String getDateAggregation(String dateFieldName, String tzName, DateAggregationType fullAggregation) {
        return this.buildDateBucketExpression(dateFieldName, tzName, fullAggregation);
    }

    public String toSelectFieldPart(String aliasSourceName, FieldAggregation aggregation, String dateFieldName) {
        String fieldPartTemplate = switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$FieldAggregation[aggregation.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1, 2, 3, 4, 5 -> aggregation.name().toLowerCase() + "(%s) as %s";
            case 6, 7 -> "%s as %s";
            case 8 -> {
                String timestampFormat = "yyyyMMddHHmmssfff";
                String timestampExpr = String.format("FORMAT(DATEADD(second, %s/1000, '1970-01-01'), '%s')", this.quote(dateFieldName), timestampFormat);
                String concatExpr = String.format("CONCAT(%s, CAST(%%s AS NVARCHAR(MAX)))", timestampExpr);
                yield String.format("SUBSTRING(MAX(%s), %d, 8000) AS %%s", concatExpr, timestampFormat.length() + 1);
            }
        };
        String quotedAlias = this.makeAggregatedKeyAliasQuote(aliasSourceName, aggregation);
        return String.format(fieldPartTemplate, this.quote(aliasSourceName), quotedAlias);
    }

    public String selectAllTableNames() {
        return "SELECT t.name AS table_name\nFROM sys.tables t\nJOIN sys.schemas s ON t.schema_id = s.schema_id\nWHERE t.is_ms_shipped = 0\n  AND s.name = SCHEMA_NAME()\nORDER BY t.name;\n";
    }

    private String makeAggregatedKeyAliasQuote(String aliasSourceName, FieldAggregation type) {
        return this.quote(aliasSourceName + "_" + type.name().toLowerCase());
    }

    private String getWindowsZoneId(String tzName) {
        String windowsId = TimeZone.getWindowsID((String)tzName);
        if (windowsId == null) {
            throw new IllegalArgumentException("Could not map IANA time zone '" + tzName + "' to a valid Windows time zone for MSSQL.");
        }
        return windowsId;
    }

    private String buildDateBucketExpression(String dateFieldName, String tzName, DateAggregationType fullAggregation) {
        String windowsZoneName = this.getWindowsZoneId(tzName);
        String unit = switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$DateAggregationType[fullAggregation.ordinal()]) {
            case 1 -> "minute";
            case 2 -> "hour";
            case 3 -> "day";
            case 4 -> "week";
            case 5 -> "month";
            case 6 -> "quarter";
            case 7 -> "year";
            default -> throw new IllegalArgumentException("Unsupported DateAggregationType: " + String.valueOf(fullAggregation));
        };
        String dateExpression = "DATEADD(second, %s/1000, '1970-01-01') AT TIME ZONE 'UTC' AT TIME ZONE '%s'".formatted(dateFieldName, windowsZoneName);
        return "DATE_BUCKET(%s, 1, %s)".formatted(unit, dateExpression);
    }
}

