/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.sql;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.entity.relation.Relation;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.domain.sql.SqlDatasource;
import org.thingsboard.trendz.service.sql.SqlDatasourceService;
import org.thingsboard.trendz.service.sql.SqlEntry;
import org.thingsboard.trendz.service.sql.SqlQueryBuilder;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import org.thingsboard.trendz.service.view.proto.WindowedStreamStore;
import org.thingsboard.trendz.tools.UUIDUtils;
import reactor.core.publisher.Flux;

@Component
public class SqlValueLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqlValueLoader.class);
    private final SqlQueryBuilder sqlQueryBuilder;
    private final SqlDatasourceService sqlDatasourceService;

    @Autowired
    public SqlValueLoader(SqlQueryBuilder sqlQueryBuilder, SqlDatasourceService sqlDatasourceService) {
        this.sqlQueryBuilder = sqlQueryBuilder;
        this.sqlDatasourceService = sqlDatasourceService;
    }

    public Flux<FieldValue> loadSqlValues(Item item, ViewField viewField, ViewContext ctx, WindowedStreamStore windowedStreamStore) {
        List itemValues;
        UUID entityFieldId = viewField.getEntityFieldId();
        BusinessEntityField entityField = (BusinessEntityField)ctx.getBusinessEntityFieldMap().get(entityFieldId);
        FieldType type = entityField.getType();
        if (FieldAggregation.COUNT.equals((Object)viewField.getAggregationType())) {
            type = FieldType.NUMERIC;
        }
        if ((itemValues = (List)ctx.getExternalItemValuesMap().get(item.getId())) == null || itemValues.isEmpty()) {
            return Flux.empty();
        }
        ArrayList<FieldValue> result = new ArrayList<FieldValue>();
        for (SqlEntry itemValue : itemValues) {
            Object val = itemValue.getValues().get(viewField.getId());
            boolean groupMatched = true;
            for (Map.Entry entry : windowedStreamStore.getGroupKeys().entrySet()) {
                ViewField vf = (ViewField)entry.getKey();
                Object storedGroupValue = entry.getValue();
                Object itemGroupValue = itemValue.getValues().get(vf.getId());
                if (storedGroupValue == null || this.isGroupValueMatched(storedGroupValue, itemGroupValue)) continue;
                groupMatched = false;
                break;
            }
            if (!groupMatched) continue;
            FieldValue fieldValue = new FieldValue(item, type, val, itemValue.getTs());
            result.add(fieldValue);
        }
        log.debug("Found {} external sql entries for {}", (Object)result.size(), (Object)item.getId());
        return Flux.fromIterable(result);
    }

    private boolean isGroupValueMatched(Object storedGroupValue, Object itemGroupValue) {
        return storedGroupValue instanceof Collection ? ((Collection)storedGroupValue).contains(itemGroupValue) : storedGroupValue.equals(itemGroupValue);
    }

    public void preloadExternalValues(BusinessEntity businessEntity, ViewRequest viewRequest, ViewContext ctx) {
        long startTs = System.currentTimeMillis();
        UUID parentBeId = this.extractParentBusinessEntityId(businessEntity);
        BusinessEntityField beIdField = this.extractIdField(businessEntity);
        BusinessEntityField beDateField = this.extractDateField(businessEntity);
        Set uniqNotLoadedItems = this.checkUniqNotLoadedItems(parentBeId, ctx);
        if (uniqNotLoadedItems.isEmpty()) {
            log.debug("Preload external values not required. Related items is empty.");
            return;
        }
        String tableName = businessEntity.getQuery().getType();
        String idFieldName = beIdField.getQuery().getKey();
        String dateFieldName = beDateField.getQuery().getKey();
        UUID externalDataSourceId = businessEntity.getQuery().getExternalDataSource();
        SqlDatasource sqlDatasource = this.sqlDatasourceService.getById(ctx.getUser().getTenantId(), externalDataSourceId);
        Set fields = this.getFieldsToLoad(businessEntity, viewRequest);
        long recordsCount = 0L;
        for (List itemPartition : Lists.partition((List)Lists.newArrayList((Iterable)uniqNotLoadedItems), (int)200)) {
            Set<UUID> relatedItemsIds = itemPartition.stream().map(Item::getId).collect(Collectors.toSet());
            String query = this.sqlQueryBuilder.buildQuery(tableName, idFieldName, dateFieldName, sqlDatasource.getDbType(), relatedItemsIds, (Collection)fields, viewRequest, ctx.getBusinessEntityFieldMap());
            log.debug("External sql query: [{}]", (Object)query);
            List allRows = this.sqlDatasourceService.executeQuery(query, sqlDatasource);
            log.info("Got [{}] rows for external sql query", (Object)allRows.size());
            Map externalItemValuesMap = this.mapResult(idFieldName, dateFieldName, allRows, fields, ctx);
            recordsCount += externalItemValuesMap.values().stream().mapToLong(Collection::size).sum();
            relatedItemsIds.forEach(itemId -> externalItemValuesMap.putIfAbsent(itemId, new ArrayList()));
            ctx.getExternalItemValuesMap().putAll(externalItemValuesMap);
        }
        log.info("Preload took {} ms found {} records for {} items ", new Object[]{System.currentTimeMillis() - startTs, recordsCount, uniqNotLoadedItems.size()});
    }

    private UUID extractParentBusinessEntityId(BusinessEntity businessEntity) {
        return businessEntity.getRelations().stream().map(Relation::getRelatedEntityId).collect(Collectors.collectingAndThen(Collectors.toList(), relatedEntityIds -> {
            if (relatedEntityIds.size() != 1) {
                throw new RuntimeException("Expected one related entity ID, but found: " + relatedEntityIds.size());
            }
            return (UUID)relatedEntityIds.get(0);
        }));
    }

    private BusinessEntityField extractIdField(BusinessEntity businessEntity) {
        return this.extractField(businessEntity, bef -> bef.getQuery().isSqlIdKey(), "ID");
    }

    private BusinessEntityField extractDateField(BusinessEntity businessEntity) {
        return this.extractField(businessEntity, bef -> bef.getQuery().isSqlTsKey(), "TS");
    }

    private BusinessEntityField extractField(BusinessEntity businessEntity, Predicate<BusinessEntityField> businessEntityFieldFilter, String fieldTypeName) {
        return businessEntity.getFields().stream().filter(businessEntityFieldFilter).collect(Collectors.collectingAndThen(Collectors.toList(), matchingFields -> {
            if (matchingFields.size() != 1) {
                throw new RuntimeException("Expected one matching " + fieldTypeName + " field, but found: " + matchingFields.size());
            }
            return (BusinessEntityField)matchingFields.iterator().next();
        }));
    }

    private Set<Item> checkUniqNotLoadedItems(UUID parentBeId, ViewContext ctx) {
        HashSet<Item> uniqNotLoadedItems = new HashSet<Item>();
        Map idToItemMap = ctx.getIdToItemMap();
        Map businessEntityIdToItemsSet = ctx.getBusinessEntityIdToItemIdSet();
        ((Set)businessEntityIdToItemsSet.get(parentBeId)).forEach(itemId -> {
            if (!ctx.getExternalItemValuesMap().containsKey(itemId)) {
                Item item = (Item)idToItemMap.get(itemId);
                uniqNotLoadedItems.add(item);
            }
        });
        return uniqNotLoadedItems;
    }

    private Set<ViewField> getFieldsToLoad(BusinessEntity businessEntity, ViewRequest viewRequest) {
        return viewRequest.getFields().stream().filter(f -> !f.isAnomalyField()).filter(f -> !f.isAlarmField()).filter(f -> !f.isStateField()).filter(f -> !f.isBatchCalculation()).filter(f -> !f.isNativeCalculation()).filter(f -> !f.getAggregationType().equals((Object)FieldAggregation.NONE)).filter(viewField -> businessEntity.getId().equals(viewField.getBusinessEntityId())).collect(Collectors.toSet());
    }

    private Map<UUID, List<SqlEntry>> mapResult(String idFieldName, String dateFieldName, List<Map<String, Object>> allRows, Set<ViewField> fields, ViewContext ctx) {
        HashMap<UUID, String> fieldIdToKeyMap = new HashMap<UUID, String>();
        for (ViewField field : fields) {
            UUID entityFieldId = field.getEntityFieldId();
            BusinessEntityField entityField = (BusinessEntityField)ctx.getBusinessEntityFieldMap().get(entityFieldId);
            String key = this.makeAggregatedKey(entityField, field.getAggregationType());
            fieldIdToKeyMap.put(field.getId(), key);
        }
        HashMap<UUID, List<SqlEntry>> itemValues = new HashMap<UUID, List<SqlEntry>>();
        for (Map<String, Object> row : allRows) {
            UUID itemId = UUIDUtils.fromStringOrUUID((Object)row.get(idFieldName));
            long ts = row.get(dateFieldName) instanceof BigDecimal ? ((BigDecimal)row.get(dateFieldName)).longValue() : ((Long)row.get(dateFieldName)).longValue();
            HashMap<UUID, Object> parsedRow = new HashMap<UUID, Object>();
            for (Map.Entry entry : fieldIdToKeyMap.entrySet()) {
                UUID fieldId = (UUID)entry.getKey();
                String fieldKey = (String)entry.getValue();
                Object fieldValue = row.get(fieldKey);
                parsedRow.put(fieldId, fieldValue);
            }
            SqlEntry sqlEntry = new SqlEntry();
            sqlEntry.setTs(ts);
            sqlEntry.setValues(parsedRow);
            itemValues.computeIfAbsent(itemId, k -> new ArrayList()).add(sqlEntry);
        }
        return itemValues;
    }

    private String makeAggregatedKey(BusinessEntityField field, FieldAggregation type) {
        return field.getQuery().getKey() + "_" + type.name().toLowerCase();
    }
}

