/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.script.command;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.exception.service.script.command.CommandExecutionException;
import org.thingsboard.trendz.service.script.command.CommandExecutionRequest;
import org.thingsboard.trendz.service.script.command.CommandExecutionResult;

@Service
public class CommandExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommandExecutor.class);

    public CommandExecutionResult executeCommand(CommandExecutionRequest request) {
        if (request == null || request.getCommands() == null || request.getCommands().isEmpty() || request.getTimeoutDurationMs() <= 0L) {
            CommandExecutionResult result = CommandExecutionResult.builder().started(false).finished(false).exitCode(0).duration(0L).resultOutput(Collections.emptyList()).errorOutput(Collections.emptyList()).build();
            throw new CommandExecutionException((Throwable)new IllegalArgumentException("The request is not valid"), result);
        }
        ExecutorService readLogsExecutor = Executors.newSingleThreadExecutor();
        ExecutorService readErrorsExecutor = Executors.newSingleThreadExecutor();
        Future<?> readLogsFuture = null;
        Future<?> readErrorsFuture = null;
        Process process = null;
        List resultLines = Collections.synchronizedList(new ArrayList());
        List errorLines = Collections.synchronizedList(new ArrayList());
        AtomicReference exceptionReference = new AtomicReference();
        long startExecutionTs = System.currentTimeMillis();
        try {
            Process finalProcess;
            ProcessBuilder pb = new ProcessBuilder(request.getCommands());
            process = finalProcess = pb.start();
            Runnable readLogs = () -> {
                try (BufferedReader inputReader = new BufferedReader(new InputStreamReader(finalProcess.getInputStream()));){
                    String line;
                    while ((line = inputReader.readLine()) != null) {
                        if (exceptionReference.get() != null) {
                            break;
                        }
                        resultLines.add(line);
                    }
                }
                catch (Exception e) {
                    exceptionReference.set(e);
                }
            };
            Runnable readErrors = () -> {
                try (BufferedReader errorReader = new BufferedReader(new InputStreamReader(finalProcess.getErrorStream()));){
                    String line;
                    while ((line = errorReader.readLine()) != null) {
                        if (exceptionReference.get() != null) {
                            break;
                        }
                        errorLines.add(line);
                    }
                }
                catch (Exception e) {
                    exceptionReference.set(e);
                }
            };
            readLogsFuture = readLogsExecutor.submit(readLogs);
            readErrorsFuture = readErrorsExecutor.submit(readErrors);
            if (request.isTimeoutEnable()) {
                boolean finished = process.waitFor(request.getTimeoutDurationMs(), TimeUnit.MILLISECONDS);
                if (!finished) {
                    process.destroyForcibly();
                    throw new TimeoutException();
                }
            } else {
                process.waitFor();
            }
            readLogsFuture.get(5L, TimeUnit.SECONDS);
            readErrorsFuture.get(5L, TimeUnit.SECONDS);
            Exception exception = (Exception)exceptionReference.get();
            if (exception != null) {
                throw exception;
            }
            int exitCode = process.exitValue();
            long endExecutionTs = System.currentTimeMillis();
            long durationExecution = endExecutionTs - startExecutionTs;
            CommandExecutionResult commandExecutionResult = CommandExecutionResult.builder().started(true).finished(true).exitCode(exitCode).duration(durationExecution).resultOutput(new ArrayList(resultLines)).errorOutput(new ArrayList(errorLines)).build();
            return commandExecutionResult;
        }
        catch (Exception e) {
            long endExecutionTs = System.currentTimeMillis();
            long durationExecution = endExecutionTs - startExecutionTs;
            int exitCode = process != null && !process.isAlive() ? process.exitValue() : -1;
            CommandExecutionResult executionResult = CommandExecutionResult.builder().started(true).finished(false).exitCode(exitCode).duration(durationExecution).resultOutput(new ArrayList(resultLines)).errorOutput(new ArrayList(errorLines)).build();
            throw new CommandExecutionException((Throwable)e, executionResult);
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
            if (readLogsFuture != null) {
                readLogsFuture.cancel(true);
            }
            if (readErrorsFuture != null) {
                readErrorsFuture.cancel(true);
            }
            readLogsExecutor.shutdown();
            readErrorsExecutor.shutdown();
        }
    }
}

