/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider.version;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record TbVersionNumber(int major1, int major2, int minor1, int minor2) {
    private final int major1;
    private final int major2;
    private final int minor1;
    private final int minor2;
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbVersionNumber.class);
    public static TbVersionNumber V_2_2_0 = new TbVersionNumber(2, 2, 0, 0);
    public static TbVersionNumber V_3_0_0 = new TbVersionNumber(3, 0, 0, 0);
    public static TbVersionNumber V_3_1_0 = new TbVersionNumber(3, 1, 0, 0);
    public static TbVersionNumber V_3_3_2 = new TbVersionNumber(3, 3, 2, 0);
    public static TbVersionNumber V_3_3_3 = new TbVersionNumber(3, 3, 3, 0);
    public static TbVersionNumber V_3_5_0 = new TbVersionNumber(3, 5, 0, 0);
    public static TbVersionNumber V_3_6_0 = new TbVersionNumber(3, 6, 0, 0);
    public static TbVersionNumber V_3_6_1 = new TbVersionNumber(3, 6, 1, 0);
    public static TbVersionNumber V_3_6_2 = new TbVersionNumber(3, 6, 2, 0);
    public static TbVersionNumber V_3_7_0 = new TbVersionNumber(3, 7, 0, 0);
    public static TbVersionNumber V_3_9_0 = new TbVersionNumber(3, 9, 0, 0);
    public static TbVersionNumber V_4_3_0 = new TbVersionNumber(4, 3, 0, 0);

    public TbVersionNumber(int major1, int major2, int minor1, int minor2) {
        this.major1 = major1;
        this.major2 = major2;
        this.minor1 = minor1;
        this.minor2 = minor2;
    }

    public static TbVersionNumber fromValue(String value) {
        if (value == null || value.isBlank()) {
            return null;
        }
        try {
            String[] parts = value.replace("V_", "").replace('_', '.').split("\\.");
            int major1 = parts.length > 0 ? Integer.parseInt(parts[0]) : 0;
            int major2 = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
            int minor1 = parts.length > 2 ? Integer.parseInt(parts[2]) : 0;
            int minor2 = parts.length > 3 ? Integer.parseInt(parts[3]) : 0;
            return new TbVersionNumber(major1, major2, minor1, minor2);
        }
        catch (RuntimeException e) {
            log.warn("Impossible to parse ThingsBoard version ({})", (Object)value, (Object)e);
            return null;
        }
    }

    public boolean less(TbVersionNumber that) {
        return this.ordinal() < that.ordinal();
    }

    public boolean greater(TbVersionNumber that) {
        return this.ordinal() > that.ordinal();
    }

    public boolean equals(TbVersionNumber that) {
        return this.ordinal() == that.ordinal();
    }

    public boolean lessOrEqual(TbVersionNumber that) {
        return this.ordinal() <= that.ordinal();
    }

    public boolean greaterOrEqual(TbVersionNumber that) {
        return this.ordinal() >= that.ordinal();
    }

    public boolean inTheInterval(TbVersionNumber n1, TbVersionNumber n2) {
        return this.greaterOrEqual(n1) && this.less(n2);
    }

    public long ordinal() {
        return 1000000000L * (long)this.major1 + 1000000L * (long)this.major2 + 1000L * (long)this.minor1 + (long)this.minor2;
    }

    @Override
    public String toString() {
        return this.minor2 == 0 ? "%s.%s.%s".formatted(this.major1, this.major2, this.minor1) : "%s.%s.%s.%s".formatted(this.major1, this.major2, this.minor1, this.minor2);
    }

    public int major1() {
        return this.major1;
    }

    public int major2() {
        return this.major2;
    }

    public int minor1() {
        return this.minor1;
    }

    public int minor2() {
        return this.minor2;
    }
}

