/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider.version;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.domain.tb.info.TbInfo;
import org.thingsboard.trendz.domain.tb.provider.RequestPriority;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.service.AuthenticationService;
import org.thingsboard.trendz.service.provider.TbWebClient;
import org.thingsboard.trendz.service.provider.TbWebRequest;
import org.thingsboard.trendz.service.provider.TbWebResponse;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.DeviceTypeFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityDataPageLink;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityDataQuery;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityDataSortOrder;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityKey;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityKeyType;
import org.thingsboard.trendz.service.provider.version.TbVersion;
import org.thingsboard.trendz.service.provider.version.TbVersionNumber;
import org.thingsboard.trendz.service.provider.version.TbVersionProperties;
import org.thingsboard.trendz.service.tb.configuration.TbConfigurationStorage;
import org.thingsboard.trendz.service.tb.widget.NativeWidgetBundleServiceComposite;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Mono;

@Component
public class TbVersionChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbVersionChecker.class);
    private static final Pattern VERSION_STRING_PATTERN = Pattern.compile("\\d.\\d.\\d");
    private final TbWebClient tbWebClient;
    private final TbConfigurationStorage tbConfigurationStorage;
    private final AuthenticationService authenticationService;
    private final boolean useDefaultSet;
    private final boolean useManualSet;
    private final TbVersion defaultVersion;
    private final TbVersion manualVersion;
    private TbVersion currentVersion;

    @Autowired
    public TbVersionChecker(TbVersionProperties tbVersionProperties, TbWebClient tbWebClient, TbConfigurationStorage tbConfigurationStorage, AuthenticationService authenticationService) {
        this.tbWebClient = tbWebClient;
        this.tbConfigurationStorage = tbConfigurationStorage;
        this.authenticationService = authenticationService;
        this.useDefaultSet = tbVersionProperties.isUseDefaultSet();
        this.useManualSet = tbVersionProperties.isUseManualSet();
        this.defaultVersion = new TbVersion(tbVersionProperties.isDefaultPe(), tbVersionProperties.isDefaultCloud(), tbVersionProperties.getDefaultVersion(), TbVersion.VersionSource.DEFAULT);
        this.manualVersion = new TbVersion(tbVersionProperties.isManualPe(), tbVersionProperties.isManualCloud(), tbVersionProperties.getManualVersion(), TbVersion.VersionSource.MANUAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TbVersion getVersion(JwtSecurityUser user) {
        if (this.currentVersion != null) {
            return this.currentVersion;
        }
        TbVersionChecker tbVersionChecker = this;
        synchronized (tbVersionChecker) {
            if (this.currentVersion != null) {
                return this.currentVersion;
            }
            this.currentVersion = (TbVersion)DonReactive.block((Mono)this.makeVersionPublisher(user));
            return this.currentVersion;
        }
    }

    public TbInfo getTbInfo(JwtSecurityUser user) {
        TbVersion tbVersion = this.getVersion(user);
        TbInfo.BundleLevel bundleLevel = NativeWidgetBundleServiceComposite.VERSION_NUMBER_2.greater(tbVersion.getVersion()) ? TbInfo.BundleLevel.TENANT : TbInfo.BundleLevel.SYSTEM;
        boolean isSynced = this.tbConfigurationStorage.getTbConfiguration().isEnabled();
        return TbInfo.builder().version(tbVersion).bundleLevel(bundleLevel).isSynced(isSynced).build();
    }

    private Mono<TbVersion> makeVersionPublisher(JwtSecurityUser user) {
        return Mono.just((Object)new Object()).flatMap(o -> {
            if (this.useManualSet) {
                return Mono.just((Object)this.getManualVersion());
            }
            return this.checkAvailability().flatMap(available -> {
                if (available.booleanValue()) {
                    return this.fetchVersionByApi(user).onErrorResume(throwable -> this.fetchVersionIndirectly(user)).onErrorResume(throwable -> Mono.just((Object)this.getDefaultVersion()));
                }
                return Mono.error((Throwable)new IllegalStateException("TB API is not available!"));
            });
        }).doOnNext(tbVersion -> log.info("TB version is discovered: {}", tbVersion));
    }

    private Mono<Boolean> checkAvailability() {
        return this.checkApi("", null, "TB API", Collections.emptyMap());
    }

    private Mono<TbVersion> fetchVersionByApi(JwtSecurityUser user) {
        return this.tbWebClient.get(new TbWebRequest("/api/system/info", RequestPriority.HIGH, this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get).map(jsonResponse -> jsonResponse.get("version").textValue()).flatMap(version -> {
            if ("unknown".equals(version)) {
                log.error("ThingsBoard service tell the version is unknown!");
                return this.useDefaultSet ? Mono.just((Object)this.getDefaultVersion()) : Mono.error((Throwable)new IllegalStateException("Unsupported version: unknown"));
            }
            String parsedVersion = this.getSubstringByRegex(version);
            boolean isCloud = version.toLowerCase().contains("paas");
            boolean isPe = isCloud || version.toLowerCase().contains("pe");
            TbVersionNumber versionNumber = TbVersionNumber.fromValue((String)parsedVersion);
            if (versionNumber == null) {
                return this.useDefaultSet ? Mono.just((Object)this.getDefaultVersion()) : Mono.error((Throwable)new IllegalStateException("Unsupported version:" + parsedVersion));
            }
            return Mono.just((Object)new TbVersion(isPe, isCloud, versionNumber, TbVersion.VersionSource.DIRECT));
        }).onErrorMap(throwable -> new IllegalStateException("Can't define ThingsBoard version.", (Throwable)throwable));
    }

    private Mono<TbVersion> fetchVersionIndirectly(JwtSecurityUser user) {
        return this.isTb2Api(user).flatMap(isTb2 -> {
            if (isTb2.booleanValue()) {
                return this.is2xPe(user).map(isPe -> new TbVersion(isPe.booleanValue(), false, TbVersionNumber.V_2_2_0, TbVersion.VersionSource.INDIRECT));
            }
            return this.isTb3Api(user).flatMap(isTb3 -> this.is3xPe(user).flatMap(isPe -> {
                if (!isTb3.booleanValue()) {
                    return Mono.error((Throwable)new IllegalStateException("Can't define Thingsboard version, service is unavailable."));
                }
                return this.isTb3_3_2_Api(user).flatMap(isTb3_3_2 -> {
                    if (isTb3_3_2.booleanValue()) {
                        return Mono.just((Object)new TbVersion(isPe.booleanValue(), false, TbVersionNumber.V_3_3_2, TbVersion.VersionSource.INDIRECT));
                    }
                    return this.isTb31FilterApi(user).flatMap(isTb31Filter -> {
                        if (isTb31Filter.booleanValue()) {
                            return Mono.just((Object)new TbVersion(isPe.booleanValue(), false, TbVersionNumber.V_3_1_0, TbVersion.VersionSource.INDIRECT));
                        }
                        return Mono.just((Object)new TbVersion(isPe.booleanValue(), false, TbVersionNumber.V_3_0_0, TbVersion.VersionSource.INDIRECT));
                    });
                });
            }));
        });
    }

    private Mono<Boolean> isTb2Api(JwtSecurityUser user) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("limit", 1);
        params.put("type", "stubType");
        params.put("idOffset", "fd48a070-aef4-11ea-b3fd-91f05b9b652c");
        params.put("textOffset", " ");
        params.put("textSearch", " ");
        String uri = "/api/tenant/assets";
        if (!user.getCustomerId().equals(EntityId.NULL_UUID)) {
            params.put("customerId", user.getCustomerId());
            uri = "/api/customer/{customerId}/assets";
        }
        return this.checkApi(uri, user, "TB API v2", params);
    }

    private Mono<Boolean> isTb3Api(JwtSecurityUser user) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageSize", 1);
        params.put("page", 1);
        params.put("type", "stubType");
        params.put("textSearch", " ");
        params.put("sortProperty", "name");
        params.put("sortOrder", "ASC");
        String uri = "/api/entityGroups/DASHBOARD";
        return this.checkApi(uri, user, "TB API v3 PE", Collections.emptyMap()).flatMap(b -> {
            if (!b.booleanValue()) {
                String ceUri = "/api/tenant/devices";
                return this.checkApi(ceUri, user, "TB API v3 CE", params);
            }
            return Mono.just((Object)true);
        });
    }

    private Mono<Boolean> isTb31FilterApi(JwtSecurityUser user) {
        return this.tbWebClient.post(new TbWebRequest("/api/entitiesQuery/find", RequestPriority.HIGH, this.authenticationService.getAuthHeaders(user), (Object)this.getTb31FilterQuery(), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).thenReturn((Object)true).onErrorResume(throwable -> {
            log.warn("TB API v3.1_filter not supported - {}", (Object)throwable.getMessage());
            return Mono.just((Object)false);
        });
    }

    private EntityDataQuery getTb31FilterQuery() {
        DeviceTypeFilter filter = new DeviceTypeFilter("default", "");
        List keyFilters = Collections.emptyList();
        List entityFields = Collections.emptyList();
        List latestValues = Collections.emptyList();
        EntityDataSortOrder sortOrder = new EntityDataSortOrder(new EntityKey(EntityKeyType.ENTITY_FIELD, "createdTime"), EntityDataSortOrder.Direction.ASC);
        EntityDataPageLink pageLink = new EntityDataPageLink(10, 0, null, sortOrder);
        return new EntityDataQuery((EntityFilter)filter, pageLink, entityFields, latestValues, keyFilters);
    }

    private Mono<Boolean> isTb3_3_2_Api(JwtSecurityUser user) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("pageSize", 1);
        params.put("page", 0);
        String uri = "/api/otaPackages";
        return this.checkApi(uri, user, "TB API v3.3.2", params);
    }

    private Mono<Boolean> is3xPe(JwtSecurityUser user) {
        String uri = "/api/entityGroups/DASHBOARD";
        return this.checkApi(uri, user, "TB API PEv3", Collections.emptyMap());
    }

    private Mono<Boolean> is2xPe(JwtSecurityUser user) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("limit", 1);
        params.put("type", "GENERIC");
        params.put("idOffset", EntityId.NULL_UUID);
        params.put("textOffset", " ");
        params.put("textSearch", " ");
        String uri = "/api/roles";
        return this.checkApi(uri, user, "TB API PEv2", params);
    }

    private TbVersion getDefaultVersion() {
        log.warn("Thingsboard version is not recognized, using default version: {}", (Object)this.defaultVersion.getVersion());
        return this.defaultVersion;
    }

    private TbVersion getManualVersion() {
        log.warn("Trendz using manual version: {}", (Object)this.manualVersion.getVersion());
        return this.manualVersion;
    }

    private String getSubstringByRegex(String where) {
        Matcher matcher = VERSION_STRING_PATTERN.matcher(where);
        if (!matcher.find()) {
            throw new IllegalStateException("Can't find pattern in the string.");
        }
        return matcher.group();
    }

    private Mono<Boolean> checkApi(String uri, JwtSecurityUser user, String checkVersion, Map<String, Object> params) {
        return this.tbWebClient.get(new TbWebRequest(uri, RequestPriority.HIGH, MultiValueMap.fromSingleValue(params), this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).thenReturn((Object)true).onErrorResume(throwable -> {
            log.warn("{} not supported - {}", (Object)checkVersion, (Object)throwable.getMessage());
            return Mono.just((Object)false);
        });
    }
}

