/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.EntitySubtype;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ResourceType;
import org.thingsboard.server.common.data.SystemParams;
import org.thingsboard.server.common.data.TbResource;
import org.thingsboard.server.common.data.TbResourceInfo;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.asset.AssetSearchQuery;
import org.thingsboard.server.common.data.device.DeviceSearchQuery;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.EntitySearchDirection;
import org.thingsboard.server.common.data.relation.RelationsSearchParameters;
import org.thingsboard.server.common.data.subscription.SubscriptionInfo;
import org.thingsboard.server.common.data.wl.WhiteLabelingParams;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.relation.Direction;
import org.thingsboard.trendz.domain.definition.entity.relation.Relation;
import org.thingsboard.trendz.domain.measurement.MeasuredTaskType;
import org.thingsboard.trendz.domain.measurement.MeasurementInfo;
import org.thingsboard.trendz.domain.measurement.MeasurementParameters;
import org.thingsboard.trendz.domain.runtime.EnhancedAsset;
import org.thingsboard.trendz.domain.runtime.EnhancedCustomer;
import org.thingsboard.trendz.domain.runtime.EnhancedDevice;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.domain.tb.configuration.TrendzConfigurations;
import org.thingsboard.trendz.domain.tb.dashboard.dto.Dashboard;
import org.thingsboard.trendz.domain.tb.provider.RequestPriority;
import org.thingsboard.trendz.domain.tb.widget.v1.TbWidgetBundleItemV1;
import org.thingsboard.trendz.domain.tb.widget.v1.TbWidgetTypeItemV1;
import org.thingsboard.trendz.domain.tb.widget.v2.TbWidgetBundleItemV2;
import org.thingsboard.trendz.domain.tb.widget.v2.TbWidgetTypeItemV2;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.security.entity.AuthToken;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.jwt.JwtSettings;
import org.thingsboard.trendz.security.service.AuthenticationService;
import org.thingsboard.trendz.service.definition.TbDataEntry;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.provider.AttributeData;
import org.thingsboard.trendz.service.provider.TbAssetService;
import org.thingsboard.trendz.service.provider.TbCustomerService;
import org.thingsboard.trendz.service.provider.TbDeviceService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.provider.TbWebClient;
import org.thingsboard.trendz.service.provider.TbWebRequest;
import org.thingsboard.trendz.service.provider.TbWebRequestExecutionInfo;
import org.thingsboard.trendz.service.provider.TbWebResponse;
import org.thingsboard.trendz.service.provider.TsData;
import org.thingsboard.trendz.service.provider.cache.WebClientCachier;
import org.thingsboard.trendz.service.provider.tb3.PageLink;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.FilteredEntityDataTransformer;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.TbFilterQueryBuilder;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.AssetTypeFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.DeviceTypeFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityData;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityDataPageLink;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityDataQuery;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityDataSortOrder;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityKey;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityKeyType;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityTypeFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.TsValue;
import org.thingsboard.trendz.service.provider.version.TbVersion;
import org.thingsboard.trendz.service.provider.version.TbVersionChecker;
import org.thingsboard.trendz.service.provider.version.TbVersionNumber;
import org.thingsboard.trendz.service.stats.StatsCollector;
import org.thingsboard.trendz.service.stats.TickType;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.function.Tuple2;

@Component
public class TbRestDataSource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbRestDataSource.class);
    public static final int MAX_ITEM_IDS_IN_PARAM = 100;
    public static final int MAX_PARAM_LENGTH = 3072;
    private final TbVersionChecker tbVersionChecker;
    private final TbFilterQueryBuilder tbFilterQueryBuilder;
    private final FilteredEntityDataTransformer entityDataTransformer;
    private final StatsCollector statsCollector;
    private final WebClientCachier webClientCachier;
    private final TbWebClient tbWebClient;
    private final ExecutorManagementService executorManagementService;
    private final AuthenticationService authenticationService;
    private final int pagesizeItems;
    private final int pagesizeTelemetry;
    private final int sendTelemetryBatchSize;
    private final long sendTelemetryIntervalMs;

    @Autowired
    public TbRestDataSource(TbVersionChecker tbVersionChecker, TbFilterQueryBuilder tbFilterQueryBuilder, FilteredEntityDataTransformer entityDataTransformer, StatsCollector statsCollector, WebClientCachier webClientCachier, TbWebClient tbWebClient, ExecutorManagementService executorManagementService, AuthenticationService authenticationService, @Value(value="${tb.api.limits.pagesize.items}") int pagesizeItems, @Value(value="${tb.api.limits.pagesize.telemetry}") int pagesizeTelemetry, @Value(value="${ratelimit.sendTelemetryBatchSize}") int sendTelemetryBatchSize, @Value(value="${ratelimit.sendTelemetryIntervalMs}") long sendTelemetryIntervalMs) {
        this.tbVersionChecker = tbVersionChecker;
        this.tbFilterQueryBuilder = tbFilterQueryBuilder;
        this.entityDataTransformer = entityDataTransformer;
        this.statsCollector = statsCollector;
        this.webClientCachier = webClientCachier;
        this.tbWebClient = tbWebClient;
        this.executorManagementService = executorManagementService;
        this.authenticationService = authenticationService;
        this.pagesizeItems = pagesizeItems;
        this.pagesizeTelemetry = pagesizeTelemetry;
        this.sendTelemetryBatchSize = sendTelemetryBatchSize;
        this.sendTelemetryIntervalMs = sendTelemetryIntervalMs;
    }

    public Mono<AuthToken> login(String login, String pass) {
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("username", login);
        requestBody.put("password", pass);
        return this.tbWebClient.post(new TbWebRequest("/api/auth/login", RequestPriority.HIGH, requestBody, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<AuthToken> refreshToken(String refreshToken) {
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("refreshToken", refreshToken);
        return this.tbWebClient.post(new TbWebRequest("/api/auth/token", RequestPriority.HIGH, requestBody, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<User> getUserByApi(JwtSecurityUser user) {
        return this.tbWebClient.get(new TbWebRequest("/api/user/" + String.valueOf(user.getUserId()), RequestPriority.HIGH, this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<TrendzConfigurations> loadTrendzConfigurations(String tbUrl, String accessToken) {
        return this.tbWebClient.get(new TbWebRequest(tbUrl, "/api/trendz/config", RequestPriority.HIGH, this.authenticationService.getTrendzApiTokenHeader(accessToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<Boolean> triggerThingsBoardSync() {
        return this.tbWebClient.post(new TbWebRequest("/api/trendz/public/connect", RequestPriority.HIGH, new HttpHeaders(), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get).doOnNext(b -> log.info("ThingsBoard sync was successfully triggered"));
    }

    public Mono<SystemParams> getTbSystemParams(JwtSecurityUser user) {
        String url = "/api/system/params";
        return this.tbWebClient.get(new TbWebRequest(url, RequestPriority.HIGH, this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<SubscriptionInfo> getTbSubscriptionInfo() {
        String url = "/api/admin/subscriptionInfo";
        return this.tbWebClient.get(new TbWebRequest(url, RequestPriority.HIGH, this.authenticationService.getTrendzApiTokenHeader(), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<JsonNode> getSubscriptionDetails(JwtSecurityUser user) {
        return this.tbWebClient.get(new TbWebRequest("/api/tenant/subscription/mergedProfileConfig", RequestPriority.HIGH, this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<JsonNode> getSubscription(JwtSecurityUser user) {
        return this.tbWebClient.get(new TbWebRequest("/api/tenant/subscription", RequestPriority.HIGH, this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Flux<Device> findRelatedDevices(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, Relation relation, String relatedDeviceType, EntityId entityId, JwtSecurityUser user) {
        Flux result;
        TbVersion tbVersion = this.getTbVersionValidating(user);
        EntitySearchDirection direction = relation.getDirection() == Direction.FROM ? EntitySearchDirection.FROM : EntitySearchDirection.TO;
        int pageSize = this.determinePageSize(request);
        if (tbVersion.getVersion().greaterOrEqual(TbVersionNumber.V_3_1_0)) {
            EntityDataQuery query = this.tbFilterQueryBuilder.buildRelationQuery(entityId, direction, businessEntity, request, relatedDeviceType, EntityType.DEVICE, ctx, relation.getRelationType(), pageSize);
            Supplier<Flux> findRelatedDevicesSupplier = () -> this.loadDevicesPageV31Filter(ctx, query, user).map(pd -> Sets.newHashSet((Iterable)pd.getData())).doOnNext(devices -> {
                List itemList = devices.stream().map(device -> TbDeviceService.map((Device)device, (String)relatedDeviceType, (UUID)entityId.getId())).collect(Collectors.toList());
                this.entityDataTransformer.fetchFilterValues(ctx, request, businessEntity, itemList);
            }).flatMapMany(l -> {
                if (request != null && request.isOwnerRequired()) {
                    return this.entityDataTransformer.enrichDevicesWithCustomerId((Set)l, deviceIds -> this.loadDevicesByIds(ctx, deviceIds, user));
                }
                return Flux.fromIterable((Iterable)l);
            }).map(o -> (EnhancedDevice)o);
            String key = String.valueOf(query);
            result = this.webClientCachier.getOrFetch("findRelatedDevices", key, user, findRelatedDevicesSupplier, (TypeReference)new /* Unavailable Anonymous Inner Class!! */).map(o -> o);
        } else {
            Map distancesFromRoot = ctx.getDistancesFromRoot();
            Integer distance = (Integer)distancesFromRoot.get(entityId.getId());
            DeviceSearchQuery query = new DeviceSearchQuery();
            query.setParameters(new RelationsSearchParameters(entityId, direction, distance.intValue(), false));
            query.setRelationType(relation.getRelationType());
            query.setDeviceTypes(Collections.singletonList(relatedDeviceType));
            Flux deviceFlux = this.tbWebClient.post(new TbWebRequest("/api/devices", this.priorityFromCtx(ctx), this.authenticationService.getAuthHeaders(user), (Object)query, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "findRelatedDevices", response)).map(Optional::get).flatMapIterable(list -> list);
            result = this.collectStats(deviceFlux, "findRelatedDevices");
        }
        return result;
    }

    public Flux<Asset> findRelatedAssets(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, Relation relation, String relatedAssetType, EntityId entityId, JwtSecurityUser user) {
        TbVersion tbVersion = this.getTbVersionValidating(user);
        EntitySearchDirection direction = relation.getDirection() == Direction.FROM ? EntitySearchDirection.FROM : EntitySearchDirection.TO;
        int pageSize = this.determinePageSize(request);
        if (tbVersion.getVersion().greaterOrEqual(TbVersionNumber.V_3_1_0)) {
            EntityDataQuery query = this.tbFilterQueryBuilder.buildRelationQuery(entityId, direction, businessEntity, request, relatedAssetType, EntityType.ASSET, ctx, relation.getRelationType(), pageSize);
            Mono assetsMono = this.loadAssetsPageV31Filter(ctx, query, user);
            Supplier<Flux> findRelatedAssetsSupplier = () -> this.collectStats(assetsMono, "findRelatedAssets").map(pd -> Sets.newHashSet((Iterable)pd.getData())).doOnNext(assets -> {
                List itemList = assets.stream().map(asset -> TbAssetService.map((Asset)asset, (String)relatedAssetType, (UUID)entityId.getId())).collect(Collectors.toList());
                this.entityDataTransformer.fetchFilterValues(ctx, request, businessEntity, itemList);
            }).flatMapMany(l -> {
                if (request != null && request.isOwnerRequired()) {
                    return this.entityDataTransformer.enrichAssetsWithCustomerId((Set)l, assetIds -> this.loadAssetsByIds(ctx, assetIds, user));
                }
                return Flux.fromIterable((Iterable)l);
            }).map(o -> (EnhancedAsset)o);
            String key = String.valueOf(query);
            return this.webClientCachier.getOrFetch("findRelatedAssets", key, user, findRelatedAssetsSupplier, (TypeReference)new /* Unavailable Anonymous Inner Class!! */).map(o -> o);
        }
        Map distancesFromRoot = ctx.getDistancesFromRoot();
        Integer distance = (Integer)distancesFromRoot.get(entityId.getId());
        AssetSearchQuery query = new AssetSearchQuery();
        query.setParameters(new RelationsSearchParameters(entityId, direction, distance.intValue(), false));
        query.setRelationType(relation.getRelationType());
        query.setAssetTypes(Collections.singletonList(relatedAssetType));
        return this.tbWebClient.post(new TbWebRequest("/api/assets", this.priorityFromCtx(ctx), this.authenticationService.getAuthHeaders(user), (Object)query, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "findRelatedAssets", response)).map(Optional::get).flatMapIterable(list -> list);
    }

    public Flux<Customer> findRelatedCustomers(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, Relation relation, String relatedCustomerType, EntityId entityId, JwtSecurityUser user) {
        EntitySearchDirection direction = relation.getDirection() == Direction.FROM ? EntitySearchDirection.FROM : EntitySearchDirection.TO;
        int pageSize = this.determinePageSize(request);
        TbVersion tbVersion = this.getTbVersionValidating(user);
        if (tbVersion.getVersion().greaterOrEqual(TbVersionNumber.V_3_1_0)) {
            EntityDataQuery query = this.tbFilterQueryBuilder.buildRelationQuery(entityId, direction, businessEntity, request, relatedCustomerType, EntityType.CUSTOMER, ctx, relation.getRelationType(), pageSize);
            Mono customersMono = this.loadEntitiesPageV31Filter(ctx, query, user, "findRelatedCustomers", arg_0 -> ((FilteredEntityDataTransformer)this.entityDataTransformer).entityToCustomerPageData(arg_0));
            Supplier<Flux> findRelatedCustomersSupplier = () -> this.collectStats(customersMono, "findRelatedCustomers").map(PageData::getData).doOnNext(customerList -> {
                List itemList = customerList.stream().map(customer -> TbCustomerService.mapCustomerToItem((Customer)customer, (UUID)entityId.getId())).collect(Collectors.toList());
                this.entityDataTransformer.fetchFilterValues(ctx, request, businessEntity, itemList);
            }).flatMapIterable(l -> l).map(o -> (EnhancedCustomer)o);
            String key = String.valueOf(query);
            return this.webClientCachier.getOrFetch("findRelatedCustomers", key, user, findRelatedCustomersSupplier, (TypeReference)new /* Unavailable Anonymous Inner Class!! */).map(o -> o);
        }
        throw new IllegalStateException("Customer relation search not allowed in this version");
    }

    public Flux<Item> findMultiRootRelatedItems(ViewRequest request, ViewContext ctx, Set<EntityId> entityIds, JwtSecurityUser user) {
        int pageSize = this.determinePageSize(request);
        int limit = this.determineAbsoluteLimit(request, null);
        TbVersion version = this.getTbVersionValidating(user);
        if (version.getVersion().less(TbVersionNumber.V_3_3_3)) {
            return Flux.error((Throwable)new IllegalStateException("findMultiRootRelatedItems function is not allowed for version " + String.valueOf(version)));
        }
        Optional optional = this.tbFilterQueryBuilder.buildMultiRelationQuery(entityIds, request, ctx, pageSize);
        if (optional.isEmpty()) {
            return Flux.empty();
        }
        EntityDataQuery query = (EntityDataQuery)optional.get();
        Flux itemFlux = this.loadQueryPageableData(query, q -> this.loadRawEntityData(ctx, q, user), limit);
        return this.collectStats(itemFlux, "findMultiRootRelatedItems");
    }

    public Flux<EntitySubtype> loadAssetTypes(JwtSecurityUser user) {
        return this.loadEntityTypes(user, "/api/asset/types");
    }

    public Flux<EntitySubtype> loadDeviceTypes(JwtSecurityUser user) {
        return this.loadEntityTypes(user, "/api/device/types");
    }

    private Flux<EntitySubtype> loadEntityTypes(JwtSecurityUser user, String url) {
        return this.tbWebClient.get(new TbWebRequest(url, RequestPriority.LOW, this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get).flatMapIterable(set -> set);
    }

    public Mono<Long> countAssetsByType(JwtSecurityUser user, String assetType) {
        PageLink pageLink = new PageLink(1);
        return this.loadAssetsPageV3(null, pageLink, user, assetType, null).map(PageData::getTotalElements).defaultIfEmpty((Object)0L);
    }

    public Mono<Long> countDevicesByType(JwtSecurityUser user, String deviceType) {
        PageLink pageLink = new PageLink(1);
        return this.loadDevicesPageV3(null, pageLink, user, deviceType, null).map(PageData::getTotalElements).defaultIfEmpty((Object)0L);
    }

    public Mono<Optional<Set<String>>> findAttributeKeys(String scope, String type, UUID id, JwtSecurityUser user) {
        String uri = "/api/plugins/telemetry/" + type + "/" + String.valueOf(id) + "/keys/attributes/" + scope;
        return this.tbWebClient.get(new TbWebRequest(uri, RequestPriority.LOW, this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse);
    }

    public Mono<Optional<Set<String>>> findTelemetryKeys(String type, UUID id, JwtSecurityUser user) {
        String uri = "/api/plugins/telemetry/" + type + "/" + String.valueOf(id) + "/keys/timeseries";
        return this.tbWebClient.get(new TbWebRequest(uri, RequestPriority.LOW, this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse);
    }

    public Flux<EntityRelation> findRelations(UUID entityId, String entityType, JwtSecurityUser user, String relationType, Direction direction) {
        HashMap<String, String> requestParam = new HashMap<String, String>();
        switch (63.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$relation$Direction[direction.ordinal()]) {
            case 1: {
                requestParam.put("fromId", entityId.toString());
                requestParam.put("fromType", entityType);
                break;
            }
            case 2: {
                requestParam.put("toId", entityId.toString());
                requestParam.put("toType", entityType);
            }
        }
        if (relationType != null) {
            requestParam.put("relationType", relationType);
        }
        return this.tbWebClient.get(new TbWebRequest("/api/relations", null, MultiValueMap.fromSingleValue(requestParam), this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get).flatMapIterable(set -> set);
    }

    public Flux<Asset> loadAssets(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, String assetType, String textSearch, JwtSecurityUser user, Integer limit) {
        TbVersion version = this.getTbVersionValidating(user);
        Flux assetsFlux = this.loadAssets(ctx, request, businessEntity, assetType, textSearch, limit, user);
        if (version.getVersion().greaterOrEqual(TbVersionNumber.V_3_1_0) && request != null) {
            return assetsFlux.collectList().doOnNext(allAssets -> {
                List itemList = allAssets.stream().map(asset -> TbAssetService.map((Asset)asset, (String)assetType, null)).collect(Collectors.toList());
                this.entityDataTransformer.fetchFilterValues(ctx, request, businessEntity, itemList);
            }).flatMapIterable(Function.identity());
        }
        if (version.getVersion().greaterOrEqual(TbVersionNumber.V_3_1_0) && request != null && request.isOwnerRequired()) {
            return assetsFlux.collectList().flatMapMany(allAssets -> this.entityDataTransformer.enrichAssetsWithCustomerId(new HashSet(allAssets), assetIds -> this.loadAssetsByIds(ctx, assetIds, user)));
        }
        return assetsFlux;
    }

    public Flux<Device> loadDevices(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, String deviceType, String textSearch, JwtSecurityUser user, Integer limit) {
        TbVersion version = this.getTbVersionValidating(user);
        Flux devicesFlux = this.loadDevices(ctx, request, businessEntity, deviceType, textSearch, limit, user);
        if (version.getVersion().greaterOrEqual(TbVersionNumber.V_3_1_0) && request != null) {
            return devicesFlux.collectList().doOnNext(allAssets -> {
                List itemList = allAssets.stream().map(device -> TbDeviceService.map((Device)device, (String)deviceType, null)).collect(Collectors.toList());
                this.entityDataTransformer.fetchFilterValues(ctx, request, businessEntity, itemList);
            }).flatMapIterable(Function.identity());
        }
        if (version.getVersion().greaterOrEqual(TbVersionNumber.V_3_1_0) && request != null && request.isOwnerRequired()) {
            return devicesFlux.collectList().flatMapMany(allAssets -> this.entityDataTransformer.enrichDevicesWithCustomerId(new HashSet(allAssets), deviceIds -> this.loadDevicesByIds(ctx, deviceIds, user)));
        }
        return devicesFlux;
    }

    public Flux<Customer> loadCustomers(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, JwtSecurityUser user) {
        Flux customerFlux = this.loadCustomers(request, ctx, businessEntity, user);
        return this.collectStats(customerFlux, "loadCustomers");
    }

    private Flux<Device> loadDevices(ViewContext ctx, ViewRequest request, BusinessEntity businessEntity, String deviceType, String textSearch, Integer limit, JwtSecurityUser user) {
        return this.loadEntities(request, ctx, businessEntity, user, EntityType.DEVICE, deviceType, limit, link -> this.loadDevicesPageV3(ctx, link, user, deviceType, textSearch), q -> this.loadDevicesPageV31Filter(ctx, q, user));
    }

    private Flux<Asset> loadAssets(ViewContext ctx, ViewRequest request, BusinessEntity businessEntity, String assetType, String textSearch, Integer limit, JwtSecurityUser user) {
        return this.loadEntities(request, ctx, businessEntity, user, EntityType.ASSET, assetType, limit, link -> this.loadAssetsPageV3(ctx, link, user, assetType, textSearch), q -> this.loadAssetsPageV31Filter(ctx, q, user));
    }

    private Flux<Customer> loadCustomers(ViewRequest request, ViewContext ctx, BusinessEntity businessEntity, JwtSecurityUser user) {
        return this.loadEntities(request, ctx, businessEntity, user, EntityType.CUSTOMER, "", null, link -> this.loadCustomersPageV3(ctx, link, user), q -> this.loadCustomersPageV31Filter(ctx, q, user));
    }

    private <T> Flux<T> loadEntities(ViewRequest request, ViewContext ctx, BusinessEntity businessEntity, JwtSecurityUser user, EntityType entityType, String entitySubType, Integer limit, Function<PageLink, Mono<PageData<T>>> loadV3Function, Function<EntityDataQuery, Mono<PageData<T>>> loadV31FilterFunction) {
        TbVersion version = this.tbVersionChecker.getVersion(user);
        int pageSize = this.determinePageSize(request, limit);
        int totalLimit = this.determineAbsoluteLimit(request, limit);
        if (version.getVersion().inTheInterval(TbVersionNumber.V_3_0_0, TbVersionNumber.V_3_1_0) || request == null) {
            return this.loadPageableData(pageSize, loadV3Function, totalLimit);
        }
        if (!version.getVersion().greaterOrEqual(TbVersionNumber.V_3_1_0)) {
            return Flux.error((Throwable)new IllegalStateException("Tb Version unknown " + String.valueOf(version)));
        }
        EntityDataQuery query = this.tbFilterQueryBuilder.buildFilterQuery(entityType, entitySubType, businessEntity, request, ctx, pageSize);
        return this.loadQueryPageableData(query, loadV31FilterFunction, totalLimit);
    }

    public Integer determineAbsoluteLimit(ViewRequest request, Integer limit) {
        int limit1 = limit != null ? limit : Integer.MAX_VALUE;
        int limit2 = request != null && request.isPreviewRequest() ? request.getPreviewItemCount() : Integer.MAX_VALUE;
        return Math.min(limit1, limit2);
    }

    private int determinePageSize(ViewRequest request) {
        return this.determinePageSize(request, null);
    }

    private int determinePageSize(ViewRequest request, Integer limit) {
        int limit1 = limit != null ? limit : Integer.MAX_VALUE;
        int limit2 = request != null && request.isPreviewRequest() ? request.getPreviewItemCount() : Integer.MAX_VALUE;
        return Math.min(this.pagesizeItems, Math.min(limit1, limit2));
    }

    private <T> Flux<T> loadPageableData(int pageSize, Function<PageLink, Mono<PageData<T>>> fetcher, int limit) {
        PageLink firstLink = new PageLink(pageSize);
        return Mono.zip((Mono)Mono.just((Object)firstLink), fetcher.apply(firstLink)).expand(tuple2 -> {
            PageData pageData = (PageData)tuple2.getT2();
            PageLink pageLink = (PageLink)tuple2.getT1();
            if (pageData.hasNext()) {
                PageLink nextLink = pageLink.nextPageLink();
                return Mono.zip((Mono)Mono.just((Object)nextLink), (Mono)((Mono)fetcher.apply(nextLink)));
            }
            return Mono.empty();
        }).map(Tuple2::getT2).flatMapIterable(PageData::getData).index().takeUntil(tuple -> (Long)tuple.getT1() + 1L == (long)limit).map(Tuple2::getT2).onErrorResume(arg_0 -> this.resumeNotFoundErrorFlux(arg_0));
    }

    private <T> Flux<T> loadQueryPageableData(EntityDataQuery firstQuery, Function<EntityDataQuery, Mono<PageData<T>>> fetcher, int limit) {
        return Mono.zip((Mono)Mono.just((Object)firstQuery), fetcher.apply(firstQuery)).expand(tuple2 -> {
            PageData pageData = (PageData)tuple2.getT2();
            EntityDataQuery query = (EntityDataQuery)tuple2.getT1();
            if (pageData.hasNext()) {
                EntityDataQuery nextQuery = query.next();
                return Mono.zip((Mono)Mono.just((Object)nextQuery), (Mono)((Mono)fetcher.apply(nextQuery)));
            }
            return Mono.empty();
        }).map(Tuple2::getT2).flatMapIterable(PageData::getData).index().takeUntil(tuple -> (Long)tuple.getT1() + 1L == (long)limit).map(Tuple2::getT2).onErrorResume(arg_0 -> this.resumeNotFoundErrorFlux(arg_0));
    }

    private Mono<PageData<Device>> loadDevicesPageV31Filter(ViewContext ctx, EntityDataQuery query, JwtSecurityUser user) {
        return this.loadEntitiesPageV31Filter(ctx, query, user, "loadDevicesPageV31Filter", arg_0 -> ((FilteredEntityDataTransformer)this.entityDataTransformer).entityToDevicePageData(arg_0));
    }

    private Mono<PageData<Asset>> loadAssetsPageV31Filter(ViewContext ctx, EntityDataQuery query, JwtSecurityUser user) {
        return this.loadEntitiesPageV31Filter(ctx, query, user, "loadAssetsPageV31Filter", arg_0 -> ((FilteredEntityDataTransformer)this.entityDataTransformer).entityToAssetPageData(arg_0));
    }

    private Mono<PageData<Customer>> loadCustomersPageV31Filter(ViewContext ctx, EntityDataQuery query, JwtSecurityUser user) {
        return this.loadEntitiesPageV31Filter(ctx, query, user, "loadCustomersPageV31Filter", arg_0 -> ((FilteredEntityDataTransformer)this.entityDataTransformer).entityToCustomerPageData(arg_0));
    }

    private <T> Mono<PageData<T>> loadEntitiesPageV31Filter(ViewContext ctx, EntityDataQuery query, JwtSecurityUser user, String requestName, Function<PageData<EntityData>, PageData<T>> pageDataMapper) {
        return this.tbWebClient.post(new TbWebRequest("/api/entitiesQuery/find", this.priorityFromCtx(ctx), this.authenticationService.getAuthHeaders(user), (Object)query, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, requestName, response)).map(Optional::get).map(pageDataMapper).onErrorResume(arg_0 -> this.resumeNotFoundErrorMono(arg_0));
    }

    private Mono<PageData<Device>> loadDevicesPageV3(ViewContext ctx, PageLink pageLink, JwtSecurityUser user, String deviceType, String textSearch) {
        Map params = this.searchParamsV3x(pageLink, textSearch, deviceType);
        String uri = this.getLoadUri(user, EntityType.DEVICE);
        return this.tbWebClient.get(new TbWebRequest(uri, this.priorityFromCtx(ctx), MultiValueMap.fromSingleValue((Map)params), this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "loadDevicesPageV3", response)).map(Optional::get);
    }

    private Mono<PageData<Asset>> loadAssetsPageV3(ViewContext ctx, PageLink pageLink, JwtSecurityUser user, String assetType, String textSearch) {
        Map params = this.searchParamsV3x(pageLink, textSearch, assetType);
        String uri = this.getLoadUri(user, EntityType.ASSET);
        return this.tbWebClient.get(new TbWebRequest(uri, this.priorityFromCtx(ctx), MultiValueMap.fromSingleValue((Map)params), this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "loadAssetsPageV3", response)).map(Optional::get);
    }

    private Mono<PageData<Customer>> loadCustomersPageV3(ViewContext ctx, PageLink pageLink, JwtSecurityUser user) {
        TbVersion version = this.getTbVersionValidating(user);
        Map params = this.searchParamsV3x(pageLink, null, null);
        String uri = this.getLoadUri(user, EntityType.CUSTOMER);
        if (user != null && user.isCustomerUser() && !version.isPe()) {
            return this.tbWebClient.get(new TbWebRequest(uri, this.priorityFromCtx(ctx), MultiValueMap.fromSingleValue((Map)params), this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "loadCustomersPageV3", response)).map(Optional::get).map(customer -> new PageData(List.of(customer), 1, 1L, false));
        }
        return this.tbWebClient.get(new TbWebRequest(uri, this.priorityFromCtx(ctx), MultiValueMap.fromSingleValue((Map)params), this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "loadCustomersPageV3", response)).map(Optional::get);
    }

    private String getLoadUri(JwtSecurityUser user, EntityType entityType) {
        if (user == null || user.isTenantUser()) {
            return switch (63.$SwitchMap$org$thingsboard$server$common$data$EntityType[entityType.ordinal()]) {
                case 1 -> "/api/tenant/devices";
                case 2 -> "/api/tenant/assets";
                case 3 -> "/api/customers";
                case 4 -> "/api/tenant/dashboards";
                default -> throw new IllegalStateException();
            };
        }
        TbVersion version = this.getTbVersionValidating(user);
        if (version.isPe()) {
            return switch (63.$SwitchMap$org$thingsboard$server$common$data$EntityType[entityType.ordinal()]) {
                case 1 -> "/api/user/devices";
                case 2 -> "/api/user/assets";
                case 3 -> "/api/user/customers";
                case 4 -> "/api/dashboards/all";
                default -> throw new IllegalStateException();
            };
        }
        return switch (63.$SwitchMap$org$thingsboard$server$common$data$EntityType[entityType.ordinal()]) {
            case 1 -> "/api/customer/" + String.valueOf(user.getCustomerId()) + "/devices";
            case 2 -> "/api/customer/" + String.valueOf(user.getCustomerId()) + "/assets";
            case 3 -> "/api/customer/" + String.valueOf(user.getCustomerId());
            case 4 -> "/api/customer/" + String.valueOf(user.getCustomerId()) + "/dashboards";
            default -> throw new IllegalStateException();
        };
    }

    private Map<String, Object> searchParamsV3x(PageLink pageLink, String textSearch, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageSize", pageLink.getPageSize());
        params.put("page", pageLink.getPage());
        params.put("sortProperty", null);
        params.put("sortOrder", null);
        params.put("textSearch", textSearch);
        params.put("type", type);
        return params;
    }

    public Mono<String> loadTenantByApi(JwtSecurityUser user, ViewContext ctx) {
        return this.tbWebClient.get(new TbWebRequest("/api/tenant/" + String.valueOf(user.getTenantId()), this.priorityFromCtx(ctx), this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<String> loadCustomerByApi(JwtSecurityUser user, ViewContext ctx) {
        return this.tbWebClient.get(new TbWebRequest("/api/customer/" + String.valueOf(user.getCustomerId()), this.priorityFromCtx(ctx), this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<String> loadCustomerTitleByApi(JwtSecurityUser user) {
        return this.tbWebClient.get(new TbWebRequest("/api/customer/" + String.valueOf(user.getCustomerId()) + "/title", RequestPriority.HIGH, this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Flux<Device> loadDevicesByIds(ViewContext ctx, Set<UUID> deviceIds, JwtSecurityUser user) {
        return this.loadEntitiesIds(ctx, deviceIds, user, "/api/devices", "deviceIds", "loadDevicesByIds", (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Flux<Asset> loadAssetsByIds(ViewContext ctx, Set<UUID> assetIds, JwtSecurityUser user) {
        return this.loadEntitiesIds(ctx, assetIds, user, "/api/assets", "assetIds", "loadAssetsByIds", (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    private <T> Flux<T> loadEntitiesIds(ViewContext ctx, Set<UUID> ids, JwtSecurityUser user, String uri, String paramName, String requestName, ParameterizedTypeReference<List<T>> type) {
        return Flux.fromIterable((Iterable)Lists.partition(new ArrayList<UUID>(ids), (int)100)).map(HashSet::new).flatMap(idsPartition -> {
            String strIds = idsPartition.stream().map(UUID::toString).collect(Collectors.joining(","));
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(paramName, strIds);
            Mono listMono = this.tbWebClient.get(new TbWebRequest(uri, this.priorityFromCtx(ctx), MultiValueMap.fromSingleValue(params), this.authenticationService.getAuthHeaders(user), type)).map(response -> this.collectMeasurements(ctx, requestName, response)).map(Optional::get);
            return this.collectStats(listMono, requestName);
        }).flatMapIterable(Function.identity());
    }

    public Flux<AttributeData> loadAttribute(JwtSecurityUser user, String entityType, UUID entityId, String scope) {
        return this.loadAttributePartition(user, entityType, entityId, scope, null, Collections.emptySet());
    }

    public Flux<AttributeData> loadAttribute(JwtSecurityUser user, String entityType, UUID entityId, String scope, ViewContext ctx, String key) {
        return this.loadAttributePartition(user, entityType, entityId, scope, ctx, this.keyToSet(key));
    }

    public Flux<AttributeData> loadAttribute(JwtSecurityUser user, String entityType, UUID entityId, String scope, Set<String> keys) {
        Set keyPartitions = this.splitKeysToPartitions(keys);
        return Flux.fromIterable((Iterable)keyPartitions).flatMap(keyPartition -> this.loadAttributePartition(user, entityType, entityId, scope, null, keyPartition));
    }

    public Flux<AttributeData> loadAttributePartition(JwtSecurityUser user, String entityType, UUID entityId, String scope, ViewContext ctx, Set<String> keyPartition) {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        this.addKeysToParams(user, keyPartition, (MultiValueMap)params);
        String uri = scope == null ? "/api/plugins/telemetry/" + entityType + "/" + String.valueOf(entityId) + "/values/attributes" : "/api/plugins/telemetry/" + entityType + "/" + String.valueOf(entityId) + "/values/attributes/" + scope;
        return this.tbWebClient.get(new TbWebRequest(uri, this.priorityFromCtx(ctx), (MultiValueMap)params, this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "loadAttribute_" + String.valueOf(keyPartition), response)).map(Optional::get).flatMapIterable(l -> l);
    }

    public Mono<ItemLite> getLastActiveEntity(BusinessEntity entity, JwtSecurityUser user) {
        BusinessEntityType entityType = entity.getQuery().getEntityType();
        String type = entity.getQuery().getType();
        TbVersion version = this.tbVersionChecker.getVersion(user);
        if (version.getVersion().less(TbVersionNumber.V_3_1_0)) {
            throw new IllegalStateException("Tb Version unknown " + String.valueOf(version));
        }
        if (version.getVersion().inTheInterval(TbVersionNumber.V_3_0_0, TbVersionNumber.V_3_1_0)) {
            Flux itemLiteFlux = switch (63.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$BusinessEntityType[entityType.ordinal()]) {
                case 1 -> this.loadPageableData(1, link -> this.loadAssetsPageV3(null, link, user, type, null), 1).map(asset -> new ItemLite(asset.getUuidId(), asset.getName()));
                case 2 -> this.loadPageableData(1, link -> this.loadDevicesPageV3(null, link, user, type, null), 1).map(device -> new ItemLite(device.getUuidId(), device.getName()));
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(entityType));
            };
            return itemLiteFlux.next();
        }
        EntityDataSortOrder sort = new EntityDataSortOrder(new EntityKey(EntityKeyType.ENTITY_FIELD, "lastActivityTime"), EntityDataSortOrder.Direction.DESC);
        EntityDataPageLink pageLink = new EntityDataPageLink(1, 0, null, sort);
        List<EntityKey> entityKeys = List.of(new EntityKey(EntityKeyType.ENTITY_FIELD, "id"), new EntityKey(EntityKeyType.ENTITY_FIELD, "name"), new EntityKey(EntityKeyType.ENTITY_FIELD, "label"), new EntityKey(EntityKeyType.ENTITY_FIELD, "type"), new EntityKey(EntityKeyType.ENTITY_FIELD, "lastActivityTime"));
        Flux itemLiteFlux = switch (63.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$BusinessEntityType[entityType.ordinal()]) {
            case 1 -> {
                AssetTypeFilter filter = new AssetTypeFilter(type, "");
                EntityDataQuery query = new EntityDataQuery((EntityFilter)filter, pageLink, entityKeys, Collections.emptyList(), Collections.emptyList());
                yield this.loadQueryPageableData(query, q -> this.loadAssetsPageV31Filter(null, q, user), 1).map(asset -> new ItemLite(asset.getUuidId(), asset.getName()));
            }
            case 2 -> {
                AssetTypeFilter filter = new DeviceTypeFilter(type, "");
                EntityDataQuery query = new EntityDataQuery((EntityFilter)filter, pageLink, entityKeys, Collections.emptyList(), Collections.emptyList());
                yield this.loadQueryPageableData(query, q -> this.loadDevicesPageV31Filter(null, q, user), 1).map(device -> new ItemLite(device.getUuidId(), device.getName()));
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(entityType));
        };
        return itemLiteFlux.next();
    }

    public Mono<ItemLite> getLastActiveEntity(JwtSecurityUser user) {
        return Mono.fromCallable(() -> {
            TbVersion version = this.tbVersionChecker.getVersion(user);
            if (version.getVersion().less(TbVersionNumber.V_3_1_0)) {
                throw new IllegalStateException("Tb Version unknown " + String.valueOf(version));
            }
            if (version.getVersion().inTheInterval(TbVersionNumber.V_3_0_0, TbVersionNumber.V_3_1_0)) {
                Mono deviceMono = this.loadPageableData(1, link -> this.loadDevicesPageV3(null, link, user, null, null), 1).next();
                Mono assetMono = this.loadPageableData(1, link -> this.loadAssetsPageV3(null, link, user, null, null), 1).next();
                return Mono.zip((Mono)deviceMono.map(Optional::of).defaultIfEmpty(Optional.empty()), (Mono)assetMono.map(Optional::of).defaultIfEmpty(Optional.empty()));
            }
            EntityDataSortOrder sort = new EntityDataSortOrder(new EntityKey(EntityKeyType.ENTITY_FIELD, "lastActivityTime"), EntityDataSortOrder.Direction.DESC);
            EntityDataPageLink pageLink = new EntityDataPageLink(1, 0, null, sort);
            List<EntityKey> keys = List.of(new EntityKey(EntityKeyType.ENTITY_FIELD, "id"), new EntityKey(EntityKeyType.ENTITY_FIELD, "name"), new EntityKey(EntityKeyType.ENTITY_FIELD, "label"), new EntityKey(EntityKeyType.ENTITY_FIELD, "type"), new EntityKey(EntityKeyType.ENTITY_FIELD, "lastActivityTime"));
            EntityTypeFilter filterAsset = new EntityTypeFilter(EntityType.ASSET);
            EntityTypeFilter filterDevice = new EntityTypeFilter(EntityType.DEVICE);
            EntityDataQuery queryAssets = new EntityDataQuery((EntityFilter)filterAsset, pageLink, keys, List.of(), List.of());
            EntityDataQuery queryDevice = new EntityDataQuery((EntityFilter)filterDevice, pageLink, keys, List.of(), List.of());
            Mono deviceMono = this.loadQueryPageableData(queryDevice, q -> this.loadDevicesPageV31Filter(null, q, user), 1).next();
            Mono assetMono = this.loadQueryPageableData(queryAssets, q -> this.loadAssetsPageV31Filter(null, q, user), 1).next();
            return Mono.zip((Mono)deviceMono.map(Optional::of).defaultIfEmpty(Optional.empty()), (Mono)assetMono.map(Optional::of).defaultIfEmpty(Optional.empty()));
        }).flatMap(Function.identity()).map(tuple2 -> {
            Optional deviceOptional = (Optional)tuple2.getT1();
            Optional assetOptional = (Optional)tuple2.getT2();
            if (deviceOptional.isEmpty() && assetOptional.isEmpty()) {
                return new ItemLite();
            }
            if (deviceOptional.isEmpty()) {
                EnhancedAsset asset = (EnhancedAsset)assetOptional.get();
                return new ItemLite(asset.getUuidId(), asset.getName());
            }
            if (assetOptional.isEmpty()) {
                EnhancedDevice device = (EnhancedDevice)deviceOptional.get();
                return new ItemLite(device.getUuidId(), device.getName());
            }
            EnhancedAsset asset = (EnhancedAsset)assetOptional.get();
            EnhancedDevice device = (EnhancedDevice)deviceOptional.get();
            TsValue assetPoint = (TsValue)asset.getAttributes().get("lastActivityTime");
            TsValue devicePoint = (TsValue)device.getAttributes().get("lastActivityTime");
            if (assetPoint == null && devicePoint == null) {
                throw new IllegalStateException("Asset or Device attributes are missing");
            }
            if (assetPoint == null) {
                return new ItemLite(device.getUuidId(), device.getName());
            }
            if (devicePoint == null) {
                return new ItemLite(asset.getUuidId(), asset.getName());
            }
            if (assetPoint.getTs() < devicePoint.getTs()) {
                return new ItemLite(device.getUuidId(), device.getName());
            }
            return new ItemLite(asset.getUuidId(), asset.getName());
        });
    }

    public Mono<Map<String, List<TsData>>> loadTelemetry(JwtSecurityUser user, BusinessEntityType entityType, UUID entityId, String key, long startTs, long endTs) {
        return this.loadTelemetry(user, entityType, entityId, Set.of(key), startTs, endTs);
    }

    public Mono<Map<String, List<TsData>>> loadTelemetry(JwtSecurityUser user, BusinessEntityType entityType, UUID entityId, String key, long startTs, long endTs, String order, int limit) {
        return this.loadTelemetry(user, entityType, entityId, Set.of(key), startTs, endTs, order, limit);
    }

    public Mono<Map<String, List<TsData>>> loadTelemetry(JwtSecurityUser user, BusinessEntityType entityType, UUID entityId, String key, long startTs, long endTs, long interval, String agg, ViewContext ctx) {
        return this.loadTelemetry(user, entityType, entityId, Set.of(key), startTs, endTs, interval, agg, ctx);
    }

    public Mono<Map<String, List<TsData>>> loadTelemetry(JwtSecurityUser user, BusinessEntityType entityType, UUID entityId, Set<String> keys, long startTs, long endTs) {
        return this.loadTelemetry(user, entityType, entityId, keys, startTs, endTs, 0L, "NONE", "ASC", this.pagesizeTelemetry, null);
    }

    public Mono<Map<String, List<TsData>>> loadTelemetry(JwtSecurityUser user, BusinessEntityType entityType, UUID entityId, Set<String> keys, long startTs, long endTs, String order, int limit) {
        return this.loadTelemetry(user, entityType, entityId, keys, startTs, endTs, 0L, "NONE", order, limit, null);
    }

    public Mono<Map<String, List<TsData>>> loadTelemetry(JwtSecurityUser user, BusinessEntityType entityType, UUID entityId, Set<String> keys, long startTs, long endTs, long interval, String agg, ViewContext ctx) {
        return this.loadTelemetry(user, entityType, entityId, keys, startTs, endTs, interval, agg, "ASC", this.pagesizeTelemetry, ctx);
    }

    public Mono<Map<String, List<TsData>>> loadTelemetry(JwtSecurityUser user, BusinessEntityType entityType, UUID entityId, Set<String> keys, long startTs, long endTs, long interval, String agg, String order, int limit, ViewContext ctx) {
        Set keyPartitions = this.splitKeysToPartitions(keys);
        return Flux.fromIterable((Iterable)keyPartitions).flatMap(keyPartition -> this.splitTelemetryLoad(user, entityType, entityId, keyPartition, startTs, endTs, interval, agg, order, limit, ctx)).flatMapIterable(Map::entrySet).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> {
            log.warn("Duplicate telemetry keys after partition determinations: {}", (Object)keyPartitions);
            return e1;
        }));
    }

    private Mono<Map<String, List<TsData>>> splitTelemetryLoad(JwtSecurityUser user, BusinessEntityType entityType, UUID entityId, Set<String> keyPartition, long startTs, long endTs, long interval, String agg, String order, int limit, ViewContext ctx) {
        return this.loadTelemetryPartition(user, entityType, entityId, keyPartition, startTs, endTs, interval, agg, order, limit, ctx).flatMapIterable(Map::entrySet).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> {
            log.warn("Duplicate telemetry keys for partition: {}", (Object)keyPartition);
            return e1;
        }));
    }

    private Mono<Map<String, List<TsData>>> loadTelemetryPartition(JwtSecurityUser user, BusinessEntityType entityType, UUID entityId, Set<String> keyPartition, long startTs, long endTs, long interval, String agg, String order, int limit, ViewContext ctx) {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        this.addKeysToParams(user, keyPartition, (MultiValueMap)params);
        params.add((Object)"startTs", (Object)startTs);
        params.add((Object)"endTs", (Object)endTs);
        params.add((Object)"interval", (Object)interval);
        params.add((Object)"agg", (Object)agg);
        params.add((Object)"orderBy", (Object)order);
        params.add((Object)"limit", (Object)limit);
        String uri = "/api/plugins/telemetry/" + String.valueOf(entityType) + "/" + String.valueOf(entityId) + "/values/timeseries";
        Mono loadTelemetryMono = this.tbWebClient.get(new TbWebRequest(uri, this.priorityFromCtx(ctx), (MultiValueMap)params, this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "loadTelemetry_" + String.valueOf(keyPartition), response)).map(Optional::get);
        Supplier<Mono> loadTelemetrySupplier = () -> this.collectStats(loadTelemetryMono, "loadTelemetry_");
        String cacheKey = StringUtils.join((Object[])new Serializable[]{entityType, entityId, keyPartition.toString(), Long.valueOf(startTs), Long.valueOf(endTs), Long.valueOf(interval), agg});
        return this.webClientCachier.getOrFetchTelemetry(cacheKey, user, loadTelemetrySupplier).doOnNext(telemetry -> this.gatherLoadTelemetryStatistics(ctx, telemetry));
    }

    public Mono<Map<String, List<TsData>>> loadLatestTelemetry(JwtSecurityUser user, BusinessEntityType entityType, UUID entityId, Set<String> keys, ViewContext ctx) {
        Set keyPartitions = this.splitKeysToPartitions(keys);
        return Flux.fromIterable((Iterable)keyPartitions).flatMap(key -> this.loadLatestTelemetryPartition(user, entityType, entityId, key, ctx)).flatMapIterable(Map::entrySet).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> {
            log.warn("[Latest telemetry] Duplicate telemetry keys after partition determinations: {}", (Object)keyPartitions);
            return e1;
        }));
    }

    public Mono<Map<String, List<TsData>>> loadLatestTelemetry(JwtSecurityUser user, BusinessEntityType entityType, UUID entityId, String key, ViewContext ctx) {
        return this.loadLatestTelemetryPartition(user, entityType, entityId, this.keyToSet(key), ctx);
    }

    private Mono<Map<String, List<TsData>>> loadLatestTelemetryPartition(JwtSecurityUser user, BusinessEntityType entityType, UUID entityId, Set<String> keyPartition, ViewContext ctx) {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        this.addKeysToParams(user, keyPartition, (MultiValueMap)params);
        String uri = "/api/plugins/telemetry/" + String.valueOf(entityType) + "/" + String.valueOf(entityId) + "/values/timeseries";
        return this.tbWebClient.get(new TbWebRequest(uri, this.priorityFromCtx(ctx), (MultiValueMap)params, this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "loadLatestTelemetry_" + String.valueOf(keyPartition), response)).map(Optional::get);
    }

    public Mono<Boolean> sendTelemetryDirectly(ViewContext ctx, String entityType, UUID entityId, JwtSecurityUser user, List<TbDataEntry> telemetryRequest) {
        long now = System.currentTimeMillis();
        log.debug("Preparing to send telemetry directly with size: {}, ts as id = {}", (Object)telemetryRequest.size(), (Object)now);
        telemetryRequest.sort(Comparator.comparing(TbDataEntry::getTs));
        this.validateSendingTelemetry(telemetryRequest);
        int tsRecords = telemetryRequest.size();
        int keyValuePairs = telemetryRequest.stream().mapToInt(r -> r.getValues().size()).sum();
        log.info("Save TB telemetry for {} tsSize {} keyValuePairs {}", new Object[]{entityId, tsRecords, keyValuePairs});
        String uri = "/api/plugins/telemetry/" + entityType + "/" + String.valueOf(entityId) + "/timeseries/ANY";
        List telemetries = this.splitSendTelemetryRequest(telemetryRequest);
        return Flux.fromIterable((Iterable)telemetries).concatMap(telemetry -> Mono.just((Object)telemetry).flatMap(part -> {
            log.debug("Sending telemetry directly, PART with size: {}", (Object)part.size());
            return this.tbWebClient.post(new TbWebRequest(uri, this.priorityFromCtx(ctx), this.authenticationService.getAuthHeaders(user), telemetry, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */));
        }).map(response -> this.collectMeasurements(ctx, "sendTelemetryDirectly", response)).delayElement(Duration.ofMillis(this.sendTelemetryIntervalMs), Schedulers.boundedElastic()).publishOn(Schedulers.fromExecutorService((ExecutorService)this.executorManagementService.getExecutorByName(ExecutorName.UI_POST_BUILD)))).collect(Collectors.reducing((a, b) -> Optional.of(a.orElse(Boolean.FALSE) != false && b.orElse(Boolean.FALSE) != false))).map(aBoolean -> {
            log.info("Received directly sent telemetry response, ts as id: {}", (Object)now);
            return (Optional)aBoolean.get();
        }).map(Optional::get);
    }

    public Mono<List<TbWidgetBundleItemV1>> loadAllWidgetBundlesV1(JwtSecurityUser user) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sortProperty", "title");
        params.put("sortOrder", "ASC");
        return this.tbWebClient.get(new TbWebRequest("/api/widgetsBundles", RequestPriority.HIGH, MultiValueMap.fromSingleValue(params), this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<List<TbWidgetBundleItemV2>> loadAllWidgetBundlesV2(JwtSecurityUser user) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sortProperty", "title");
        params.put("sortOrder", "ASC");
        return this.tbWebClient.get(new TbWebRequest("/api/widgetsBundles", RequestPriority.HIGH, MultiValueMap.fromSingleValue(params), this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<List<TbWidgetTypeItemV1>> loadWidgetTypesV1(String bundleAlias, boolean isSystem, JwtSecurityUser user) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("isSystem", isSystem);
        params.put("bundleAlias", bundleAlias);
        return this.tbWebClient.get(new TbWebRequest("/api/widgetTypes", RequestPriority.HIGH, MultiValueMap.fromSingleValue(params), this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<Optional<TbWidgetTypeItemV2>> loadWidgetTypeLiteByFqnV2(String fqn, JwtSecurityUser user) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fqn", fqn);
        TbWebRequest request = new TbWebRequest("/api/widgetType", RequestPriority.HIGH, MultiValueMap.fromSingleValue(params), this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).suppressNotFoundError();
        return this.tbWebClient.get(request).map(TbWebResponse::getResponse);
    }

    public Mono<TbWidgetTypeItemV2> loadWidgetTypeFullByIdV2(UUID id, JwtSecurityUser user) {
        return this.tbWebClient.get(new TbWebRequest("/api/widgetType/" + String.valueOf(id), RequestPriority.HIGH, this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<Set<String>> loadWidgetTypeFqnsByBundleIdV2(UUID widgetsBundleId, JwtSecurityUser user) {
        HashMap<String, UUID> params = new HashMap<String, UUID>();
        params.put("widgetsBundleId", widgetsBundleId);
        return this.tbWebClient.get(new TbWebRequest("/api/widgetTypeFqns", RequestPriority.HIGH, MultiValueMap.fromSingleValue(params), this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<List<TbWidgetTypeItemV2>> loadWidgetTypeInfos(UUID widgetsBundleId, JwtSecurityUser user) {
        HashMap<String, Comparable<UUID>> params = new HashMap<String, Comparable<UUID>>();
        params.put("widgetsBundleId", widgetsBundleId);
        params.put("page", Integer.valueOf(0));
        params.put("pageSize", Integer.valueOf(100000));
        return this.tbWebClient.get(new TbWebRequest("/api/widgetTypesInfos", RequestPriority.HIGH, MultiValueMap.fromSingleValue(params), this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get).map(PageData::getData);
    }

    public Mono<TbWidgetBundleItemV1> uploadWidgetBundleV1(TbWidgetBundleItemV1 widgetBundle, JwtSecurityUser user) {
        return this.tbWebClient.post(new TbWebRequest("/api/widgetsBundle", RequestPriority.HIGH, this.authenticationService.getAuthHeaders(user), (Object)widgetBundle, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<TbWidgetBundleItemV2> uploadWidgetBundleV2(TbWidgetBundleItemV2 widgetBundle, JwtSecurityUser user) {
        return this.tbWebClient.post(new TbWebRequest("/api/widgetsBundle", RequestPriority.HIGH, this.authenticationService.getAuthHeaders(user), (Object)widgetBundle, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<TbWidgetTypeItemV1> uploadWidgetTypeV1(TbWidgetTypeItemV1 widgetType, JwtSecurityUser user) {
        return this.tbWebClient.post(new TbWebRequest("/api/widgetType", RequestPriority.HIGH, this.authenticationService.getAuthHeaders(user), (Object)widgetType, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<TbWidgetTypeItemV2> uploadWidgetTypeV2(TbWidgetTypeItemV2 widgetType, JwtSecurityUser user) {
        return this.tbWebClient.post(new TbWebRequest("/api/widgetType", RequestPriority.HIGH, this.authenticationService.getAuthHeaders(user), (Object)widgetType, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<Boolean> uploadWidgetBundleJoinsToTypes(UUID widgetBundleId, Set<UUID> widgetTypeIdset, JwtSecurityUser user) {
        String url = "/api/widgetsBundle/" + String.valueOf(widgetBundleId) + "/widgetTypes";
        return this.tbWebClient.post(new TbWebRequest(url, RequestPriority.HIGH, this.authenticationService.getAuthHeaders(user), widgetTypeIdset, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<PageData<Dashboard>> loadAllDashboards(JwtSecurityUser user) {
        HashMap<String, Constable> params = new HashMap<String, Constable>();
        params.put("pageSize", Integer.valueOf(1000));
        params.put("page", Integer.valueOf(0));
        params.put("includeCustomers", Boolean.valueOf(true));
        String uri = this.getLoadUri(user, EntityType.DASHBOARD);
        return this.tbWebClient.get(new TbWebRequest(uri, RequestPriority.HIGH, MultiValueMap.fromSingleValue(params), this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<Dashboard> loadDashboardById(UUID dashboardId, JwtSecurityUser user) {
        String uri = "/api/dashboard/" + dashboardId.toString();
        return this.tbWebClient.get(new TbWebRequest(uri, RequestPriority.HIGH, this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<Dashboard> saveDashboard(Dashboard dashboard, JwtSecurityUser user) {
        HttpHeaders httpHeaders = this.authenticationService.getAuthHeaders(user);
        httpHeaders.add("Content-Type", MediaType.APPLICATION_JSON.toString());
        return this.tbWebClient.post(new TbWebRequest("/api/dashboard", RequestPriority.HIGH, httpHeaders, (Object)dashboard, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<String> loadAlarms(ViewContext ctx, BusinessEntityType entityType, UUID entityId, JwtSecurityUser user, long startTs, long endTs, int limit) {
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("startTime", startTs);
        params.put("endTime", endTs);
        String uri = "/api/alarm/" + String.valueOf(entityType) + "/" + String.valueOf(entityId);
        params.put("page", 0);
        params.put("pageSize", limit);
        return this.tbWebClient.get(new TbWebRequest(uri, this.priorityFromCtx(ctx), MultiValueMap.fromSingleValue(params), this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(response -> this.collectMeasurements(ctx, "loadAlarms", response)).map(Optional::get);
    }

    public Mono<Optional<WhiteLabelingParams>> loadCurrentWhiteLabelParams(JwtSecurityUser user) {
        String uri = "/api/whiteLabel/currentWhiteLabelParams";
        return this.tbWebClient.get(new TbWebRequest(uri, RequestPriority.HIGH, this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse);
    }

    public Mono<JwtSettings> fetchSigningKeyWithSysadminToken(String jwtToken) {
        String uri = "/api/admin/jwtSettings";
        return this.tbWebClient.get(new TbWebRequest(uri, RequestPriority.HIGH, this.authenticationService.getJwtHeader(jwtToken), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public TbVersion getTbVersionValidating(JwtSecurityUser user) {
        TbVersion version = this.tbVersionChecker.getVersion(user);
        if (version.getVersion().less(TbVersionNumber.V_3_0_0)) {
            throw new IllegalStateException("Thingsboard versions < 3.0.0 not supported but got version: " + String.valueOf(version));
        }
        return version;
    }

    public <T> T forwardRequest(TbWebRequest<T> tbRequest, String method) {
        return (T)DonReactive.block((Mono)this.tbWebClient.method(tbRequest, method).map(TbWebResponse::getResponse).map(Optional::get));
    }

    public Mono<String> loadTranslationBeforeLogin(String locale) {
        return this.getTranslationsForTBBeforeLogin(true, locale).map(TbWebResponse::getResponse).map(Optional::get).onErrorResume(throwable -> {
            log.debug("Could not get translations (before login) for ThingsBoard PE", throwable);
            if (throwable.getCause() instanceof WebClientResponseException) {
                return this.getTranslationsForTBBeforeLogin(false, locale).map(TbWebResponse::getResponse).map(Optional::get).onErrorResume(e -> {
                    log.debug("Could not get translations (before login) for ThingsBoard CE", throwable);
                    return Mono.error((Throwable)throwable);
                });
            }
            return Mono.error((Throwable)throwable);
        });
    }

    public Mono<List<String>> loadTranslationsAfterLogin(String locale, JwtSecurityUser user) {
        TbVersion version = this.tbVersionChecker.getVersion(user);
        if (version.getVersion().less(TbVersionNumber.V_3_7_0)) {
            return this.getTranslationsForTBAfterLoginBeforeVersion_3_7_0_PE(locale, user).onErrorResume(throwable -> {
                log.debug("Could not get translations (after login) for ThingsBoard PE for version less than 3.7.0", throwable);
                if (throwable.getCause() instanceof WebClientResponseException) {
                    return this.getTranslationsForTBAfterLogin(false, locale, user).map(TbWebResponse::getResponse).map(Optional::get).map(List::of).onErrorResume(e -> {
                        log.debug("Could not get translations (after login) for ThingsBoard CE for version less than 3.7.0", throwable);
                        return Mono.error((Throwable)throwable);
                    });
                }
                return Mono.error((Throwable)throwable);
            });
        }
        return this.getTranslationsForTBAfterLogin(true, locale, user).map(TbWebResponse::getResponse).map(Optional::get).map(List::of).onErrorResume(throwable -> {
            log.debug("Could not get translations (after login) for ThingsBoard PE", throwable);
            if (throwable.getCause() instanceof WebClientResponseException) {
                return this.getTranslationsForTBAfterLogin(false, locale, user).map(TbWebResponse::getResponse).map(Optional::get).map(List::of).onErrorResume(e -> {
                    log.debug("Could not get translations (after login) for ThingsBoard CE", throwable);
                    return Mono.error((Throwable)throwable);
                });
            }
            return Mono.error((Throwable)throwable);
        });
    }

    public Mono<Optional<TbResource>> getResourceByName(JwtSecurityUser user, String name, boolean isSystem) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageSize", 10);
        params.put("page", 0);
        params.put("sortProperty", "createdTime");
        params.put("sortOrder", "DESC");
        params.put("textSearch", name);
        params.put("resourceType", ResourceType.JS_MODULE);
        String tbApiEndpoint = "/api/resource";
        51 parameterizedTypeReference = new /* Unavailable Anonymous Inner Class!! */;
        TbWebRequest tbModulesRequest = new TbWebRequest(tbApiEndpoint, RequestPriority.HIGH, MultiValueMap.fromSingleValue(params), this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)parameterizedTypeReference);
        return this.tbWebClient.get(tbModulesRequest).map(TbWebResponse::getResponse).flatMap(resourceInfoList -> resourceInfoList.map(PageData::getData).stream().flatMap(Collection::stream).filter(tbResourceInfo -> name.equals(tbResourceInfo.getName())).filter(tbResourceInfo -> "ai-summary-module.js".equals(tbResourceInfo.getFileName())).filter(tbResourceInfo -> !isSystem || tbResourceInfo.getTenantId().isNullUid()).findAny().map(TbResourceInfo::getId).map(EntityId::getId).map(moduleId -> this.getTbResource(user, moduleId)).orElse(Mono.empty())).defaultIfEmpty(Optional.empty());
    }

    public Mono<Optional<TbResource>> getTbResource(JwtSecurityUser user, UUID resourceId) {
        String tbApiEndpoint = "/api/resource/%s".formatted(resourceId);
        52 parameterizedTypeReference = new /* Unavailable Anonymous Inner Class!! */;
        TbWebRequest tbModulesRequest = new TbWebRequest(tbApiEndpoint, RequestPriority.HIGH, this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)parameterizedTypeReference).suppressNotFoundError();
        return this.tbWebClient.get(tbModulesRequest).map(TbWebResponse::getResponse);
    }

    public Mono<TbResource> uploadTbResource(JwtSecurityUser user, TbResource tbResource) {
        String tbApiEndpoint = "/api/resource";
        return this.tbWebClient.post(new TbWebRequest(tbApiEndpoint, RequestPriority.HIGH, this.authenticationService.getAuthHeaders(user), (Object)tbResource, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<AlarmInfo> clearTbAlarm(UUID alarmId, JwtSecurityUser user) {
        String tbEndpoint = "/api/alarm/" + String.valueOf(alarmId) + "/clear";
        return this.tbWebClient.post(new TbWebRequest(tbEndpoint, null, this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<Alarm> retrieveTbAlarm(UUID alarmId, JwtSecurityUser user) {
        String tbEndpoint = "/api/alarm/" + String.valueOf(alarmId);
        return this.tbWebClient.get(new TbWebRequest(tbEndpoint, null, this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<Alarm> saveTbAlarm(Alarm alarm, JwtSecurityUser user) {
        String tbEndpoint = "/api/alarm";
        return this.tbWebClient.post(new TbWebRequest(tbEndpoint, null, this.authenticationService.getAuthHeaders(user), (Object)alarm, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    public Mono<Boolean> deleteTbAlarm(UUID alarmId, JwtSecurityUser user) {
        String tbEndpoint = "/api/alarm/" + String.valueOf(alarmId);
        return this.tbWebClient.delete(new TbWebRequest(tbEndpoint, null, this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)).map(TbWebResponse::getResponse).map(Optional::get);
    }

    private void gatherLoadTelemetryStatistics(ViewContext ctx, Map<String, List<TsData>> telemetry) {
        if (ctx == null) {
            return;
        }
        long telemetryPointsCount = telemetry.values().stream().mapToLong(List::size).sum();
        ctx.getTbTelemetryRequestCount().addAndGet(1L);
        ctx.getTelemetryPointsCount().addAndGet(telemetryPointsCount);
    }

    private Mono<PageData<Item>> loadRawEntityData(ViewContext ctx, EntityDataQuery query, JwtSecurityUser user) {
        String key = String.valueOf(query);
        String requestName = "loadRawEntityData";
        Mono itemsMono = this.loadEntitiesPageV31Filter(ctx, query, user, requestName, arg_0 -> ((FilteredEntityDataTransformer)this.entityDataTransformer).entityToItemPageData(arg_0));
        Supplier<Flux> userEntitiesV31FilterSupplier = () -> this.collectStats(itemsMono, requestName).flatMapIterable(Collections::singletonList);
        return this.webClientCachier.getOrFetch("loadRawEntityData", key, user, userEntitiesV31FilterSupplier, (TypeReference)new /* Unavailable Anonymous Inner Class!! */).next();
    }

    private <T> Optional<T> collectMeasurements(ViewContext ctx, String requestName, TbWebResponse<T> response) {
        if (ctx != null) {
            TbWebRequestExecutionInfo executionInfo = response.getExecutionInfo();
            ctx.getMeasurementReport().getMeasurements().add(new MeasurementInfo(MeasuredTaskType.TB_REST_REQUEST, MeasurementParameters.builder().requestName(requestName).build(), executionInfo.getSchedulingTs(), executionInfo.getStartTs(), executionInfo.getEndTs()));
        }
        return response.getResponse();
    }

    private Mono<TbWebResponse<String>> getTranslationsForTBBeforeLogin(boolean isPe, String locale) {
        String tbPeApiEndpoint = "/api/noauth/translation/login/%s".formatted(locale);
        String tbCeApiEndpoint = "/assets/locale/locale.constant-%s.json".formatted(locale);
        String uri = isPe ? tbPeApiEndpoint : tbCeApiEndpoint;
        return this.tbWebClient.get(new TbWebRequest(uri, RequestPriority.HIGH, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */));
    }

    private Mono<TbWebResponse<String>> getTranslationsForTBAfterLogin(boolean isPe, String locale, JwtSecurityUser user) {
        String tbPeApiEndpoint = "/api/translation/full/%s".formatted(locale);
        String tbCeApiEndpoint = "/assets/locale/locale.constant-%s.json".formatted(locale);
        String uri = isPe ? tbPeApiEndpoint : tbCeApiEndpoint;
        return this.tbWebClient.get(new TbWebRequest(uri, RequestPriority.HIGH, this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */));
    }

    private Mono<List<String>> getTranslationsForTBAfterLoginBeforeVersion_3_7_0_PE(String locale, JwtSecurityUser user) {
        String defaultTranslationEndpoint = "/api/customTranslation/customTranslation";
        String customTranslationEndpoint = "/assets/locale/locale.constant-%s.json".formatted(locale);
        return Flux.concat((Publisher[])new Publisher[]{this.tbWebClient.get(new TbWebRequest("/api/customTranslation/customTranslation", RequestPriority.HIGH, this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */)), this.tbWebClient.get(new TbWebRequest(customTranslationEndpoint, RequestPriority.HIGH, this.authenticationService.getAuthHeaders(user), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */))}).map(TbWebResponse::getResponse).map(Optional::get).collectList();
    }

    private List<List<TbDataEntry>> splitSendTelemetryRequest(List<TbDataEntry> request) {
        if (this.sendTelemetryBatchSize < request.size()) {
            log.debug("Splitting request with [{}] body points ", (Object)request.size());
            return Lists.partition(request, (int)this.sendTelemetryBatchSize);
        }
        log.debug("Single request with [{}] body points", (Object)request.size());
        return List.of(request);
    }

    private Set<Set<String>> splitKeysToPartitions(Set<String> keys) {
        return this.splitKeysToPartitions(keys, 3072);
    }

    private Set<Set<String>> splitKeysToPartitions(Set<String> keys, int limit) {
        if (keys == null) {
            throw new IllegalArgumentException("Telemetry load error: null list provided");
        }
        if (keys.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Set<String>> result = new HashSet<Set<String>>();
        HashSet<String> currentBatch = new HashSet<String>();
        int currentBatchLength = 0;
        for (String key : keys) {
            int spaceNeeded;
            if (key == null) {
                throw new IllegalArgumentException("Telemetry load error: null value present");
            }
            if (key.isBlank()) {
                throw new IllegalArgumentException("Telemetry load error: blank value present");
            }
            int keyLen = key.length();
            if (keyLen > limit) {
                throw new IllegalArgumentException("Key is too long: " + key);
            }
            int n = spaceNeeded = currentBatch.isEmpty() ? 0 : "&key=".length();
            if (currentBatchLength + spaceNeeded + keyLen > limit) {
                result.add(currentBatch);
                currentBatch = new HashSet();
                currentBatchLength = 0;
                spaceNeeded = 0;
            }
            currentBatch.add(key);
            currentBatchLength += spaceNeeded + keyLen;
        }
        result.add(currentBatch);
        return result;
    }

    private Set<String> keyToSet(String key) {
        return key == null ? Collections.emptySet() : Set.of(key);
    }

    private void addKeysToParams(JwtSecurityUser user, Set<String> keyPartition, MultiValueMap<String, Object> params) {
        TbVersion tbVersion = this.tbVersionChecker.getVersion(user);
        boolean isNewApi = tbVersion.getVersion().greaterOrEqual(TbVersionNumber.V_4_3_0);
        if (isNewApi) {
            params.add((Object)"keys", (Object)"");
            if (!keyPartition.isEmpty()) {
                params.put((Object)"key", keyPartition.stream().map(k -> k).toList());
            }
            return;
        }
        String keys = keyPartition.stream().filter(k -> !k.contains(",")).collect(Collectors.joining(","));
        params.add((Object)"keys", (Object)keys);
    }

    private void validateSendingTelemetry(List<TbDataEntry> telemetryRequest) {
        if (telemetryRequest.isEmpty()) {
            throw new IllegalArgumentException("Empty telemetry request");
        }
        Set duplicatedTimestamps = telemetryRequest.stream().collect(Collectors.groupingBy(TbDataEntry::getTs, Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (!duplicatedTimestamps.isEmpty()) {
            throw new TrendzException("Telemetry request contains duplicated timestamps: " + String.valueOf(duplicatedTimestamps));
        }
    }

    private RequestPriority priorityFromCtx(ViewContext ctx) {
        return ctx == null ? null : ctx.getPriority();
    }

    private <T> Flux<T> resumeNotFoundErrorFlux(Throwable throwable) {
        HttpClientErrorException exception;
        if (throwable instanceof HttpClientErrorException && (exception = (HttpClientErrorException)throwable).getStatusCode() == HttpStatus.NOT_FOUND) {
            return Flux.empty();
        }
        return Flux.error((Throwable)throwable);
    }

    private <T> Mono<T> resumeNotFoundErrorMono(Throwable throwable) {
        HttpClientErrorException exception;
        if (throwable instanceof HttpClientErrorException && (exception = (HttpClientErrorException)throwable).getStatusCode() == HttpStatus.NOT_FOUND) {
            return Mono.empty();
        }
        return Mono.error((Throwable)throwable);
    }

    private <T> Flux<T> collectStats(Flux<T> action, String statsName) {
        return Mono.fromCallable(System::currentTimeMillis).flatMapMany(exchangeStartTs -> action.collectList().doOnNext(l -> this.statsCollector.tick(statsName, exchangeStartTs.longValue(), System.currentTimeMillis(), TickType.OTHER)).flatMapIterable(Function.identity()));
    }

    private <T> Mono<T> collectStats(Mono<T> action, String statsName) {
        return Mono.fromCallable(System::currentTimeMillis).flatMap(exchangeStartTs -> action.doOnNext(l -> this.statsCollector.tick(statsName, exchangeStartTs.longValue(), System.currentTimeMillis(), TickType.OTHER)));
    }
}

