/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityQuery;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.relation.Relation;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.measurement.Measurable;
import org.thingsboard.trendz.domain.measurement.MeasuredTaskType;
import org.thingsboard.trendz.domain.runtime.EnhancedItemLite;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.provider.TbAssetService;
import org.thingsboard.trendz.service.provider.TbCustomerService;
import org.thingsboard.trendz.service.provider.TbDeviceService;
import org.thingsboard.trendz.service.provider.TbItemService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.view.ItemService;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class TbItemService
implements ItemService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbItemService.class);
    private final TbAssetService assetService;
    private final TbDeviceService deviceService;
    private final TbCustomerService customerService;
    private final TbRestDataSource tbClient;
    private final BusinessEntityService businessEntityService;

    @Autowired
    public TbItemService(TbAssetService assetService, TbDeviceService deviceService, TbCustomerService customerService, TbRestDataSource tbClient, BusinessEntityService businessEntityService) {
        this.assetService = assetService;
        this.deviceService = deviceService;
        this.customerService = customerService;
        this.tbClient = tbClient;
        this.businessEntityService = businessEntityService;
    }

    public Flux<EnhancedItemLite> loadItems(String textSearch, JwtSecurityUser user, Integer limit) {
        Map sourceMap = this.businessEntityService.getAllEntities(user).stream().collect(Collectors.groupingBy(b -> b.getQuery().getEntityType(), Collectors.toMap(b -> b.getQuery().getType(), Function.identity())));
        return Flux.merge((Publisher[])new Publisher[]{this.assetService.loadAssets(null, null, null, user, textSearch, limit).flatMap(item -> Mono.justOrEmpty((Object)this.toEnhancedItemLite(sourceMap, BusinessEntityType.ASSET, item))), this.deviceService.loadDevices(null, null, null, user, textSearch, limit).flatMap(item -> Mono.justOrEmpty((Object)this.toEnhancedItemLite(sourceMap, BusinessEntityType.DEVICE, item)))});
    }

    public Mono<Item> loadItem(BusinessEntity businessEntity, UUID itemId, JwtSecurityUser user) {
        return this.loadItems(businessEntity, Set.of(itemId), user).next();
    }

    public Flux<Item> loadItems(BusinessEntity businessEntity, Set<UUID> itemIds, JwtSecurityUser user) {
        if (itemIds == null || itemIds.isEmpty()) {
            return this.loadItems(businessEntity, null, null, null, user);
        }
        return Mono.just((Object)businessEntity.getQuery().getEntityType()).flatMapMany(entityType -> switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$BusinessEntityType[entityType.ordinal()]) {
            case 1 -> this.assetService.loadAssetsById(businessEntity, user, itemIds);
            case 2 -> this.deviceService.loadDevicesById(businessEntity, user, itemIds);
            default -> throw new IllegalStateException("Unexpected BusinessEntityType [" + String.valueOf(entityType) + "]");
        });
    }

    public Flux<Item> loadItems(UUID businessEntityId, Set<ItemLite> itemLites, JwtSecurityUser user) {
        BusinessEntity businessEntity = this.businessEntityService.findEntityById(user, businessEntityId);
        Set itemUuids = itemLites == null ? Collections.emptySet() : itemLites.stream().map(ItemLite::getId).collect(Collectors.toSet());
        return this.loadItems(businessEntity, itemUuids, user);
    }

    @Measurable(context="#ctx", type=MeasuredTaskType.ITEM_SERVICE_LOAD_ITEMS, businessEntityId="#businessEntity.id", viewFieldName="#viewField.label", viewFieldAggregation="#viewField.aggregationType")
    public Flux<Item> loadItems(BusinessEntity businessEntity, ViewField viewField, ViewRequest request, ViewContext ctx, JwtSecurityUser user) {
        return Mono.just((Object)businessEntity.getQuery().getEntityType()).flatMapMany(entityType -> switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$BusinessEntityType[entityType.ordinal()]) {
            case 1 -> this.assetService.loadAssets(businessEntity, request, ctx, user, null, null);
            case 2 -> this.deviceService.loadDevices(businessEntity, request, ctx, user, null, null);
            case 3 -> this.customerService.loadCustomers(businessEntity, request, ctx, user);
            default -> throw new IllegalStateException("Unexpected BusinessEntityType [" + String.valueOf(entityType) + "]");
        }).doOnNext(item -> {
            if (ctx != null) {
                ctx.registerItem(item);
            }
        });
    }

    @Measurable(context="#ctx", type=MeasuredTaskType.ITEM_SERVICE_LOAD_RELATED, businessEntityId="#childBusinessEntityId", viewFieldName="#viewField.label", viewFieldAggregation="#viewField.aggregationType")
    public Flux<Item> loadRelated(ViewContext ctx, ViewField viewField, ViewRequest request, Set<Item> parentItems, UUID parentBusinessEntityId, UUID childBusinessEntityId, JwtSecurityUser user) {
        BusinessEntity parent = (BusinessEntity)ctx.getBusinessEntityMap().get(parentBusinessEntityId);
        BusinessEntity relatedBusinessEntity = (BusinessEntity)ctx.getBusinessEntityMap().get(childBusinessEntityId);
        Relation relation = ctx.getParentChildRelation(parentBusinessEntityId, childBusinessEntityId);
        if (CollectionUtils.isEmpty(parentItems)) {
            return Flux.empty();
        }
        Set related = this.getRelatedItemsFromCtx(ctx, parentItems, relatedBusinessEntity);
        if (CollectionUtils.isNotEmpty((Collection)related)) {
            return Flux.fromIterable((Iterable)related);
        }
        return this.loadItemsByRelationQuery(ctx, request, relation, relatedBusinessEntity, parentItems, parent, user);
    }

    @Measurable(context="#ctx", type=MeasuredTaskType.ITEM_SERVICE_LOAD_MULTI_RELATED)
    public Flux<Item> loadAllMultiRootRelatedItems(ViewContext ctx, ViewRequest request, List<Item> rootItems, JwtSecurityUser user) {
        BusinessEntity rootBe = (BusinessEntity)ctx.getBusinessEntityMap().get(request.getRootEntityId());
        BusinessEntityQuery rootQuery = rootBe.getQuery();
        Set rootIds = rootItems.stream().map(i -> this.toEntityId(rootQuery, i)).collect(Collectors.toSet());
        return this.tbClient.findMultiRootRelatedItems(request, ctx, rootIds, user).doOnNext(arg_0 -> ((ViewContext)ctx).registerItem(arg_0));
    }

    private EnhancedItemLite toEnhancedItemLite(Map<BusinessEntityType, Map<String, BusinessEntity>> sourceMap, BusinessEntityType businessEntityType, Item item) {
        BusinessEntity businessEntity = ((Map)sourceMap.getOrDefault(businessEntityType, new HashMap())).getOrDefault(item.getType(), null);
        if (businessEntity == null) {
            return null;
        }
        return EnhancedItemLite.builder().item(item.toLite()).businessEntityId(businessEntity.getId()).businessEntityType(businessEntity.getQuery().getEntityType()).build();
    }

    private Set<Item> getRelatedItemsFromCtx(ViewContext ctx, Set<Item> parents, BusinessEntity relatedBusinessEntity) {
        BusinessEntityQuery query = relatedBusinessEntity.getQuery();
        BusinessEntityType entityType = query.getEntityType();
        String type = query.getType();
        String relatedItemType = entityType == BusinessEntityType.CUSTOMER ? "CUSTOMER" : type;
        return parents.stream().map(item -> (Set)ctx.getParentItemIdToChildItemIdSetMap().get(item.getId())).flatMap(Collection::stream).map(itemId -> (Item)ctx.getIdToItemMap().get(itemId)).filter(child -> relatedItemType.equals(child.getType())).collect(Collectors.toSet());
    }

    private EntityId toEntityId(BusinessEntityQuery beQuery, Item item) {
        AssetId entityId = new AssetId(item.getId());
        if (beQuery.getEntityType().equals((Object)BusinessEntityType.DEVICE)) {
            entityId = new DeviceId(item.getId());
        } else if (beQuery.getEntityType().equals((Object)BusinessEntityType.CUSTOMER)) {
            entityId = new CustomerId(item.getId());
        }
        return entityId;
    }

    private Flux<Item> loadItemsByRelationQuery(ViewContext ctx, ViewRequest request, Relation relation, BusinessEntity relatedBusinessEntity, Set<Item> parentItems, BusinessEntity parent, JwtSecurityUser user) {
        BusinessEntityQuery query = relatedBusinessEntity.getQuery();
        return Mono.just((Object)new Object()).flatMapMany(o -> switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$BusinessEntityType[query.getEntityType().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> Flux.fromIterable((Iterable)parentItems).flatMap(parentItem -> this.assetService.loadRelatedAssets(parentItem.getId(), parent, request, ctx, relation, relatedBusinessEntity, user));
            case 2 -> Flux.fromIterable((Iterable)parentItems).flatMap(parentItem -> this.deviceService.loadRelatedDevices(parentItem.getId(), parent, request, ctx, relation, relatedBusinessEntity, user));
            case 3 -> Flux.fromIterable((Iterable)parentItems).flatMap(parentItem -> this.customerService.loadRelatedCustomers(parentItem.getId(), parent, request, ctx, relation, relatedBusinessEntity, user));
            case 4 -> Flux.fromIterable((Iterable)parentItems);
        }).doOnNext(arg_0 -> ((ViewContext)ctx).registerItem(arg_0));
    }
}

