/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.IdBased;
import org.thingsboard.trendz.exception.service.provider.TbWebClientException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.provider.cache.CacheConfigurationName;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.tools.DonReactive;
import org.thingsboard.trendz.tools.json.JsonUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class TbCustomerRelationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbCustomerRelationService.class);
    private final TbRestDataSource apiClient;
    private final Cache subcustomerCache;
    private final Cache tenantCustomerInfoCache;

    @Autowired
    public TbCustomerRelationService(TbRestDataSource apiClient, CacheManager cacheManager) {
        this.apiClient = apiClient;
        this.subcustomerCache = cacheManager.getCache(CacheConfigurationName.subcustomerCacheName.getValue());
        this.tenantCustomerInfoCache = cacheManager.getCache(CacheConfigurationName.tenantCustomerInfoCache.getValue());
    }

    public Set<UUID> getAllSubCustomerIds(JwtSecurityUser user) {
        Set<UUID> customerIdSet = this.getAllCustomers(user).stream().map(IdBased::getUuidId).collect(Collectors.toSet());
        customerIdSet.add(user.getCustomerId());
        return customerIdSet;
    }

    public Map<UUID, String> getCustomerDictionary(JwtSecurityUser user) {
        Map<UUID, String> dictionary = this.getAllCustomers(user).stream().collect(Collectors.toMap(IdBased::getUuidId, Customer::getName));
        dictionary.put(EntityId.NULL_UUID, "None");
        return dictionary;
    }

    public Map<UUID, String> getTenantCustomerInfoDictionary(JwtSecurityUser user, ViewContext ctx) {
        return (Map)this.tenantCustomerInfoCache.get((Object)user, () -> {
            Mono resultMono = Flux.concat((Publisher[])new Publisher[]{this.apiClient.loadCustomerByApi(user, ctx).map(customerString -> (Customer)JsonUtils.fromJson((String)customerString, Customer.class)).map(customer -> Pair.of((Object)customer.getId().getId(), (Object)customer.getTitle())).onErrorComplete(), this.apiClient.loadTenantByApi(user, ctx).map(tenantString -> (Tenant)JsonUtils.fromJson((String)tenantString, Tenant.class)).map(tenant -> Pair.of((Object)tenant.getId().getId(), (Object)tenant.getTitle())).onErrorComplete()}).collectMap(Pair::getKey, Pair::getValue);
            Map result = (Map)DonReactive.block((Mono)resultMono);
            log.debug("Customer name retrieved from tenant, size: {}", (Object)result.size());
            return result;
        });
    }

    private Set<Customer> getAllCustomers(JwtSecurityUser user) {
        return (Set)this.subcustomerCache.get((Object)user, () -> {
            Mono mono = Mono.defer(() -> this.apiClient.loadCustomers(null, null, null, user).collectList().map(HashSet::new)).onErrorResume(TbWebClientException.class, e -> {
                if (e.getCause() instanceof WebClientResponseException.Forbidden) {
                    log.warn("Tenant User {}/{} has no access to customers.", (Object)user.getTenantId(), (Object)user.getUserId());
                    return Mono.just(new HashSet());
                }
                return Mono.error((Throwable)e);
            }).map(Function.identity());
            return (Set)DonReactive.block((Mono)mono);
        });
    }
}

