/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.predict.executors;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.base.Point;
import org.thingsboard.trendz.domain.base.TimeSeries;
import org.thingsboard.trendz.domain.definition.view.PredictionType;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.exception.BadConfiguredTaskException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.predict.AdditionalDataLoader;
import org.thingsboard.trendz.service.predict.PredictionMethodData;
import org.thingsboard.trendz.service.predict.PredictionMultiVariableMethodExecutor;
import org.thingsboard.trendz.service.predict.data.CustomMethodData;
import org.thingsboard.trendz.service.script.engine.PythonScriptEngine;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import org.thingsboard.trendz.service.view.proto.WindowedStreamStore;
import org.thingsboard.trendz.tools.json.JsonUtils;
import reactor.core.publisher.Mono;

@Service(value="customMethodOld")
public class CustomMethod
implements PredictionMultiVariableMethodExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomMethod.class);
    private final PythonScriptEngine pythonScriptEngine;
    private final AdditionalDataLoader additionalDataLoader;

    @Autowired
    public CustomMethod(PythonScriptEngine pythonScriptEngine, AdditionalDataLoader additionalDataLoader) {
        this.pythonScriptEngine = pythonScriptEngine;
        this.additionalDataLoader = additionalDataLoader;
    }

    public PredictionType getPredictiontype() {
        return PredictionType.CUSTOM;
    }

    public PredictionMethodData makeData(ViewField viewField, Item item, List<FieldValue> original, ViewRequest viewRequest, WindowedStreamStore windowedStreamStore, ViewContext ctx) {
        return CustomMethodData.builder().customMethodScript(viewField.getCustomPredictionMethod()).fieldIdList(viewField.getMultivariablePredictionFieldIdList()).viewField(viewField).item(item).viewRequest(viewRequest).windowedStreamStore(windowedStreamStore).ctx(ctx).build();
    }

    public Mono<TimeSeries> predict(JwtSecurityUser user, TimeSeries learnSet, long[] predictionTs, PredictionMethodData methodData) {
        CustomMethodData data = (CustomMethodData)methodData;
        ViewField viewField = data.getViewField();
        Item item = data.getItem();
        ViewRequest viewRequest = data.getViewRequest();
        WindowedStreamStore windowedStreamStore = data.getWindowedStreamStore();
        ViewContext ctx = data.getCtx();
        List fieldIdList = data.getFieldIdList();
        String custom = data.getCustomMethodScript();
        if (custom == null || custom.equals("")) {
            throw new BadConfiguredTaskException("Custom prediction model is empty");
        }
        return Mono.just((Object)new Object()).flatMap(o -> this.additionalDataLoader.loadAdditionalData(viewField, item, viewRequest, windowedStreamStore, ctx, fieldIdList)).flatMap(additionalData -> {
            Map learnTimeseries = this.makeLearnTimeseries(additionalData, learnSet);
            Map alignedLearnTimeseries = this.alignByTime(learnTimeseries);
            List historyTimestamps = this.getHistoryTimestamps(alignedLearnTimeseries);
            Map features = this.getFeatures(alignedLearnTimeseries);
            List baseHistoryFeatures = (List)features.get("input");
            ArrayList baseFutureFeatures = new ArrayList();
            features.remove("input");
            ArrayList historyRegressors = new ArrayList(features.values());
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("inputX", historyTimestamps);
            input.put("outputX", predictionTs);
            input.put("inputY", baseHistoryFeatures);
            input.put("outputY", baseFutureFeatures);
            input.put("historyRegressors", historyRegressors);
            CollectionType type = JsonUtils.getObjectMapper().getTypeFactory().constructCollectionType(List.class, Double.class);
            String modelCode = "def modelFunction(input_x, input_y, output_x, regressors):\n\t" + custom.replaceAll("\n", "\n\t") + "\n";
            String script = "\n" + modelCode + "regressorsCount = len(historyRegressors)\nfor i in range(0, regressorsCount):\n    print(f\"historyRegressors{i} = {historyRegressors[i]}\")\n\nprint(f\"inputX: {inputX}\")\nprint(f\"inputY: {inputY}\")\nprint(f\"outputX: {outputX}\")\nprint(f\"outputY: {outputY}\")\n\noutputY = modelFunction(inputX, inputY, outputX, historyRegressors)\nprint(f\"result: {outputY}\")\nreturn outputY\n";
            return this.pythonScriptEngine.runScript(user, script, (JavaType)type, input).map(executionResult -> {
                List futureFeatures = (List)executionResult.getResult();
                if (predictionTs.length != futureFeatures.size()) {
                    throw new RuntimeException("Prediction sets are not corresponding");
                }
                return IntStream.range(0, predictionTs.length).mapToObj(i -> new Point(predictionTs[i], ((Double)futureFeatures.get(i)).doubleValue())).sorted(Comparator.comparingLong(Point::getTs)).collect(Collectors.collectingAndThen(Collectors.toList(), TimeSeries::new));
            });
        });
    }
}

