/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.prediction.accuracy;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.base.Point;
import org.thingsboard.trendz.domain.base.TimeSeries;
import org.thingsboard.trendz.service.model.prediction.accuracy.AccuracyData;
import org.thingsboard.trendz.service.model.prediction.accuracy.AccuracyMethod;
import org.thingsboard.trendz.service.model.prediction.accuracy.AccuracyMethodConfidenceLevelData;
import org.thingsboard.trendz.service.model.prediction.accuracy.AccuracyMethodData;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentData;
import org.thingsboard.trendz.tools.DateTimeUtils;

@Service
public class AccuracyMethodConfidenceLevel
implements AccuracyMethod {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AccuracyMethodConfidenceLevel.class);

    public AccuracyData calculate(Set<SegmentData> segmentData, AccuracyMethodData d, ChronoUnit timeUnit, ZoneId zoneId, boolean autoDefineSettings) {
        log.info("Accuracy method {}: segment data count = {}, time unit = {}, zone = {}", new Object[]{d.getType(), segmentData.size(), timeUnit, zoneId});
        AccuracyMethodConfidenceLevelData methodData = (AccuracyMethodConfidenceLevelData)d;
        long acceptableTsDistance = methodData.getAcceptableTsDistance();
        double acceptableValueDistance = methodData.getAcceptableValueDistance();
        HashMap<Long, Integer> pointMatchCountMap = new HashMap<Long, Integer>();
        HashMap<Long, Integer> pointPresenceCountMap = new HashMap<Long, Integer>();
        for (SegmentData segment : segmentData) {
            TimeSeries historicalTelemetry = segment.getHistoricalTelemetry();
            TimeSeries predictionTelemetry = segment.getPredictionTelemetry();
            long minTs = historicalTelemetry.getPoints().stream().mapToLong(Point::getTs).min().orElseThrow();
            ZonedDateTime minDate = DateTimeUtils.fromTs((long)minTs, (ZoneId)zoneId);
            Map<Long, Double> historicalDataMap = historicalTelemetry.getPoints().stream().collect(Collectors.toMap(point -> this.timeDistance(minDate, point, timeUnit, zoneId), Point::getValue));
            Map<Long, Double> predictionDataMap = predictionTelemetry.getPoints().stream().collect(Collectors.toMap(point -> this.timeDistance(minDate, point, timeUnit, zoneId), Point::getValue));
            long maxUnit = historicalDataMap.keySet().stream().mapToLong(i -> i).max().orElseThrow();
            for (long distance2 : historicalDataMap.keySet()) {
                boolean match = false;
                long from = Math.max(0L, distance2 - acceptableTsDistance);
                long to = Math.min(maxUnit, distance2 + acceptableTsDistance);
                for (long i2 = from; i2 <= to && !match; ++i2) {
                    double predictionValue;
                    if (!predictionDataMap.containsKey(i2)) continue;
                    double historicalValue = historicalDataMap.get(distance2);
                    double valueDistance = Math.abs(historicalValue - (predictionValue = predictionDataMap.get(i2).doubleValue()));
                    match = valueDistance <= acceptableValueDistance;
                }
                int matchCount = pointMatchCountMap.computeIfAbsent(distance2, key -> 0);
                int presenceCount = pointPresenceCountMap.computeIfAbsent(distance2, key -> 0);
                pointMatchCountMap.put(distance2, match ? matchCount + 1 : matchCount);
                pointPresenceCountMap.put(distance2, presenceCount + 1);
            }
        }
        TimeSeries confidenceLevel = pointPresenceCountMap.keySet().stream().map(distance -> {
            int matchCount = (Integer)pointMatchCountMap.get(distance);
            int presenceCount = (Integer)pointPresenceCountMap.get(distance);
            double percent = 100.0 * (double)matchCount / (double)presenceCount;
            return new Point(distance.longValue(), percent);
        }).collect(Collectors.collectingAndThen(Collectors.toList(), TimeSeries::new));
        return new AccuracyData(Map.of("confidenceLevel", confidenceLevel));
    }

    public AccuracyMethodData autoDefineSettings(AccuracyMethodData d, Set<SegmentData> segmentData) {
        AccuracyMethodConfidenceLevelData methodData = new AccuracyMethodConfidenceLevelData((AccuracyMethodConfidenceLevelData)d);
        Set distances = segmentData.stream().map(segment -> {
            List historicalTelemetry = segment.getHistoricalTelemetry().getPoints();
            List predictionTelemetry = segment.getPredictionTelemetry().getPoints();
            ArrayList<Double> valueDistances = new ArrayList<Double>();
            int segmentSize = historicalTelemetry.size();
            for (int i = 0; i < segmentSize; ++i) {
                Point historicalPoint = (Point)historicalTelemetry.get(i);
                Point predictionPoint = (Point)predictionTelemetry.get(i);
                double valueDistance = Math.abs(historicalPoint.getValue() - predictionPoint.getValue());
                valueDistances.add(valueDistance);
            }
            return valueDistances;
        }).collect(Collectors.toSet());
        double averageValueDistance = distances.stream().flatMap(Collection::stream).mapToDouble(i -> i).average().orElseThrow();
        methodData.setAcceptableTsDistance(1L);
        methodData.setAcceptableValueDistance(averageValueDistance);
        return methodData;
    }

    public void validate(AccuracyMethodData d) {
        AccuracyMethodConfidenceLevelData methodData = (AccuracyMethodConfidenceLevelData)d;
        long acceptableTsDistance = methodData.getAcceptableTsDistance();
        double acceptableValueDistance = methodData.getAcceptableValueDistance();
        log.debug("Used parameters, acceptable value distance = {}, acceptable ts distance = {}", (Object)acceptableValueDistance, (Object)acceptableTsDistance);
        if (acceptableValueDistance < 0.0) {
            throw new IllegalArgumentException("The acceptable value distance is invalid");
        }
        if (acceptableTsDistance < 0L) {
            throw new IllegalArgumentException("The acceptable time distance is invalid");
        }
    }

    private long timeDistance(ZonedDateTime minDate, Point point, ChronoUnit timeUnit, ZoneId zoneId) {
        return timeUnit.between(minDate, DateTimeUtils.fromTs((long)point.getTs(), (ZoneId)zoneId));
    }
}

