/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.prediction;

import java.util.EnumMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.service.model.prediction.methods.PredictionMethod;
import org.thingsboard.trendz.service.model.prediction.methods.PredictionMethodType;
import org.thingsboard.trendz.service.startup.TrendzStartupService;

@Service
public class PredictionModelDefinitionService
implements TrendzStartupService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PredictionModelDefinitionService.class);
    private final Map<PredictionMethodType, PredictionMethod> typeToPredictionMethodMap = new EnumMap(PredictionMethodType.class);

    public void onStartup(ApplicationContext context) {
        Map nameToBeanMap = context.getBeansOfType(PredictionMethod.class);
        for (PredictionMethod method : nameToBeanMap.values()) {
            PredictionMethodType type = method.getType();
            if (this.typeToPredictionMethodMap.containsKey(type)) {
                throw new TrendzInternalException("Ambiguous mapping for task job executors: " + String.valueOf(type));
            }
            this.typeToPredictionMethodMap.put(type, method);
        }
    }

    public int priority() {
        return 21;
    }

    public PredictionMethod getPredictionMethodByType(PredictionMethodType type) {
        return (PredictionMethod)this.typeToPredictionMethodMap.get(type);
    }
}

