/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.prediction;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.thingsboard.trendz.domain.definition.migration.TrendzEntity;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.model.prediction.PredictionModel;
import org.thingsboard.trendz.service.model.prediction.PredictionModelDatasourceParameters;
import org.thingsboard.trendz.service.model.prediction.PredictionModelParameters;
import org.thingsboard.trendz.service.model.prediction.PredictionModelStatus;
import org.thingsboard.trendz.service.model.prediction.methods.PredictionMethodParameters;
import org.thingsboard.trendz.service.model.prediction.methods.PredictionMethodType;

public class PredictionModel
implements TrendzEntity {
    private UUID id;
    private UUID tenantId;
    private UUID customerId;
    private String name;
    private long createdTs;
    private long updatedTs;
    private boolean enabled;
    private boolean partialFitEnabled;
    private PredictionModelStatus status;
    private PredictionMethodType type;
    private UUID associatedBusinessEntityFieldId;
    private String tbTelemetryKey;
    private PredictionModelParameters modelParameters;
    private PredictionMethodParameters methodParameters;
    private PredictionModelDatasourceParameters datasourceParameters;
    private Map<UUID, String> itemIdToStateMap;
    private Set<ItemLite> trainedItemsSet;
    private boolean avoidDisabling;

    public PredictionModel(PredictionModel that) {
        this.id = that.id;
        this.tenantId = that.tenantId;
        this.customerId = that.customerId;
        this.name = that.name;
        this.createdTs = that.createdTs;
        this.updatedTs = that.updatedTs;
        this.enabled = that.enabled;
        this.partialFitEnabled = that.partialFitEnabled;
        this.status = that.status;
        this.type = that.type;
        this.associatedBusinessEntityFieldId = that.associatedBusinessEntityFieldId;
        this.tbTelemetryKey = that.tbTelemetryKey;
        this.modelParameters = that.modelParameters == null ? null : new PredictionModelParameters(that.modelParameters);
        this.methodParameters = that.methodParameters == null ? null : that.methodParameters.clone();
        this.datasourceParameters = that.datasourceParameters == null ? null : new PredictionModelDatasourceParameters(that.datasourceParameters);
        this.itemIdToStateMap = that.itemIdToStateMap == null ? null : new HashMap(that.itemIdToStateMap);
        this.trainedItemsSet = that.trainedItemsSet == null ? null : that.trainedItemsSet.stream().map(ItemLite::new).collect(Collectors.toSet());
        this.avoidDisabling = that.avoidDisabling;
    }

    public static boolean checkUserOwnership(PredictionModel model, JwtSecurityUser user) {
        boolean sameTenant = model.getTenantId().equals(user.getTenantId());
        boolean sameCustomer = model.getCustomerId().equals(user.getCustomerId());
        return sameTenant && sameCustomer;
    }

    public static boolean checkSameOwnership(PredictionModel o1, PredictionModel o2) {
        boolean sameTenant = o1.getTenantId().equals(o2.getTenantId());
        boolean sameCustomer = o1.getCustomerId().equals(o2.getCustomerId());
        return sameTenant && sameCustomer;
    }

    @Generated
    public static PredictionModelBuilder builder() {
        return new PredictionModelBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public UUID getTenantId() {
        return this.tenantId;
    }

    @Generated
    public UUID getCustomerId() {
        return this.customerId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public long getCreatedTs() {
        return this.createdTs;
    }

    @Generated
    public long getUpdatedTs() {
        return this.updatedTs;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public boolean isPartialFitEnabled() {
        return this.partialFitEnabled;
    }

    @Generated
    public PredictionModelStatus getStatus() {
        return this.status;
    }

    @Generated
    public PredictionMethodType getType() {
        return this.type;
    }

    @Generated
    public UUID getAssociatedBusinessEntityFieldId() {
        return this.associatedBusinessEntityFieldId;
    }

    @Generated
    public String getTbTelemetryKey() {
        return this.tbTelemetryKey;
    }

    @Generated
    public PredictionModelParameters getModelParameters() {
        return this.modelParameters;
    }

    @Generated
    public PredictionMethodParameters getMethodParameters() {
        return this.methodParameters;
    }

    @Generated
    public PredictionModelDatasourceParameters getDatasourceParameters() {
        return this.datasourceParameters;
    }

    @Generated
    public Map<UUID, String> getItemIdToStateMap() {
        return this.itemIdToStateMap;
    }

    @Generated
    public Set<ItemLite> getTrainedItemsSet() {
        return this.trainedItemsSet;
    }

    @Generated
    public boolean isAvoidDisabling() {
        return this.avoidDisabling;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setCustomerId(UUID customerId) {
        this.customerId = customerId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setCreatedTs(long createdTs) {
        this.createdTs = createdTs;
    }

    @Generated
    public void setUpdatedTs(long updatedTs) {
        this.updatedTs = updatedTs;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setPartialFitEnabled(boolean partialFitEnabled) {
        this.partialFitEnabled = partialFitEnabled;
    }

    @Generated
    public void setStatus(PredictionModelStatus status) {
        this.status = status;
    }

    @Generated
    public void setType(PredictionMethodType type) {
        this.type = type;
    }

    @Generated
    public void setAssociatedBusinessEntityFieldId(UUID associatedBusinessEntityFieldId) {
        this.associatedBusinessEntityFieldId = associatedBusinessEntityFieldId;
    }

    @Generated
    public void setTbTelemetryKey(String tbTelemetryKey) {
        this.tbTelemetryKey = tbTelemetryKey;
    }

    @Generated
    public void setModelParameters(PredictionModelParameters modelParameters) {
        this.modelParameters = modelParameters;
    }

    @Generated
    public void setMethodParameters(PredictionMethodParameters methodParameters) {
        this.methodParameters = methodParameters;
    }

    @Generated
    public void setDatasourceParameters(PredictionModelDatasourceParameters datasourceParameters) {
        this.datasourceParameters = datasourceParameters;
    }

    @Generated
    public void setItemIdToStateMap(Map<UUID, String> itemIdToStateMap) {
        this.itemIdToStateMap = itemIdToStateMap;
    }

    @Generated
    public void setTrainedItemsSet(Set<ItemLite> trainedItemsSet) {
        this.trainedItemsSet = trainedItemsSet;
    }

    @Generated
    public void setAvoidDisabling(boolean avoidDisabling) {
        this.avoidDisabling = avoidDisabling;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PredictionModel)) {
            return false;
        }
        PredictionModel other = (PredictionModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getCreatedTs() != other.getCreatedTs()) {
            return false;
        }
        if (this.getUpdatedTs() != other.getUpdatedTs()) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isPartialFitEnabled() != other.isPartialFitEnabled()) {
            return false;
        }
        if (this.isAvoidDisabling() != other.isAvoidDisabling()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        UUID this$customerId = this.getCustomerId();
        UUID other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        PredictionModelStatus this$status = this.getStatus();
        PredictionModelStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        PredictionMethodType this$type = this.getType();
        PredictionMethodType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        UUID this$associatedBusinessEntityFieldId = this.getAssociatedBusinessEntityFieldId();
        UUID other$associatedBusinessEntityFieldId = other.getAssociatedBusinessEntityFieldId();
        if (this$associatedBusinessEntityFieldId == null ? other$associatedBusinessEntityFieldId != null : !((Object)this$associatedBusinessEntityFieldId).equals(other$associatedBusinessEntityFieldId)) {
            return false;
        }
        String this$tbTelemetryKey = this.getTbTelemetryKey();
        String other$tbTelemetryKey = other.getTbTelemetryKey();
        if (this$tbTelemetryKey == null ? other$tbTelemetryKey != null : !this$tbTelemetryKey.equals(other$tbTelemetryKey)) {
            return false;
        }
        PredictionModelParameters this$modelParameters = this.getModelParameters();
        PredictionModelParameters other$modelParameters = other.getModelParameters();
        if (this$modelParameters == null ? other$modelParameters != null : !this$modelParameters.equals(other$modelParameters)) {
            return false;
        }
        PredictionMethodParameters this$methodParameters = this.getMethodParameters();
        PredictionMethodParameters other$methodParameters = other.getMethodParameters();
        if (this$methodParameters == null ? other$methodParameters != null : !this$methodParameters.equals(other$methodParameters)) {
            return false;
        }
        PredictionModelDatasourceParameters this$datasourceParameters = this.getDatasourceParameters();
        PredictionModelDatasourceParameters other$datasourceParameters = other.getDatasourceParameters();
        if (this$datasourceParameters == null ? other$datasourceParameters != null : !this$datasourceParameters.equals(other$datasourceParameters)) {
            return false;
        }
        Map this$itemIdToStateMap = this.getItemIdToStateMap();
        Map other$itemIdToStateMap = other.getItemIdToStateMap();
        if (this$itemIdToStateMap == null ? other$itemIdToStateMap != null : !((Object)this$itemIdToStateMap).equals(other$itemIdToStateMap)) {
            return false;
        }
        Set this$trainedItemsSet = this.getTrainedItemsSet();
        Set other$trainedItemsSet = other.getTrainedItemsSet();
        return !(this$trainedItemsSet == null ? other$trainedItemsSet != null : !((Object)this$trainedItemsSet).equals(other$trainedItemsSet));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PredictionModel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $createdTs = this.getCreatedTs();
        result = result * 59 + (int)($createdTs >>> 32 ^ $createdTs);
        long $updatedTs = this.getUpdatedTs();
        result = result * 59 + (int)($updatedTs >>> 32 ^ $updatedTs);
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isPartialFitEnabled() ? 79 : 97);
        result = result * 59 + (this.isAvoidDisabling() ? 79 : 97);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        UUID $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        PredictionModelStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        PredictionMethodType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        UUID $associatedBusinessEntityFieldId = this.getAssociatedBusinessEntityFieldId();
        result = result * 59 + ($associatedBusinessEntityFieldId == null ? 43 : ((Object)$associatedBusinessEntityFieldId).hashCode());
        String $tbTelemetryKey = this.getTbTelemetryKey();
        result = result * 59 + ($tbTelemetryKey == null ? 43 : $tbTelemetryKey.hashCode());
        PredictionModelParameters $modelParameters = this.getModelParameters();
        result = result * 59 + ($modelParameters == null ? 43 : $modelParameters.hashCode());
        PredictionMethodParameters $methodParameters = this.getMethodParameters();
        result = result * 59 + ($methodParameters == null ? 43 : $methodParameters.hashCode());
        PredictionModelDatasourceParameters $datasourceParameters = this.getDatasourceParameters();
        result = result * 59 + ($datasourceParameters == null ? 43 : $datasourceParameters.hashCode());
        Map $itemIdToStateMap = this.getItemIdToStateMap();
        result = result * 59 + ($itemIdToStateMap == null ? 43 : ((Object)$itemIdToStateMap).hashCode());
        Set $trainedItemsSet = this.getTrainedItemsSet();
        result = result * 59 + ($trainedItemsSet == null ? 43 : ((Object)$trainedItemsSet).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PredictionModel(id=" + String.valueOf(this.getId()) + ", tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", name=" + this.getName() + ", createdTs=" + this.getCreatedTs() + ", updatedTs=" + this.getUpdatedTs() + ", enabled=" + this.isEnabled() + ", partialFitEnabled=" + this.isPartialFitEnabled() + ", status=" + String.valueOf(this.getStatus()) + ", type=" + String.valueOf(this.getType()) + ", associatedBusinessEntityFieldId=" + String.valueOf(this.getAssociatedBusinessEntityFieldId()) + ", tbTelemetryKey=" + this.getTbTelemetryKey() + ", modelParameters=" + String.valueOf(this.getModelParameters()) + ", methodParameters=" + String.valueOf(this.getMethodParameters()) + ", datasourceParameters=" + String.valueOf(this.getDatasourceParameters()) + ", itemIdToStateMap=" + String.valueOf(this.getItemIdToStateMap()) + ", trainedItemsSet=" + String.valueOf(this.getTrainedItemsSet()) + ", avoidDisabling=" + this.isAvoidDisabling() + ")";
    }

    @Generated
    public PredictionModel() {
    }

    @Generated
    public PredictionModel(UUID id, UUID tenantId, UUID customerId, String name, long createdTs, long updatedTs, boolean enabled, boolean partialFitEnabled, PredictionModelStatus status, PredictionMethodType type, UUID associatedBusinessEntityFieldId, String tbTelemetryKey, PredictionModelParameters modelParameters, PredictionMethodParameters methodParameters, PredictionModelDatasourceParameters datasourceParameters, Map<UUID, String> itemIdToStateMap, Set<ItemLite> trainedItemsSet, boolean avoidDisabling) {
        this.id = id;
        this.tenantId = tenantId;
        this.customerId = customerId;
        this.name = name;
        this.createdTs = createdTs;
        this.updatedTs = updatedTs;
        this.enabled = enabled;
        this.partialFitEnabled = partialFitEnabled;
        this.status = status;
        this.type = type;
        this.associatedBusinessEntityFieldId = associatedBusinessEntityFieldId;
        this.tbTelemetryKey = tbTelemetryKey;
        this.modelParameters = modelParameters;
        this.methodParameters = methodParameters;
        this.datasourceParameters = datasourceParameters;
        this.itemIdToStateMap = itemIdToStateMap;
        this.trainedItemsSet = trainedItemsSet;
        this.avoidDisabling = avoidDisabling;
    }
}

