/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.anomaly.fetcher;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.domain.anomaly.DataVector;
import org.thingsboard.trendz.domain.anomaly.DatasetConfig;
import org.thingsboard.trendz.domain.base.Point;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.exception.BadConfiguredTaskException;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.exception.service.definition.BusinessEntityFieldNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.model.anomaly.fetcher.DatasetFetcher;
import org.thingsboard.trendz.service.model.anomaly.fetcher.TelemetryFetchState;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.provider.TsData;
import org.thingsboard.trendz.service.view.ItemService;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class DatasetFetcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DatasetFetcher.class);
    private final BusinessEntityService businessEntityService;
    private final ItemService itemService;
    private final TbRestDataSource dataSource;
    private final int pagesizeTelemetry;
    private final Map<UUID, Map<String, AtomicLong>> taskLoadedPointsMap = new ConcurrentHashMap();
    private final Map<UUID, AtomicLong> taskLoadedItemsMap = new ConcurrentHashMap();

    public DatasetFetcher(BusinessEntityService businessEntityService, ItemService itemService, TbRestDataSource dataSource, @Value(value="${tb.api.limits.pagesize.telemetry}") int pagesizeTelemetry) {
        this.businessEntityService = businessEntityService;
        this.itemService = itemService;
        this.dataSource = dataSource;
        this.pagesizeTelemetry = pagesizeTelemetry;
    }

    public Flux<DataVector> fetchDataset(JwtSecurityUser user, DatasetConfig datasetConfig) {
        return Mono.fromSupplier(() -> this.initCounters()).flatMapMany(fetchTaskId -> this.itemService.loadItems(datasetConfig.getBusinessEntityId(), datasetConfig.getItemSet(), user).map(Item::toLite).collect(Collectors.toSet()).doOnNext(items -> log.info("Found {} items", (Object)items.size())).flatMapMany(items -> this.loadValues(user, items, datasetConfig, fetchTaskId)).doFinally(t -> this.clearByFetchTaskId(fetchTaskId)));
    }

    private void clearByFetchTaskId(UUID fetchTaskId) {
        this.taskLoadedItemsMap.remove(fetchTaskId);
        this.taskLoadedPointsMap.remove(fetchTaskId);
    }

    private UUID initCounters() {
        UUID fetchTaskId = TimeStampUUIDGenerator.generateId();
        this.taskLoadedItemsMap.put(fetchTaskId, new AtomicLong());
        this.taskLoadedPointsMap.put(fetchTaskId, new ConcurrentHashMap());
        return fetchTaskId;
    }

    private Flux<DataVector> loadValues(JwtSecurityUser user, Set<ItemLite> items, DatasetConfig datasetConfig, UUID fetchTaskId) {
        Set businessEntityIds = datasetConfig.getFields().stream().map(ViewField::getBusinessEntityId).collect(Collectors.toSet());
        if (businessEntityIds.size() != 1) {
            throw new BadConfiguredTaskException("Fields from multiple Business Entities are not supported");
        }
        UUID businessEntityId = (UUID)businessEntityIds.iterator().next();
        BusinessEntity entity = this.businessEntityService.findEntityById(user, businessEntityId);
        HashMap fieldMap = new HashMap();
        datasetConfig.getFields().forEach(vf -> {
            BusinessEntityField entityField = entity.getFields().stream().filter(bef -> bef.getId().equals(vf.getEntityFieldId())).findFirst().orElseThrow(() -> new BusinessEntityFieldNotFoundException(vf.getEntityFieldId()));
            switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$field$FieldQueryType[entityField.getQuery().getQueryType().ordinal()]) {
                case 1: 
                case 2: {
                    fieldMap.put(vf, entityField);
                }
            }
        });
        BusinessEntityType entityType = entity.getQuery().getEntityType();
        int maxPointsCount = datasetConfig.getMaxPointsCount() <= 0 ? 1000000 : datasetConfig.getMaxPointsCount();
        return Flux.fromIterable(items).flatMap(item -> this.loadItemValues(user, item, entityType, fieldMap, datasetConfig, fetchTaskId, (long)maxPointsCount).map(itemValues -> new DataVector(item.getId(), item.getName(), itemValues))).takeUntil(dataVector -> {
            long loadedPointsCnt = ((Map)this.taskLoadedPointsMap.get(fetchTaskId)).values().stream().mapToLong(AtomicLong::get).max().orElse(0L);
            if (loadedPointsCnt > (long)maxPointsCount) {
                log.info("dataset max points threshold reached. Stop loading {} / {}", (Object)maxPointsCount, (Object)loadedPointsCnt);
                return true;
            }
            ((AtomicLong)this.taskLoadedItemsMap.get(fetchTaskId)).incrementAndGet();
            return false;
        });
    }

    private Mono<Map<UUID, List<Point>>> loadItemValues(JwtSecurityUser user, ItemLite item, BusinessEntityType entityType, Map<ViewField, BusinessEntityField> fieldMap, DatasetConfig datasetConfig, UUID fetchTaskId, long maxPointsCount) {
        return Flux.fromIterable(fieldMap.keySet()).flatMap(viewField -> {
            BusinessEntityField entityField = (BusinessEntityField)fieldMap.get(viewField);
            String key = entityField.getQuery().getKey();
            return this.pageableTelemetryLoad(user, item, entityType, key, datasetConfig, fetchTaskId, maxPointsCount).collectList().map(points -> Pair.of((Object)viewField.getId(), (Object)points));
        }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    private Flux<Point> pageableTelemetryLoad(JwtSecurityUser user, ItemLite item, BusinessEntityType entityType, String key, DatasetConfig datasetConfig, UUID fetchTaskId, long maxPointsCount) {
        long startTs = datasetConfig.getStartTs();
        long endTs = datasetConfig.getEndTs();
        return Mono.just((Object)new TelemetryFetchState(false, startTs, Collections.emptyList())).expand(state -> {
            if (state.isFinished()) {
                return Mono.empty();
            }
            return this.dataSource.loadTelemetry(user, entityType, item.getId(), key, state.getStartTs(), endTs).map(fieldValues -> this.processFetchedTelemetry(fieldValues, key, fetchTaskId, maxPointsCount));
        }).flatMapIterable(TelemetryFetchState::getLoadedPoints);
    }

    private TelemetryFetchState processFetchedTelemetry(Map<String, List<TsData>> fieldValues, String key, UUID fetchTaskId, long maxPointsCount) {
        Set<String> keySet = fieldValues.keySet();
        if (keySet.isEmpty()) {
            return new TelemetryFetchState(true, 1L, Collections.emptyList());
        }
        if (keySet.size() != 1) {
            throw new TrendzInternalException("Unexpected result: too many keys");
        }
        String fieldId = keySet.iterator().next();
        if (!fieldId.equals(key)) {
            throw new TrendzInternalException("Unexpected result: different key");
        }
        List<Point> pageData = fieldValues.get(fieldId).stream().filter(tsData -> NumberUtils.isCreatable((String)tsData.getValue())).map(tsData -> new Point(tsData.getTs(), NumberUtils.createNumber((String)tsData.getValue()).doubleValue())).sorted(Comparator.comparingLong(Point::getTs)).toList();
        AtomicLong itemsCounter = (AtomicLong)this.taskLoadedItemsMap.get(fetchTaskId);
        Map fieldToCounterMap = (Map)this.taskLoadedPointsMap.get(fetchTaskId);
        AtomicLong pointsCounter = fieldToCounterMap.computeIfAbsent(key, i -> new AtomicLong());
        pointsCounter.addAndGet(pageData.size());
        long newTs = pageData.stream().mapToLong(Point::getTs).max().orElse(0L) + 1L;
        log.info("Page data loaded {}. Total size {} Items {}", new Object[]{pageData.size(), pointsCounter.get(), itemsCounter.get()});
        boolean isFinished = pointsCounter.get() > maxPointsCount || pageData.size() != this.pagesizeTelemetry;
        return new TelemetryFetchState(isFinished, newTs, pageData);
    }
}

