/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.anomaly.features;

import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.anomaly.ComplexTsPoint;

@Service
public class TsFeatureExtractor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TsFeatureExtractor.class);

    public double[] extract(List<ComplexTsPoint> points, Set<UUID> fieldIds) {
        ArrayList features = Lists.newArrayList();
        for (UUID fieldId : fieldIds) {
            List<Double> values = points.stream().map(ComplexTsPoint::getValues).map(map -> (Double)map.get(fieldId)).toList();
            features.addAll(this.getRegressionFeatures(points, fieldId));
            features.add(values.stream().mapToDouble(d -> d).max().orElse(0.0));
            features.add(values.stream().mapToDouble(d -> d).min().orElse(0.0));
            features.add(values.stream().mapToDouble(d -> d).average().orElse(0.0));
        }
        return Doubles.toArray((Collection)features);
    }

    private List<Double> getRegressionFeatures(List<ComplexTsPoint> points, UUID fieldId) {
        ArrayList features = Lists.newArrayList();
        SimpleRegression sr = new SimpleRegression();
        for (ComplexTsPoint record : points) {
            sr.addData((double)record.getTs(), ((Double)record.getValues().get(fieldId)).doubleValue());
        }
        features.add(sr.getSlope());
        features.add(sr.getMeanSquareError());
        return features;
    }
}

