/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.anomaly.cluster;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.domain.anomaly.ClusterableSegment;
import org.thingsboard.trendz.domain.anomaly.MlProperties;
import org.thingsboard.trendz.domain.anomaly.Segment;
import org.thingsboard.trendz.service.model.anomaly.cluster.LoggedKMean;
import org.thingsboard.trendz.service.model.anomaly.cluster.SegmentClusterer;

@Component
public class KMeansClusterer
implements SegmentClusterer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KMeansClusterer.class);

    public List<CentroidCluster<ClusterableSegment>> cluster(List<Segment> segments, DistanceMeasure distanceMeasure, MlProperties.ClusteringProperties properties) {
        int iterations = properties.getKmeansProperties().getMaxIterations();
        int clusterCount = properties.getClustersCount();
        List clusterInput = segments.stream().map(ClusterableSegment::new).collect(Collectors.toList());
        LoggedKMean clusterer = new LoggedKMean(clusterCount, iterations, distanceMeasure);
        return clusterer.cluster(clusterInput);
    }
}

