/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.anomaly.cluster;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.commons.math3.ml.clustering.Cluster;
import org.apache.commons.math3.ml.clustering.Clusterable;
import org.apache.commons.math3.ml.clustering.DBSCANClusterer;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.domain.anomaly.ClusterableSegment;
import org.thingsboard.trendz.domain.anomaly.MlProperties;
import org.thingsboard.trendz.domain.anomaly.Segment;
import org.thingsboard.trendz.service.model.anomaly.cluster.SegmentClusterer;

@Component
public class DBScanClusterer
implements SegmentClusterer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DBScanClusterer.class);

    public List<CentroidCluster<ClusterableSegment>> cluster(List<Segment> segments, DistanceMeasure distanceMeasure, MlProperties.ClusteringProperties properties) {
        double maxEps = properties.getDbscanProperties().getMaxEpsilon();
        int minPoints = properties.getDbscanProperties().getMinPointsInCluster();
        List clusterInput = segments.stream().map(ClusterableSegment::new).collect(Collectors.toList());
        DBSCANClusterer clusterer = new DBSCANClusterer(maxEps, minPoints, distanceMeasure);
        List centroids = clusterer.cluster(clusterInput);
        Set withCluster = centroids.stream().map(Cluster::getPoints).flatMap(Collection::stream).collect(Collectors.toSet());
        ArrayList outliers = new ArrayList(Sets.difference(new HashSet(clusterInput), withCluster));
        log.info("Clusters found {} Anomalies {}", (Object)centroids.size(), (Object)outliers.size());
        if (!outliers.isEmpty()) {
            CentroidCluster outliersCluster = new CentroidCluster((Clusterable)outliers.get(0));
            outliers.forEach(arg_0 -> ((CentroidCluster)outliersCluster).addPoint(arg_0));
            centroids.add(outliersCluster);
        }
        return centroids.stream().map(c -> {
            CentroidCluster cluster = new CentroidCluster((Clusterable)c.getPoints().get(0));
            c.getPoints().forEach(arg_0 -> ((CentroidCluster)cluster).addPoint(arg_0));
            return cluster;
        }).collect(Collectors.toList());
    }
}

