/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.anomaly;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.dao.model.anomaly.AnomalyDao;
import org.thingsboard.trendz.domain.anomaly.Anomaly;
import org.thingsboard.trendz.domain.anomaly.AnomalyModel;
import org.thingsboard.trendz.domain.anomaly.AnomalyPersistenceReport;
import org.thingsboard.trendz.domain.anomaly.AnomalyReport;
import org.thingsboard.trendz.domain.anomaly.DataVector;
import org.thingsboard.trendz.domain.anomaly.DatasetConfig;
import org.thingsboard.trendz.domain.anomaly.ModelType;
import org.thingsboard.trendz.domain.anomaly.SegmentReport;
import org.thingsboard.trendz.domain.base.Point;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.model.anomaly.ClusteringService;
import org.thingsboard.trendz.service.model.anomaly.components.AnomalyExtractor;
import org.thingsboard.trendz.service.model.anomaly.components.AnomalyFilter;
import org.thingsboard.trendz.service.model.anomaly.fetcher.DatasetFetcher;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Mono;

@Component
public class AnomalyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnomalyService.class);
    private final ClusteringService clusteringService;
    private final AnomalyExtractor anomalyExtractor;
    private final DatasetFetcher datasetFetcher;
    private final AnomalyDao anomalyDao;

    @Autowired
    public AnomalyService(ClusteringService clusteringService, AnomalyExtractor anomalyExtractor, DatasetFetcher datasetFetcher, AnomalyDao anomalyDao) {
        this.clusteringService = clusteringService;
        this.anomalyExtractor = anomalyExtractor;
        this.datasetFetcher = datasetFetcher;
        this.anomalyDao = anomalyDao;
    }

    public List<Anomaly> findAnomaliesByFilter(AnomalyFilter filter) {
        long start = System.currentTimeMillis();
        List anomalies = this.anomalyDao.findByFilter(filter);
        log.info("get {} anomalies took {} ms", (Object)anomalies.size(), (Object)(System.currentTimeMillis() - start));
        return anomalies;
    }

    public Map<UUID, List<Point>> getItemFieldValues(JwtSecurityUser user, DatasetConfig datasetConfig) {
        List dataset = (List)DonReactive.block((Mono)this.datasetFetcher.fetchDataset(user, datasetConfig).collectList());
        return switch (dataset.size()) {
            case 0 -> Collections.emptyMap();
            case 1 -> ((DataVector)dataset.get(0)).getPoints();
            default -> throw new TrendzInternalException("Multiple vectors loaded for field");
        };
    }

    public AnomalyPersistenceReport saveForReprocess(UUID modelId, Set<UUID> itemSet, List<Anomaly> anomalies, long saveFrom, long saveTo, long minAnomalyToSave) {
        return this.anomalyDao.saveForReprocess(modelId, itemSet, anomalies, saveFrom, saveTo, minAnomalyToSave);
    }

    public AnomalyPersistenceReport deleteAll(UUID modelId) {
        return this.anomalyDao.rewriteAll(modelId, Collections.emptyList());
    }

    public AnomalyPersistenceReport rewriteAll(UUID modelId, List<Anomaly> anomalies) {
        return this.anomalyDao.rewriteAll(modelId, anomalies);
    }

    public Mono<AnomalyReport> discoverAnomalies(JwtSecurityUser user, AnomalyModel anomalyModel, DatasetConfig datasetConfig) {
        datasetConfig.setMaxPointsCount(anomalyModel.getProperties().getSegmentSplitProperties().getMaxPointsCount());
        return this.datasetFetcher.fetchDataset(user, datasetConfig).map(dataVector -> {
            List<DataVector> dataset = Collections.singletonList(dataVector);
            AnomalyReport anomalyReport = this.detect(anomalyModel, dataset);
            List anomalies = anomalyReport.getAnomalyList();
            anomalies.forEach(a -> a.setModelId(anomalyModel.getId()));
            this.fillItemNames(anomalies, dataset);
            return anomalyReport;
        }).doOnError(error -> log.error("Could not detect anomalies for item", error)).reduce((Object)this.getEmptyAnomalyReport(), (arg_0, arg_1) -> this.merge(arg_0, arg_1));
    }

    public void populateAlarmId(Anomaly anomaly, UUID alarmId) {
        this.anomalyDao.populateAlarmId(anomaly, alarmId);
    }

    public Optional<Integer> getDefaultAnomalyScoreThreshold(UUID modelId) {
        return this.anomalyDao.getMinAnomalyScoreFotModel(modelId);
    }

    private AnomalyReport getEmptyAnomalyReport() {
        return new AnomalyReport(Collections.emptyList(), Collections.emptyMap());
    }

    private AnomalyReport merge(AnomalyReport a1, AnomalyReport a2) {
        ArrayList anomalies = new ArrayList();
        anomalies.addAll(a1.getAnomalyList());
        anomalies.addAll(a2.getAnomalyList());
        HashMap endOfSegmentMap = new HashMap();
        endOfSegmentMap.putAll(a1.getEndOfTheLastSegmentPerItem());
        endOfSegmentMap.putAll(a2.getEndOfTheLastSegmentPerItem());
        return new AnomalyReport(anomalies, endOfSegmentMap);
    }

    private AnomalyReport detect(AnomalyModel anomalyModel, List<DataVector> data) {
        if (ModelType.CLUSTERING.equals((Object)anomalyModel.getType())) {
            SegmentReport segmentReport = this.clusteringService.buildSegments(data, anomalyModel.getProperties());
            return new AnomalyReport(this.anomalyExtractor.buildAnomalies(anomalyModel, segmentReport.getSegmentList()), segmentReport.getEndOfTheLastSegmentPerItem());
        }
        throw new TrendzInternalException("model type not supported " + String.valueOf(anomalyModel.getType()));
    }

    private void fillItemNames(List<Anomaly> anomalies, List<DataVector> data) {
        Map<UUID, String> idToName = data.stream().collect(Collectors.toMap(DataVector::getItemId, DataVector::getItemName));
        anomalies.forEach(a -> a.setItemName((String)idToName.get(a.getItemId())));
    }
}

