/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.anomaly;

import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.anomaly.AnomalyModel;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityFieldQuery;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.entity.request.BusinessEntityFieldUpdateRequest;
import org.thingsboard.trendz.domain.definition.entity.request.BusinessEntityFieldUpdateRequestItem;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.BusinessEntityClient;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AnomalyModelAssociatedFieldService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnomalyModelAssociatedFieldService.class);
    private final BusinessEntityClient businessEntityClient;

    @Autowired
    public AnomalyModelAssociatedFieldService(BusinessEntityClient businessEntityClient) {
        this.businessEntityClient = businessEntityClient;
    }

    public void deleteAssociatedBusinessEntityFields(JwtSecurityUser user, AnomalyModel model) {
        this.deleteAssociatedBusinessEntityFields(user, model, model.getDatasetConfig().getBusinessEntityId());
    }

    public void deleteAssociatedBusinessEntityFields(JwtSecurityUser user, AnomalyModel model, UUID businessEntityId) {
        HashSet<UUID> entityFieldsToDelete = new HashSet<UUID>();
        if (model.getAnomalyScoreAssociatedFieldId() != null) {
            entityFieldsToDelete.add(model.getAnomalyScoreAssociatedFieldId());
        }
        if (model.getAnomalyScoreIndexAssociatedFieldId() != null) {
            entityFieldsToDelete.add(model.getAnomalyScoreIndexAssociatedFieldId());
        }
        this.businessEntityClient.deleteBusinessEntityFieldsById(user, businessEntityId, entityFieldsToDelete);
        model.setAnomalyScoreAssociatedFieldId(null);
        model.setAnomalyScoreIndexAssociatedFieldId(null);
    }

    public void createAssociatedBusinessEntityFields(JwtSecurityUser user, AnomalyModel model) {
        if (model.getAnomalyScoreAssociatedFieldId() == null) {
            model.setAnomalyScoreAssociatedFieldId(UUID.randomUUID());
        }
        if (model.getAnomalyScoreIndexAssociatedFieldId() == null) {
            model.setAnomalyScoreIndexAssociatedFieldId(UUID.randomUUID());
        }
        UUID businessEntityId = model.getDatasetConfig().getBusinessEntityId();
        BusinessEntityField anomalyScoreEntityField = this.getDefaultAnomalyScoreField(businessEntityId, model);
        BusinessEntityField anomalyScoreIndexEntityField = this.getDefaultAnomalyScoreIndexField(businessEntityId, model);
        this.businessEntityClient.createBusinessEntityFields(user, businessEntityId, List.of(anomalyScoreEntityField, anomalyScoreIndexEntityField));
    }

    public void changeAssociatedBusinessEntityFields(JwtSecurityUser user, AnomalyModel foundAnomalyModel, UUID oldBusinessEntity, UUID newBusinessEntity) {
        this.businessEntityClient.updateBusinessEntityFields(user, new BusinessEntityFieldUpdateRequest(oldBusinessEntity, newBusinessEntity, List.of(new BusinessEntityFieldUpdateRequestItem(foundAnomalyModel.getAnomalyScoreAssociatedFieldId(), foundAnomalyModel.getName() + " Score", AnomalyModelAssociatedFieldService.getScoreTbKey((String)foundAnomalyModel.getTbTelemetryKey()), this.getDefaultAnomalyScoreField(oldBusinessEntity, foundAnomalyModel)), new BusinessEntityFieldUpdateRequestItem(foundAnomalyModel.getAnomalyScoreIndexAssociatedFieldId(), foundAnomalyModel.getName() + " Score Index", AnomalyModelAssociatedFieldService.getScoreIndexTbKey((String)foundAnomalyModel.getTbTelemetryKey()), this.getDefaultAnomalyScoreIndexField(oldBusinessEntity, foundAnomalyModel)))));
    }

    public static String getScoreTbKey(String key) {
        return "_EAD_" + key;
    }

    public static String getScoreIndexTbKey(String key) {
        return "_EID_" + key;
    }

    private BusinessEntityField getDefaultAnomalyScoreField(UUID businessEntityId, AnomalyModel model) {
        return BusinessEntityField.builder().id(model.getAnomalyScoreAssociatedFieldId()).businessEntityId(businessEntityId).name(model.getName() + " Score").description("Telemetry field of anomaly model score created by Trendz.").hidden(false).type(FieldType.NUMERIC).query(new BusinessEntityFieldQuery(FieldQueryType.MODEL_ANOMALY_SCORE, AnomalyModelAssociatedFieldService.getScoreTbKey((String)model.getTbTelemetryKey()), null)).build();
    }

    private BusinessEntityField getDefaultAnomalyScoreIndexField(UUID businessEntityId, AnomalyModel model) {
        return BusinessEntityField.builder().id(model.getAnomalyScoreIndexAssociatedFieldId()).businessEntityId(businessEntityId).name(model.getName() + " Score Index").description("Telemetry field of anomaly model score index created by Trendz.").hidden(false).type(FieldType.NUMERIC).query(new BusinessEntityFieldQuery(FieldQueryType.MODEL_ANOMALY_SCORE_INDEX, AnomalyModelAssociatedFieldService.getScoreIndexTbKey((String)model.getTbTelemetryKey()), null)).build();
    }
}

