/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.migration;

import com.google.common.collect.Sets;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.dao.calculation.CalculationFieldDao;
import org.thingsboard.trendz.dao.calculation.CalculationFieldTaskDataDao;
import org.thingsboard.trendz.dao.model.prediction.PredictionModelLastItemPointDao;
import org.thingsboard.trendz.dao.model.prediction.segment.SegmentDataDao;
import org.thingsboard.trendz.domain.anomaly.Anomaly;
import org.thingsboard.trendz.domain.anomaly.AnomalyModel;
import org.thingsboard.trendz.domain.anomaly.AnomalyPersistenceReport;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldTaskData;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.relation.Relation;
import org.thingsboard.trendz.domain.definition.migration.HasId;
import org.thingsboard.trendz.domain.definition.migration.MigrationData;
import org.thingsboard.trendz.domain.definition.migration.MigrationDataMutableContent;
import org.thingsboard.trendz.domain.definition.migration.MigrationProperties;
import org.thingsboard.trendz.domain.definition.migration.TrendzEntity;
import org.thingsboard.trendz.domain.definition.view.config.CacheSettings;
import org.thingsboard.trendz.domain.definition.view.config.SavingCalculatedTelemetrySettings;
import org.thingsboard.trendz.domain.definition.view.config.ViewCollection;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.ViewCollectionService;
import org.thingsboard.trendz.service.ViewConfigService;
import org.thingsboard.trendz.service.assistance.customprompt.CustomPromptService;
import org.thingsboard.trendz.service.calculation.CalculationFieldService;
import org.thingsboard.trendz.service.chat.ChatService;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.definition.metadata.BusinessEntityFieldMetadataService;
import org.thingsboard.trendz.service.definition.metadata.BusinessEntityMetadataService;
import org.thingsboard.trendz.service.metric.MetricDefinitionService;
import org.thingsboard.trendz.service.model.anomaly.AnomalyModelService;
import org.thingsboard.trendz.service.model.anomaly.AnomalyService;
import org.thingsboard.trendz.service.model.anomaly.components.AnomalyFilter;
import org.thingsboard.trendz.service.model.prediction.PredictionModel;
import org.thingsboard.trendz.service.model.prediction.PredictionModelService;
import org.thingsboard.trendz.service.provider.cache.CacheConfigurationName;
import org.thingsboard.trendz.service.provider.cache.CacheService;
import org.thingsboard.trendz.service.sql.SqlDatasourceService;
import org.thingsboard.trendz.service.startup.UserInitializationService;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.task.TaskSequenceService;
import org.thingsboard.trendz.service.task.TaskService;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskReferencedEntityType;
import org.thingsboard.trendz.service.task.model.TaskScheduleType;
import org.thingsboard.trendz.service.user.UserMetadataService;
import org.thingsboard.trendz.tools.PaginationPage;

@Service
@Transactional
public class MigrationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationService.class);
    private final CacheService cacheService;
    private final BusinessEntityService businessEntityService;
    private final SqlDatasourceService sqlDatasourceService;
    private final ViewCollectionService viewCollectionService;
    private final ViewConfigService viewConfigService;
    private final CalculationFieldDao calculationFieldDao;
    private final CalculationFieldTaskDataDao calculationFieldTaskDataDao;
    private final CalculationFieldService calculationFieldService;
    private final PredictionModelService predictionModelService;
    private final PredictionModelLastItemPointDao predictionModelLastItemPointDao;
    private final SegmentDataDao segmentDataDao;
    private final AnomalyModelService anomalyModelService;
    private final AnomalyService anomalyService;
    private final TaskService taskService;
    private final UserInitializationService userInitializationService;
    private final TaskSequenceService taskSequenceService;
    private final ChatService chatService;
    private final CustomPromptService customPromptService;
    private final MetricDefinitionService metricDefinitionService;
    private final UserMetadataService userMetadataService;
    private final BusinessEntityMetadataService entityMetadataService;
    private final BusinessEntityFieldMetadataService fieldMetadataService;

    @Autowired
    public MigrationService(CacheService cacheService, BusinessEntityService businessEntityService, SqlDatasourceService sqlDatasourceService, ViewCollectionService viewCollectionService, ViewConfigService viewConfigService, CalculationFieldDao calculationFieldDao, CalculationFieldTaskDataDao calculationFieldTaskDataDao, CalculationFieldService calculationFieldService, PredictionModelService predictionModelService, PredictionModelLastItemPointDao predictionModelLastItemPointDao, SegmentDataDao segmentDataDao, AnomalyModelService anomalyModelService, AnomalyService anomalyService, TaskService taskService, UserInitializationService userInitializationService, TaskSequenceService taskSequenceService, ChatService chatService, CustomPromptService customPromptService, MetricDefinitionService metricDefinitionService, BusinessEntityFieldMetadataService fieldMetadataService, UserMetadataService userMetadataService, BusinessEntityMetadataService entityMetadataService) {
        this.cacheService = cacheService;
        this.businessEntityService = businessEntityService;
        this.sqlDatasourceService = sqlDatasourceService;
        this.viewCollectionService = viewCollectionService;
        this.viewConfigService = viewConfigService;
        this.calculationFieldDao = calculationFieldDao;
        this.calculationFieldTaskDataDao = calculationFieldTaskDataDao;
        this.calculationFieldService = calculationFieldService;
        this.predictionModelService = predictionModelService;
        this.predictionModelLastItemPointDao = predictionModelLastItemPointDao;
        this.segmentDataDao = segmentDataDao;
        this.anomalyModelService = anomalyModelService;
        this.anomalyService = anomalyService;
        this.taskService = taskService;
        this.userInitializationService = userInitializationService;
        this.taskSequenceService = taskSequenceService;
        this.chatService = chatService;
        this.customPromptService = customPromptService;
        this.metricDefinitionService = metricDefinitionService;
        this.userMetadataService = userMetadataService;
        this.entityMetadataService = entityMetadataService;
        this.fieldMetadataService = fieldMetadataService;
    }

    public MigrationData exportMigrationData(JwtSecurityUser user) {
        MigrationData migrationData = this.loadAllDataForMigration(user);
        this.removeExecutionsFromTasks(migrationData.getTasks());
        log.info("Migration: export action was done:\n{} business entities,\n{} sql datasource,\n{} view collections,\n{} view configs,\n{} calculation fields,\n{} anomaly models,\n{} prediction models,\n{} prediction model last item points,\n{} segment data,\n{} tasks were exported,\n{} task sequences were exported,\n{} chat were exported,\n{} chat messages were exported,\n{} prompts were exported,\n{} metric definitions exported,\n{} metric definition metadata exported,\n{} user metadata exported,\n{} business entity metadata exported,\n{} business entity field metadata exported.\n", new Object[]{migrationData.getBusinessEntities().size(), migrationData.getSqlDatasource().size(), migrationData.getViewCollections().size(), migrationData.getViewConfigs().size(), migrationData.getCalculationFields().size(), migrationData.getAnomalyModels().size(), migrationData.getPredictionModels().size(), migrationData.getModelToItemToLastPointMap().size(), migrationData.getSegmentData().size(), migrationData.getTasks().size(), migrationData.getTaskSequences().size(), migrationData.getChats().size(), migrationData.getChatMessages().size(), migrationData.getPrompts().size(), migrationData.getMetricDefinitions().size(), migrationData.getMetricDefinitionMetadata().size(), migrationData.getUserMetadata().size(), migrationData.getEntityMetadata().size(), migrationData.getFieldMetadata().size()});
        return migrationData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String importMigrationData(MigrationData importData, JwtSecurityUser user, TaskExecutionProgressStepBuilder progressBuilder) {
        MigrationDataMutableContent mutableContent = (MigrationDataMutableContent)progressBuilder.getStepContent(MigrationDataMutableContent.class);
        try {
            log.info("Migration has been started");
            MigrationProperties properties = importData.getProperties();
            MigrationData currentData = this.loadAllDataForMigration(user);
            this.verifyTenant(importData, user);
            if (Objects.isNull(properties) || !properties.isSkipDuplicates()) {
                this.throwIfDuplicateInData(currentData, importData);
                log.info("Migration duplicate check has been done!");
            } else {
                log.info("Migration duplicate check is disabled");
            }
            log.info("Migration preparation: remove invalid relation");
            this.removeInvalidRelations(importData.getBusinessEntities());
            log.info("Migration preparation: disable view config tasks");
            this.disableViewConfigTasks(importData.getViewConfigs());
            log.info("Migration preparation: make task map");
            Map referenceTaskMap = Optional.ofNullable(importData.getTasks()).orElse(Collections.emptyList()).stream().collect(Collectors.toMap(Task::getReference, Function.identity()));
            int savedBusinessEntities = (Integer)progressBuilder.makeStep("Migrate business entities", () -> this.migrateBusinessEntities(currentData, importData, user, mutableContent));
            int savedSqlDatasource = this.migrateSqlDatasource(currentData, importData, user);
            int savedViewCollections = this.migrateViewCollections(currentData, importData, user);
            int savedViewConfigs = this.migrateViewConfigs(currentData, importData, referenceTaskMap, user);
            int savedCalculationFields = this.migrateCalculationFields(currentData, importData, referenceTaskMap, user);
            int savedPredictionModels = this.migratePredictionModels(currentData, importData, referenceTaskMap, user);
            int savedSegmentData = this.migrateSegmentData(currentData, importData);
            int savedModels = this.migrateModelsAndAnomalies(currentData, importData, referenceTaskMap, user, mutableContent);
            int savedTaskSequences = this.migrateTaskSequences(currentData, importData, user);
            int savedChats = this.migrateChats(currentData, importData, referenceTaskMap, user);
            int savedChatMessages = this.migrateChatMessages(currentData, importData);
            int savedPrompts = this.migratePrompts(currentData, importData, referenceTaskMap, user);
            int savedMetricDefinitions = this.migrateMetricDefinitions(currentData, importData);
            int savedMetricDefinitionMetadata = this.migrateMetricDefinitionMetadata(currentData, importData);
            int savedUserMetadata = this.migrateUserMetadata(currentData, importData);
            int savedEntityMetadata = this.migrateEntityMetadata(currentData, importData);
            int savedFieldMetadata = this.migrateFieldMetadata(currentData, importData);
            this.userInitializationService.refreshInitStatus(user);
            log.info("Migration has been finished successfully!");
            String message = "Import action was done:\nbusiness entities               %s,\nsql datasource                  %s,\nview collections                %s,\nview configs                    %s,\ncalculation fields              %s,\nprediction models               %s,\nsegment data                    %s,\nanomaly models                  %s,\ntask sequences                  %s,\nchats                           %s,\nchat messages                   %s,\nprompts                         %s,\nmetric definitions              %s,\nmetric definition metadata      %s,\nuser metadata                   %s,\nbusiness entity metadata        %s,\nbusiness entity field metadata  %s.\n".formatted(savedBusinessEntities, savedSqlDatasource, savedViewCollections, savedViewConfigs, savedCalculationFields, savedPredictionModels, savedSegmentData, savedModels, savedTaskSequences, savedChats, savedChatMessages, savedPrompts, savedMetricDefinitions, savedMetricDefinitionMetadata, savedUserMetadata, savedEntityMetadata, savedFieldMetadata);
            log.info(message);
            String string = message;
            return string;
        }
        finally {
            this.cacheService.clearCaches(CacheConfigurationName.tenantInitStatusCacheName);
            this.cacheService.clearCaches(CacheConfigurationName.topologyStorageCacheName);
        }
    }

    private void verifyTenant(MigrationData importData, JwtSecurityUser user) {
        this.throwIfInvalidTenant(importData.getBusinessEntities(), user, "business entity");
        this.throwIfInvalidTenant(importData.getViewCollections(), user, "view collection");
        this.throwIfInvalidTenant(importData.getViewConfigs(), user, "view config");
        this.throwIfInvalidTenant(importData.getCalculationFields(), user, "calculation field");
        this.throwIfInvalidTenant(importData.getAnomalyModels(), user, "anomaly model");
        this.throwIfInvalidTenant(importData.getPredictionModels(), user, "prediction model");
        this.throwIfInvalidTenant(importData.getTasks(), user, "task");
        this.throwIfInvalidTenant(importData.getTaskSequences(), user, "task sequence");
        this.throwIfInvalidTenant(importData.getChats(), user, "chat");
        this.throwIfInvalidTenant(importData.getPrompts(), user, "prompt");
        this.throwIfInvalidTenant(importData.getMetricDefinitions(), user, "metric definition");
        this.throwIfInvalidTenant(importData.getMetricDefinitionMetadata(), user, "metric definition metadata");
        this.throwIfInvalidTenant(importData.getUserMetadata(), user, "user metadata");
        this.throwIfInvalidTenant(importData.getEntityMetadata(), user, "business entity metadata");
        this.throwIfInvalidTenant(importData.getFieldMetadata(), user, "business entity field metadata");
    }

    private <T extends TrendzEntity> void throwIfInvalidTenant(List<T> imported, JwtSecurityUser user, String message) {
        if (imported == null) {
            return;
        }
        imported.stream().filter(t -> !user.getTenantId().equals(t.getTenantId())).findAny().ifPresent(t -> {
            throw new TrendzException("The %s has foreign tenant, item = %s".formatted(message, t.getName()));
        });
    }

    private void throwIfDuplicateInData(MigrationData current, MigrationData imported) {
        this.throwIfDuplicate(current.getBusinessEntities(), imported.getBusinessEntities(), "business entities");
        this.throwIfDuplicate(current.getSqlDatasource(), imported.getSqlDatasource(), "sql datasource");
        this.throwIfDuplicate(current.getViewCollections(), imported.getViewCollections(), "view collections entities");
        this.throwIfDuplicate(current.getViewConfigs(), imported.getViewConfigs(), "view configs");
        this.throwIfDuplicate(current.getCalculationFields(), imported.getCalculationFields(), "calculation field entities");
        this.throwIfDuplicate(current.getAnomalyModels(), imported.getAnomalyModels(), "cluster anomalyModel entities");
        this.throwIfDuplicate(current.getPredictionModels(), imported.getPredictionModels(), "prediction models");
        this.throwIfDuplicate(current.getSegmentData(), imported.getSegmentData(), "segment data");
        this.throwIfDuplicate(current.getTaskSequences(), imported.getTaskSequences(), "task sequences");
        this.throwIfDuplicate(current.getChats(), imported.getChats(), "chat");
        this.throwIfDuplicate(current.getChatMessages(), imported.getChatMessages(), "chat message");
        this.throwIfDuplicate(current.getPrompts(), imported.getPrompts(), "prompt");
        this.throwIfDuplicate(current.getMetricDefinitions(), imported.getMetricDefinitions(), "metric definition");
        this.throwIfDuplicate(current.getMetricDefinitionMetadata(), imported.getMetricDefinitionMetadata(), "metric definition metadata");
        this.throwIfDuplicate(current.getUserMetadata(), imported.getUserMetadata(), "user metadata");
        this.throwIfDuplicate(current.getEntityMetadata(), imported.getEntityMetadata(), "business entity metadata");
        this.throwIfDuplicate(current.getFieldMetadata(), imported.getFieldMetadata(), "business entity field metadata");
    }

    private <T extends HasId> void throwIfDuplicate(List<T> current, List<T> imported, String message) {
        Set importedIds;
        if (imported == null) {
            return;
        }
        Set currentIds = current.stream().map(HasId::getId).collect(Collectors.toSet());
        Sets.SetView intersection = Sets.intersection(currentIds, importedIds = imported.stream().map(HasId::getId).collect(Collectors.toSet()));
        if (!intersection.isEmpty()) {
            throw new TrendzException("There are duplicates in " + message + ".");
        }
    }

    private void processTaskReferences(JwtSecurityUser user, Set<TaskReferencedEntityType> jobTypes, Map<TaskReference, Task> referenceTaskMap, String entityTypeName, TrendzEntity entity) {
        Consumer<Task> onPresentConsumer = task -> {
            String message = String.format("The task with the current reference is already exists, reference = %s, %s = %s", task.getReference().getType(), entityTypeName, entity.getName());
            throw new TrendzException(message);
        };
        Consumer<TaskReference> onEmptyConsumer = reference -> {
            Task task = (Task)referenceTaskMap.get(reference);
            if (task != null) {
                task.setExecutions(Collections.emptyList());
                if (task.getSchedule().getType() != TaskScheduleType.NONE) {
                    task.setEnabled(false);
                }
                this.taskService.rawSave(task);
            }
        };
        jobTypes.stream().map(entityType -> new TaskReference(entityType, entity.getId().toString())).forEach(reference -> this.taskService.findTaskByReferencedEntity(user, reference).ifPresentOrElse(onPresentConsumer, () -> onEmptyConsumer.accept((TaskReference)reference)));
    }

    private <T extends HasId> int migrateEntities(String name, List<T> current, List<T> imported, UnaryOperator<List<T>> saveFunction) {
        log.info("Migration entities: {}", (Object)name);
        if (imported == null || imported.isEmpty()) {
            return 0;
        }
        Set currentEntities = current.stream().map(HasId::getId).collect(Collectors.toSet());
        List<HasId> newEntities = imported.stream().filter(importedEntity -> !currentEntities.contains(importedEntity.getId())).toList();
        List saved = (List)saveFunction.apply(newEntities);
        return saved.size();
    }

    private int migrateBusinessEntities(MigrationData currentData, MigrationData importData, JwtSecurityUser user, MigrationDataMutableContent content) {
        return this.migrateEntities("business entities", currentData.getBusinessEntities(), importData.getBusinessEntities(), newEntities -> {
            content.businessEntities().detected().set(newEntities.size());
            List saved = this.businessEntityService.saveAllEntities(newEntities, user);
            content.businessEntities().imported().set(saved.size());
            return saved;
        });
    }

    private int migrateSqlDatasource(MigrationData currentData, MigrationData importData, JwtSecurityUser user) {
        return this.migrateEntities("sql datasource", currentData.getSqlDatasource(), importData.getSqlDatasource(), newEntities -> this.sqlDatasourceService.saveAll(newEntities, user));
    }

    private int migrateViewCollections(MigrationData currentData, MigrationData importData, JwtSecurityUser user) {
        UnaryOperator saveFunction = newEntities -> {
            Set allCollectionsIdSet = Stream.concat(Stream.of(currentData, importData).map(MigrationData::getViewCollections).flatMap(Collection::stream).map(ViewCollection::getId), Stream.of(EntityId.NULL_UUID)).collect(Collectors.toSet());
            newEntities.stream().filter(collection -> !allCollectionsIdSet.contains(collection.getParentId())).findAny().ifPresent(collection -> {
                throw new TrendzException("The collection parent is not present, current = " + collection.getName());
            });
            return this.saveCollectionRecursively(newEntities, user);
        };
        return this.migrateEntities("view collections", currentData.getViewCollections(), importData.getViewCollections(), saveFunction);
    }

    private int migrateViewConfigs(MigrationData currentData, MigrationData importData, Map<TaskReference, Task> referenceTaskMap, JwtSecurityUser user) {
        Set<TaskReferencedEntityType> viewJobTypes = Set.of(TaskReferencedEntityType.VIEW_CONFIG_BUILD_VIEW, TaskReferencedEntityType.VIEW_CONFIG_FILTER_REQUEST, TaskReferencedEntityType.VIEW_CONFIG_AI_SUMMARY_TASK, TaskReferencedEntityType.VIEW_CONFIG_CACHE_TASK, TaskReferencedEntityType.VIEW_CONFIG_SAVE_TO_TB_TASK);
        UnaryOperator saveFunction = newEntities -> newEntities.stream().peek(viewConfig -> this.processTaskReferences(user, viewJobTypes, referenceTaskMap, "view config", (TrendzEntity)viewConfig)).map(viewConfig -> this.viewConfigService.saveConfig(user, viewConfig)).peek(saved -> log.debug("Imported view config: {}", (Object)saved.getName())).toList();
        return this.migrateEntities("view configs", currentData.getViewConfigs(), importData.getViewConfigs(), saveFunction);
    }

    private int migrateCalculationFields(MigrationData currentData, MigrationData importData, Map<TaskReference, Task> referenceTaskMap, JwtSecurityUser user) {
        Set<TaskReferencedEntityType> calculationJobTypes = Set.of(TaskReferencedEntityType.CALCULATION_FIELD_TEST, TaskReferencedEntityType.CALCULATION_FIELD_REPROCESS, TaskReferencedEntityType.CALCULATION_FIELD_REFRESH);
        UnaryOperator saveFunction = newEntities -> newEntities.stream().peek(field -> this.processTaskReferences(user, calculationJobTypes, referenceTaskMap, "calculation field", (TrendzEntity)field)).peek(field -> field.setEnabled(false)).peek(arg_0 -> ((CalculationFieldDao)this.calculationFieldDao).save(arg_0)).peek(field -> this.calculationFieldTaskDataDao.save(CalculationFieldTaskData.getDefault((UUID)field.getId()))).map(field -> this.calculationFieldService.save(user, field)).peek(saved -> log.debug("Imported calculation field: {}", (Object)saved.getName())).toList();
        return this.migrateEntities("calculation fields", currentData.getCalculationFields(), importData.getCalculationFields(), saveFunction);
    }

    private int migratePredictionModels(MigrationData currentData, MigrationData importData, Map<TaskReference, Task> referenceTaskMap, JwtSecurityUser user) {
        Set<TaskReferencedEntityType> predictionJobTypes = Set.of(TaskReferencedEntityType.PREDICTION_MODEL_TRAIN, TaskReferencedEntityType.PREDICTION_MODEL_REFRESH, TaskReferencedEntityType.PREDICTION_MODEL_ACCURACY);
        UnaryOperator saveFunction = newEntities -> {
            Set newModelIdSet = newEntities.stream().map(PredictionModel::getId).collect(Collectors.toSet());
            List<PredictionModel> savedModels = newEntities.stream().peek(model -> this.processTaskReferences(user, predictionJobTypes, referenceTaskMap, "prediction model", (TrendzEntity)model)).map(model -> this.predictionModelService.importModel(user, model)).peek(saved -> log.debug("Imported prediction model: {}", (Object)saved.getName())).toList();
            Map<UUID, Map> modelToItemToLastPointMap = importData.getModelToItemToLastPointMap().entrySet().stream().filter(entry -> newModelIdSet.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            this.predictionModelLastItemPointDao.saveAll(user, modelToItemToLastPointMap);
            return savedModels;
        };
        return this.migrateEntities("prediction models", currentData.getPredictionModels(), importData.getPredictionModels(), saveFunction);
    }

    private int migrateSegmentData(MigrationData currentData, MigrationData importData) {
        return this.migrateEntities("segment data", currentData.getSegmentData(), importData.getSegmentData(), arg_0 -> ((SegmentDataDao)this.segmentDataDao).saveAll(arg_0));
    }

    private int migrateModelsAndAnomalies(MigrationData currentData, MigrationData importData, Map<TaskReference, Task> referenceTaskMap, JwtSecurityUser user, MigrationDataMutableContent content) {
        Map allImportedAnomaliesMap = importData.getAnomalyMap() == null ? Collections.emptyMap() : importData.getAnomalyMap();
        return this.migrateEntities("anomaly models", currentData.getAnomalyModels(), importData.getAnomalyModels(), newEntities -> this.migrateModelsAndAnomalies(newEntities, allImportedAnomaliesMap, referenceTaskMap, user, content));
    }

    private List<AnomalyModel> migrateModelsAndAnomalies(List<AnomalyModel> newEntities, Map<UUID, List<Anomaly>> allImportedAnomaliesMap, Map<TaskReference, Task> referenceTaskMap, JwtSecurityUser user, MigrationDataMutableContent content) {
        Set<TaskReferencedEntityType> anomalyJobTypes = Set.of(TaskReferencedEntityType.ANOMALY_MODEL_BUILD, TaskReferencedEntityType.ANOMALY_MODEL_REPROCESS, TaskReferencedEntityType.ANOMALY_MODEL_REFRESH);
        content.countDetectedAnomalyModels(newEntities, allImportedAnomaliesMap);
        return newEntities.stream().map(model -> {
            this.processTaskReferences(user, anomalyJobTypes, referenceTaskMap, "anomaly model", (TrendzEntity)model);
            return this.anomalyModelService.saveModel(user, model, false, false);
        }).peek(saved -> {
            this.anomalyModelService.createTasks(user, saved);
            AnomalyPersistenceReport report = this.anomalyService.rewriteAll(saved.getId(), allImportedAnomaliesMap.getOrDefault(saved.getId(), Collections.emptyList()));
            content.countImportedAnomalyModels(report);
            log.debug("Imported anomaly model: {}", (Object)saved.getName());
        }).toList();
    }

    private int migrateTaskSequences(MigrationData currentData, MigrationData importData, JwtSecurityUser user) {
        return this.migrateEntities("task sequences", currentData.getTaskSequences(), importData.getTaskSequences(), newEntities -> this.taskSequenceService.importAll(user, newEntities));
    }

    private int migrateChats(MigrationData currentData, MigrationData importData, Map<TaskReference, Task> referenceTaskMap, JwtSecurityUser user) {
        Set<TaskReferencedEntityType> chatJobType = Set.of(TaskReferencedEntityType.CHAT_MESSAGE_PROCESS_TASK);
        UnaryOperator saveFunction = newEntities -> {
            newEntities.forEach(chat -> this.processTaskReferences(user, chatJobType, referenceTaskMap, "chat", (TrendzEntity)chat));
            return this.chatService.importAllChats(user, newEntities);
        };
        return this.migrateEntities("chats", currentData.getChats(), importData.getChats(), saveFunction);
    }

    private int migrateChatMessages(MigrationData currentData, MigrationData importData) {
        return this.migrateEntities("chat messages", currentData.getChatMessages(), importData.getChatMessages(), arg_0 -> ((ChatService)this.chatService).importAllChatMessages(arg_0));
    }

    private int migratePrompts(MigrationData currentData, MigrationData importData, Map<TaskReference, Task> referenceTaskMap, JwtSecurityUser user) {
        Set<TaskReferencedEntityType> promptJobType = Set.of(TaskReferencedEntityType.AI_PROMPT_EXECUTION_TASK);
        UnaryOperator saveFunction = newEntities -> {
            newEntities.forEach(prompt -> this.processTaskReferences(user, promptJobType, referenceTaskMap, "prompt", (TrendzEntity)prompt));
            return this.customPromptService.importAllPrompts(newEntities);
        };
        return this.migrateEntities("prompts", currentData.getPrompts(), importData.getPrompts(), saveFunction);
    }

    private int migrateMetricDefinitions(MigrationData currentData, MigrationData importData) {
        return this.migrateEntities("metric definitions", currentData.getMetricDefinitions(), importData.getMetricDefinitions(), arg_0 -> ((MetricDefinitionService)this.metricDefinitionService).importAllMetricDefinitions(arg_0));
    }

    private int migrateMetricDefinitionMetadata(MigrationData currentData, MigrationData importData) {
        return this.migrateEntities("metric definition metadata", currentData.getMetricDefinitionMetadata(), importData.getMetricDefinitionMetadata(), arg_0 -> ((MetricDefinitionService)this.metricDefinitionService).importAllMetricDefinitionMetadata(arg_0));
    }

    private int migrateUserMetadata(MigrationData currentData, MigrationData importData) {
        return this.migrateEntities("user metadata", currentData.getUserMetadata(), importData.getUserMetadata(), arg_0 -> ((UserMetadataService)this.userMetadataService).saveAll(arg_0));
    }

    private int migrateEntityMetadata(MigrationData currentData, MigrationData importData) {
        return this.migrateEntities("business entity metadata", currentData.getEntityMetadata(), importData.getEntityMetadata(), arg_0 -> ((BusinessEntityMetadataService)this.entityMetadataService).saveAll(arg_0));
    }

    private int migrateFieldMetadata(MigrationData currentData, MigrationData importData) {
        return this.migrateEntities("business entity field metadata", currentData.getFieldMetadata(), importData.getFieldMetadata(), arg_0 -> ((BusinessEntityFieldMetadataService)this.fieldMetadataService).saveAll(arg_0));
    }

    private MigrationData loadAllDataForMigration(JwtSecurityUser user) {
        List exportedBusinessEntities = this.businessEntityService.getAllEntities(user);
        List sqlDatasource = this.sqlDatasourceService.findAll(user);
        ArrayList exportedViewCollections = new ArrayList(this.viewCollectionService.getAllCollections(user));
        ArrayList exportedViewConfigs = new ArrayList(this.viewConfigService.getAllConfigs(user));
        List exportedCalculationFields = this.calculationFieldService.getAll(user);
        List exportedPredictionModels = this.predictionModelService.getAll(user);
        Map modelToItemToLastPointMap = this.predictionModelLastItemPointDao.loadAll(user);
        List exportedSegmentData = this.segmentDataDao.getAll(user);
        List taskSequences = this.taskSequenceService.exportAll(user);
        List chats = this.chatService.getAllChats(user);
        List chatMessages = this.chatService.getAllChatMessages(user);
        List prompts = this.customPromptService.getAllNonSystemPrompts(user);
        List metricDefinitions = this.metricDefinitionService.getAllMetricDefinitions(user);
        List metricDefinitionMetadata = this.metricDefinitionService.getAllMetricDefinitionMetadata(user);
        List userMetadata = this.userMetadataService.getAll(user);
        List entityMetadata = this.entityMetadataService.getAll(user);
        List fieldMetadata = this.fieldMetadataService.getAll(user);
        List exportedAnomalyModels = this.anomalyModelService.getAll(user);
        Set anomalyModelIds = exportedAnomalyModels.stream().map(AnomalyModel::getId).collect(Collectors.toSet());
        AnomalyFilter anomalyFilter = new AnomalyFilter(null, anomalyModelIds, null, null, null);
        Map anomalyMap = this.anomalyService.findAnomaliesByFilter(anomalyFilter).stream().collect(Collectors.groupingBy(Anomaly::getModelId, Collectors.toList()));
        PaginationPage exportedTasksPage = new PaginationPage(this.taskService.getAllTasks(user, 0, 10000000, Collections.emptyList(), Collections.emptyList()));
        List<Task> exportedTasks = exportedTasksPage.getContent().stream().filter(task -> task.getJobType() != TaskJobType.MIGRATION_IMPORT).toList();
        return MigrationData.builder().properties(null).businessEntities(exportedBusinessEntities).sqlDatasource(sqlDatasource).viewCollections(exportedViewCollections).viewConfigs(exportedViewConfigs).calculationFields(exportedCalculationFields).predictionModels(exportedPredictionModels).modelToItemToLastPointMap(modelToItemToLastPointMap).segmentData(exportedSegmentData).anomalyModels(exportedAnomalyModels).anomalyMap(anomalyMap).tasks(exportedTasks).taskSequences(taskSequences).chats(chats).chatMessages(chatMessages).prompts(prompts).metricDefinitions(metricDefinitions).metricDefinitionMetadata(metricDefinitionMetadata).userMetadata(userMetadata).entityMetadata(entityMetadata).fieldMetadata(fieldMetadata).build();
    }

    private void removeExecutionsFromTasks(List<Task> tasks) {
        tasks.stream().map(Task::getExecutions).forEach(List::clear);
    }

    private void removeInvalidRelations(List<BusinessEntity> importedBusinessEntities) {
        Set importedEntityIdSet = importedBusinessEntities.stream().map(BusinessEntity::getId).collect(Collectors.toSet());
        for (BusinessEntity businessEntity : importedBusinessEntities) {
            List relations = businessEntity.getRelations();
            if (relations == null) continue;
            ArrayList<Relation> invalidRelations = new ArrayList<Relation>();
            for (Relation relation : relations) {
                if (importedEntityIdSet.contains(relation.getRelatedEntityId())) continue;
                invalidRelations.add(relation);
            }
            relations.removeAll(invalidRelations);
        }
    }

    private void disableViewConfigTasks(List<ViewConfig> viewConfigs) {
        for (ViewConfig viewConfig : viewConfigs) {
            if (viewConfig.getCacheSettings() == null) {
                viewConfig.setCacheSettings(CacheSettings.getDefaultSettings());
            } else {
                viewConfig.getCacheSettings().setAutoRefreshCache(false);
            }
            if (viewConfig.getSavingCalculatedTelemetrySettings() == null) {
                viewConfig.setSavingCalculatedTelemetrySettings(SavingCalculatedTelemetrySettings.getDefaultSettings());
                continue;
            }
            viewConfig.getSavingCalculatedTelemetrySettings().setEnable(false);
        }
    }

    private List<ViewCollection> saveCollectionRecursively(List<ViewCollection> importedViewCollections, JwtSecurityUser user) {
        if (importedViewCollections.isEmpty()) {
            return importedViewCollections;
        }
        Map idToCollectionMap = importedViewCollections.stream().collect(Collectors.toMap(ViewCollection::getId, Function.identity()));
        Map<UUID, Boolean> collectionIdToFlagMap = importedViewCollections.stream().collect(Collectors.toMap(ViewCollection::getId, i -> false));
        ArrayList<ViewCollection> savedViewCollections = new ArrayList<ViewCollection>();
        for (ViewCollection viewCollection : importedViewCollections) {
            if (collectionIdToFlagMap.get(viewCollection.getId()).booleanValue()) continue;
            LinkedList<ViewCollection> collectionQueue = new LinkedList<ViewCollection>();
            ViewCollection iterator = viewCollection;
            while (iterator != null && !collectionIdToFlagMap.get(iterator.getId()).booleanValue()) {
                collectionQueue.add(iterator);
                iterator = (ViewCollection)idToCollectionMap.get(iterator.getParentId());
            }
            while (!collectionQueue.isEmpty()) {
                iterator = (ViewCollection)collectionQueue.pollLast();
                ViewCollection saved = this.viewCollectionService.saveCollection(user, iterator);
                savedViewCollections.add(saved);
                collectionIdToFlagMap.put(saved.getId(), true);
            }
        }
        return savedViewCollections;
    }
}

