/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.metric.topology;

import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.entity.relation.Relation;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.BusinessEntityService;

@Service
public class TopologyDetailsService {
    private final BusinessEntityService businessEntityService;

    @Autowired
    public TopologyDetailsService(BusinessEntityService businessEntityService) {
        this.businessEntityService = businessEntityService;
    }

    public String mapWideTopologyForItem(UUID baseBusinessEntityId, JwtSecurityUser user) {
        List allEntities = this.businessEntityService.getAllEntities(user);
        Map sourceMap = allEntities.stream().collect(Collectors.toMap(BusinessEntity::getId, Function.identity()));
        HashSet<UUID> visited = new HashSet<UUID>();
        LinkedList<UUID> toVisit = new LinkedList<UUID>();
        toVisit.push(baseBusinessEntityId);
        StringBuilder result = new StringBuilder();
        while (!toVisit.isEmpty()) {
            BusinessEntity nextEntity = (BusinessEntity)sourceMap.get(toVisit.pop());
            visited.add(nextEntity.getId());
            nextEntity.getRelations().stream().map(Relation::getRelatedEntityId).filter(sourceMap::containsKey).filter(id -> !visited.contains(id) && !toVisit.contains(id)).forEach(toVisit::push);
            result.append(this.mapBusinessEntityToString(nextEntity, sourceMap));
        }
        return result.toString();
    }

    private String mapBusinessEntityToString(BusinessEntity businessEntity, Map<UUID, BusinessEntity> sourceMap) {
        String relations;
        String fields;
        StringBuilder stringBuilder = new StringBuilder().append("------------------\nProfile: %s (%s)\n".formatted(businessEntity.getName(), businessEntity.getQuery().getEntityType()));
        if (businessEntity.getDescription() != null && !businessEntity.getDescription().isEmpty()) {
            stringBuilder.append("Description: %s\n".formatted(businessEntity.getDescription()));
        }
        if (!(fields = this.mapBusinessEntityFields(businessEntity.getFields())).isEmpty()) {
            stringBuilder.append("\nFields: %s\n".formatted(fields));
        }
        if (!(relations = this.mapRelations(businessEntity.getRelations(), sourceMap)).isEmpty()) {
            stringBuilder.append("\nRelations: %s\n".formatted(relations));
        }
        return stringBuilder.toString();
    }

    private String mapBusinessEntityFields(List<BusinessEntityField> businessEntityFields) {
        return businessEntityFields.stream().filter(businessEntityField -> businessEntityField.getQuery().hasTime() || businessEntityField.getQuery().getQueryType() == FieldQueryType.ATTRIBUTE).sorted(Comparator.comparing(businessEntityField -> businessEntityField.getQuery().getQueryType().name())).map(arg_0 -> this.mapBusinessEntityField(arg_0)).collect(Collectors.joining());
    }

    private String mapBusinessEntityField(BusinessEntityField businessEntityField) {
        FieldQueryType queryType = businessEntityField.getQuery().getQueryType();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n\tType: %s %s".formatted(businessEntityField.getType(), businessEntityField.getQuery().hasTime() ? FieldQueryType.TELEMETRY : FieldQueryType.ATTRIBUTE));
        if (queryType != FieldQueryType.TELEMETRY && queryType != FieldQueryType.ATTRIBUTE) {
            stringBuilder.append(" (%s)".formatted(businessEntityField.getQuery().getQueryType()));
        }
        stringBuilder.append("\n");
        if (businessEntityField.getDescription() != null && !businessEntityField.getDescription().isEmpty()) {
            stringBuilder.append("    Description: \"%s\"\n".formatted(businessEntityField.getDescription().replace("\n", "\\n")));
        }
        stringBuilder.append("    Field TB Key: \"%s\"\n".formatted(businessEntityField.getQuery().getKey()));
        if (businessEntityField.getQuery().getQueryType().equals((Object)FieldQueryType.ATTRIBUTE)) {
            stringBuilder.append("    Scope: \"%s\"\n".formatted(businessEntityField.getQuery().getScope()));
        }
        return stringBuilder.toString();
    }

    private String mapRelations(List<Relation> relations, Map<UUID, BusinessEntity> sourceMap) {
        return relations.stream().filter(relation -> sourceMap.containsKey(relation.getRelatedEntityId())).map(relation -> this.mapRelation(relation, (BusinessEntity)sourceMap.get(relation.getRelatedEntityId()))).collect(Collectors.joining());
    }

    private String mapRelation(Relation relation, BusinessEntity associatedBe) {
        return "\n    Direction: %s (\"%s\")\n    Target Entity Type: \"%s\" (%s)\n".formatted(relation.getDirection(), relation.getRelationType(), associatedBe.getName(), associatedBe.getQuery().getEntityType());
    }
}

