/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.metric.item.configmaker;

import java.time.ZoneId;
import java.util.HashMap;
import java.util.UUID;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.definition.view.config.ViewType;
import org.thingsboard.trendz.domain.metric.item.pattern.TimePatternGroupingConfig;
import org.thingsboard.trendz.domain.metric.item.pattern.TimePatternGroupingType;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.tools.BusinessEntityUtils;
import org.thingsboard.trendz.tools.ViewConfigUtils;

public abstract class TimePatternConfigMaker {
    private final BusinessEntityService businessEntityService;

    public TimePatternConfigMaker(BusinessEntityService businessEntityService) {
        this.businessEntityService = businessEntityService;
    }

    public abstract TimePatternGroupingType getType();

    public abstract ViewConfig makeViewConfig(JwtSecurityUser var1, TimePatternGroupingConfig var2, UUID var3, ItemLite var4, ZoneId var5);

    protected ViewConfig makeTemplateConfig(JwtSecurityUser user, TimePatternGroupingConfig config, UUID entityFieldId, ItemLite itemLite, ZoneId zoneId) {
        DatePickerConfig datePickerConfig = config.getDatePickerConfig();
        FieldAggregation fieldAggregation = config.getFieldAggregation();
        BusinessEntityField entityField = this.businessEntityService.findEntityFieldById(user, entityFieldId);
        BusinessEntity businessEntity = this.businessEntityService.findEntityById(user, entityField.getBusinessEntityId());
        BusinessEntityField nameField = BusinessEntityUtils.findNameField((BusinessEntity)businessEntity, (JwtSecurityUser)user);
        ViewConfig viewConfig = new ViewConfig();
        viewConfig.setName("Metric Explorer, Time Pattern view config: " + String.valueOf(this.getType()));
        viewConfig.setDatePickerConfig(datePickerConfig);
        viewConfig.setTzName(zoneId.toString());
        viewConfig.setDatasetEnableMap(new HashMap());
        viewConfig.setDatasetItemMap(new HashMap());
        viewConfig.setDatasetDataMap(new HashMap());
        viewConfig.setViewType(ViewType.TABLE);
        ViewField telemetryField = new ViewField();
        telemetryField.setId(TimeStampUUIDGenerator.generateId());
        telemetryField.setLabel("Metric Explorer, Telemetry field");
        telemetryField.setBusinessEntityId(entityField.getBusinessEntityId());
        telemetryField.setEntityFieldId(entityField.getId());
        telemetryField.setAggregationType(fieldAggregation);
        ViewConfigUtils.addItemFilter((BusinessEntityField)nameField, (ViewConfig)viewConfig, (ItemLite)itemLite, (String)"Metric Explorer: Time Patterns: Filter by item name");
        viewConfig.getXAxis().add(telemetryField);
        return viewConfig;
    }

    protected void addDateField(ViewConfig viewConfig, DateAggregationType dateAggregationType) {
        ViewConfigUtils.addDateField((ViewConfig)viewConfig, (DateAggregationType)dateAggregationType, (String)"Metric Explorer: Time Patterns: Date field (%s)".formatted(dateAggregationType));
    }

    protected void setViewType(ViewConfig viewConfig, ViewType type) {
        viewConfig.setViewType(type);
    }
}

